/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.postgres;

import com.google.common.base.Preconditions;
import java.util.function.Function;
import org.jooq.DDLQuery;
import org.jooq.DSLContext;

public class PostgresIndex {
    private final String name;
    private final Function<DSLContext, DDLQuery> createIndexStepFunction;

    public static RequireCreateIndexStep name(String indexName) {
        Preconditions.checkNotNull((Object)indexName);
        String strategyIndexName = indexName.toLowerCase();
        return createIndexFunction -> new PostgresIndex(strategyIndexName, dsl -> createIndexFunction.createIndex((DSLContext)dsl, strategyIndexName));
    }

    private PostgresIndex(String name, Function<DSLContext, DDLQuery> createIndexStepFunction) {
        this.name = name;
        this.createIndexStepFunction = createIndexStepFunction;
    }

    public String getName() {
        return this.name;
    }

    public Function<DSLContext, DDLQuery> getCreateIndexStepFunction() {
        return this.createIndexStepFunction;
    }

    @FunctionalInterface
    public static interface RequireCreateIndexStep {
        public PostgresIndex createIndexStep(CreateIndexFunction var1);
    }

    @FunctionalInterface
    public static interface CreateIndexFunction {
        public DDLQuery createIndex(DSLContext var1, String var2);
    }
}

