/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.postgres.utils;

import io.r2dbc.pool.ConnectionPool;
import io.r2dbc.pool.ConnectionPoolConfiguration;
import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import org.apache.james.backends.postgres.RowLevelSecurity;
import org.apache.james.backends.postgres.utils.JamesPostgresConnectionFactory;
import org.apache.james.core.Domain;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class PoolBackedPostgresConnectionFactory
implements JamesPostgresConnectionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(PoolBackedPostgresConnectionFactory.class);
    private static final int DEFAULT_INITIAL_SIZE = 10;
    private static final int DEFAULT_MAX_SIZE = 20;
    private final RowLevelSecurity rowLevelSecurity;
    private final ConnectionPool pool;

    public PoolBackedPostgresConnectionFactory(RowLevelSecurity rowLevelSecurity, int initialSize, int maxSize, ConnectionFactory connectionFactory) {
        this.rowLevelSecurity = rowLevelSecurity;
        ConnectionPoolConfiguration configuration = ConnectionPoolConfiguration.builder((ConnectionFactory)connectionFactory).initialSize(initialSize).maxSize(maxSize).build();
        LOGGER.info("Creating new postgres ConnectionPool with initialSize {} and maxSize {}", (Object)initialSize, (Object)maxSize);
        this.pool = new ConnectionPool(configuration);
    }

    public PoolBackedPostgresConnectionFactory(RowLevelSecurity rowLevelSecurity, ConnectionFactory connectionFactory) {
        this(rowLevelSecurity, 10, 20, connectionFactory);
    }

    @Override
    public Mono<Connection> getConnection(Domain domain) {
        if (this.rowLevelSecurity.isRowLevelSecurityEnabled()) {
            return this.pool.create().flatMap(connection -> this.setDomainAttributeForConnection(domain.asString(), (Connection)connection));
        }
        return this.pool.create();
    }

    @Override
    public Mono<Connection> getConnection() {
        return this.pool.create();
    }

    @Override
    public Mono<Void> closeConnection(Connection connection) {
        return Mono.from((Publisher)connection.close());
    }

    @Override
    public Mono<Void> close() {
        return this.pool.close();
    }

    private Mono<Connection> setDomainAttributeForConnection(String domainAttribute, Connection connection) {
        return Mono.from((Publisher)connection.createStatement("SET app.current_domain TO '" + domainAttribute + "'").execute()).doOnError(e -> LOGGER.error("Error while setting domain attribute for domain {}", (Object)domainAttribute, e)).then(Mono.just((Object)connection));
    }
}

