/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql;

import io.r2dbc.postgresql.ConnectionFunction;
import io.r2dbc.postgresql.ExceptionFactory;
import io.r2dbc.postgresql.client.Client;
import io.r2dbc.postgresql.client.ConnectionSettings;
import io.r2dbc.postgresql.client.SSLConfig;
import io.r2dbc.postgresql.client.SSLMode;
import java.net.SocketAddress;
import java.util.function.Function;
import java.util.function.Predicate;
import reactor.core.publisher.Mono;

final class SslFallbackConnectionFunction
implements ConnectionFunction {
    private final SSLConfig sslConfig;
    private final ConnectionFunction upstreamFunction;

    SslFallbackConnectionFunction(SSLConfig sslConfig, ConnectionFunction upstreamFunction) {
        this.sslConfig = sslConfig;
        this.upstreamFunction = upstreamFunction;
    }

    @Override
    public Mono<Client> connect(SocketAddress endpoint, ConnectionSettings settings) {
        Mono connect = this.upstreamFunction.connect(endpoint, settings);
        SSLMode sslMode = this.sslConfig.getSslMode();
        if (sslMode == SSLMode.ALLOW || sslMode == SSLMode.PREFER) {
            Predicate<Throwable> isAuthSpecificationError = e -> e instanceof ExceptionFactory.PostgresqlAuthenticationFailure;
            connect = connect.onErrorResume(isAuthSpecificationError.and(e -> sslMode == SSLMode.ALLOW), this.fallback(SSLMode.REQUIRE, endpoint, settings)).onErrorResume(isAuthSpecificationError.and(e -> sslMode == SSLMode.PREFER), this.fallback(SSLMode.DISABLE, endpoint, settings));
        }
        return connect;
    }

    private Function<Throwable, Mono<Client>> fallback(SSLMode sslMode, SocketAddress endpoint, ConnectionSettings settings) {
        return e -> {
            ConnectionSettings settingsToUse = settings.mutate(builder -> builder.sslConfig(this.sslConfig.mutateMode(sslMode)));
            return this.upstreamFunction.connect(endpoint, settingsToUse).onErrorResume(sslAuthError -> {
                e.addSuppressed((Throwable)sslAuthError);
                return Mono.error((Throwable)e);
            });
        };
    }
}

