/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.client;

import java.util.HashMap;
import java.util.TimeZone;

final class TimeZoneUtils {
    private static final char[][] NUMBERS;
    private static final HashMap<String, TimeZone> GMT_ZONES;

    TimeZoneUtils() {
    }

    public static TimeZone parseBackendTimeZone(String timeZone) {
        TimeZone tz;
        if (timeZone.startsWith("GMT") && (tz = GMT_ZONES.get(timeZone)) != null) {
            return tz;
        }
        return TimeZone.getTimeZone(timeZone);
    }

    public static String createPostgresTimeZone(TimeZone timeZone) {
        String start;
        String tz = timeZone.getID();
        if (tz.length() <= 3 || !tz.startsWith("GMT")) {
            return tz;
        }
        char sign = tz.charAt(3);
        switch (sign) {
            case '+': {
                start = "GMT-";
                break;
            }
            case '-': {
                start = "GMT+";
                break;
            }
            default: {
                return tz;
            }
        }
        return start + tz.substring(4);
    }

    static {
        int i;
        NUMBERS = new char[64][];
        GMT_ZONES = new HashMap();
        for (i = 0; i < NUMBERS.length; ++i) {
            TimeZoneUtils.NUMBERS[i] = ((i < 10 ? "0" : "") + Integer.toString(i)).toCharArray();
        }
        for (i = -12; i <= 14; ++i) {
            String pgZoneName;
            TimeZone timeZone;
            if (i == 0) {
                timeZone = TimeZone.getTimeZone("GMT");
                pgZoneName = "GMT";
            } else {
                timeZone = TimeZone.getTimeZone("GMT" + (i <= 0 ? "+" : "-") + Math.abs(i));
                pgZoneName = "GMT" + (i >= 0 ? "+" : "-");
            }
            if (i == 0) {
                GMT_ZONES.put(pgZoneName, timeZone);
                continue;
            }
            GMT_ZONES.put(pgZoneName + Math.abs(i), timeZone);
            GMT_ZONES.put(pgZoneName + new String(NUMBERS[Math.abs(i)]), timeZone);
        }
    }
}

