/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import jakarta.inject.Inject;
import jakarta.mail.MessagingException;
import java.util.Collection;
import java.util.Collections;
import org.apache.james.core.MailAddress;
import org.apache.mailet.Mail;
import org.apache.mailet.base.AutomaticallySentMailDetector;
import org.apache.mailet.base.GenericMatcher;

public class IsFromMailingList
extends GenericMatcher {
    private final AutomaticallySentMailDetector automaticallySentMailDetector;

    @Inject
    public IsFromMailingList(AutomaticallySentMailDetector automaticallySentMailDetector) {
        this.automaticallySentMailDetector = automaticallySentMailDetector;
    }

    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        if (this.automaticallySentMailDetector.isMailingList(mail)) {
            return mail.getRecipients();
        }
        return Collections.emptyList();
    }
}

