/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.CharFilterBase;
import org.opensearch.client.opensearch._types.analysis.CharFilterDefinition;
import org.opensearch.client.opensearch._types.analysis.CharFilterDefinitionVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class PatternReplaceCharFilter
extends CharFilterBase
implements CharFilterDefinitionVariant {
    @Nullable
    private final String flags;
    private final String pattern;
    @Nullable
    private final String replacement;
    public static final JsonpDeserializer<PatternReplaceCharFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PatternReplaceCharFilter::setupPatternReplaceCharFilterDeserializer);

    private PatternReplaceCharFilter(Builder builder) {
        super(builder);
        this.flags = builder.flags;
        this.pattern = ApiTypeHelper.requireNonNull(builder.pattern, this, "pattern");
        this.replacement = builder.replacement;
    }

    public static PatternReplaceCharFilter of(Function<Builder, ObjectBuilder<PatternReplaceCharFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public CharFilterDefinition.Kind _charFilterDefinitionKind() {
        return CharFilterDefinition.Kind.PatternReplace;
    }

    @Nullable
    public final String flags() {
        return this.flags;
    }

    public final String pattern() {
        return this.pattern;
    }

    public final String replacement() {
        return this.replacement;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "pattern_replace");
        super.serializeInternal(generator, mapper);
        generator.writeKey("pattern");
        generator.write(this.pattern);
        if (this.replacement != null) {
            generator.writeKey("replacement");
            generator.write(this.replacement);
        }
        if (this.flags != null) {
            generator.writeKey("flags");
            generator.write(this.flags);
        }
    }

    protected static void setupPatternReplaceCharFilterDeserializer(ObjectDeserializer<Builder> op) {
        CharFilterBase.setupCharFilterBaseDeserializer(op);
        op.add(Builder::flags, JsonpDeserializer.stringDeserializer(), "flags");
        op.add(Builder::pattern, JsonpDeserializer.stringDeserializer(), "pattern");
        op.add(Builder::replacement, JsonpDeserializer.stringDeserializer(), "replacement");
        op.ignore("type");
    }

    public static class Builder
    extends CharFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PatternReplaceCharFilter> {
        @Nullable
        private String flags;
        private String pattern;
        @Nullable
        private String replacement;

        public final Builder flags(@Nullable String value) {
            this.flags = value;
            return this;
        }

        public final Builder pattern(String value) {
            this.pattern = value;
            return this;
        }

        public final Builder replacement(@Nullable String value) {
            this.replacement = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PatternReplaceCharFilter build() {
            this._checkSingleUse();
            return new PatternReplaceCharFilter(this);
        }
    }
}

