/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.spotify.futures;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.pulsar.shade.com.spotify.futures.CombinedFutures;
import org.apache.pulsar.shade.com.spotify.futures.Function3;
import org.apache.pulsar.shade.com.spotify.futures.Function4;
import org.apache.pulsar.shade.com.spotify.futures.Function5;
import org.apache.pulsar.shade.com.spotify.futures.Function6;

public final class CompletableFutures {
    private CompletableFutures() {
        throw new IllegalAccessError("This class must not be instantiated.");
    }

    public static <T> CompletableFuture<List<T>> allAsList(List<? extends CompletionStage<? extends T>> stages) {
        CompletableFuture[] all = new CompletableFuture[stages.size()];
        for (int i = 0; i < stages.size(); ++i) {
            all[i] = stages.get(i).toCompletableFuture();
        }
        CompletableFuture<Void> allOf = CompletableFuture.allOf(all);
        for (int i = 0; i < all.length; ++i) {
            all[i].exceptionally(throwable -> {
                if (!allOf.isDone()) {
                    allOf.completeExceptionally((Throwable)throwable);
                }
                return null;
            });
        }
        return allOf.thenApply(ignored -> {
            ArrayList result = new ArrayList(all.length);
            for (int i = 0; i < all.length; ++i) {
                result.add(all[i].join());
            }
            return result;
        });
    }

    public static <U, T> CompletableFuture<Map<U, T>> allAsMap(Map<U, ? extends CompletionStage<? extends T>> map) {
        ArrayList keys = new ArrayList(map.keySet());
        CompletableFuture[] values = new CompletableFuture[keys.size()];
        for (int i = 0; i < keys.size(); ++i) {
            values[i] = map.get(keys.get(i)).toCompletableFuture();
        }
        return CompletableFuture.allOf(values).thenApply(ignored -> {
            HashMap result = new HashMap(values.length);
            for (int i = 0; i < values.length; ++i) {
                result.put(keys.get(i), values[i].join());
            }
            return result;
        });
    }

    public static <T> CompletableFuture<List<T>> successfulAsList(List<? extends CompletionStage<T>> stages, Function<Throwable, ? extends T> defaultValueMapper) {
        return stages.stream().map(f -> f.exceptionally(defaultValueMapper)).collect(CompletableFutures.joinList());
    }

    public static <T> CompletableFuture<T> exceptionallyCompletedFuture(Throwable throwable) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(throwable);
        return future;
    }

    public static <T, S extends CompletionStage<? extends T>> Collector<S, ?, CompletableFuture<List<T>>> joinList() {
        return Collectors.collectingAndThen(Collectors.toList(), CompletableFutures::allAsList);
    }

    public static <T, K, V> Collector<T, ?, CompletableFuture<Map<K, V>>> joinMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends CompletionStage<? extends V>> valueFutureMapper) {
        Collector<? super T, ?, Map<? extends K, ? extends CompletionStage<? extends V>>> collector = Collectors.toMap(keyMapper, valueFutureMapper);
        return Collectors.collectingAndThen(collector, CompletableFutures::allAsMap);
    }

    public static void checkCompleted(CompletionStage<?> stage) {
        if (!stage.toCompletableFuture().isDone()) {
            throw new IllegalStateException("future was not completed");
        }
    }

    public static <T> T getCompleted(CompletionStage<T> stage) {
        CompletableFuture<T> future = stage.toCompletableFuture();
        CompletableFutures.checkCompleted(future);
        return future.join();
    }

    public static <T> Throwable getException(CompletionStage<T> stage) {
        CompletableFuture<T> future = stage.toCompletableFuture();
        if (!future.isCompletedExceptionally()) {
            throw new IllegalStateException("future was not completed exceptionally");
        }
        try {
            future.join();
            return null;
        }
        catch (CompletionException x) {
            return x.getCause();
        }
    }

    public static <T, U> CompletionStage<U> handleCompose(CompletionStage<T> stage, BiFunction<? super T, Throwable, ? extends CompletionStage<U>> fn) {
        return CompletableFutures.dereference(stage.handle(fn));
    }

    public static <T> CompletionStage<T> exceptionallyCompose(CompletionStage<T> stage, Function<Throwable, ? extends CompletionStage<T>> fn) {
        return CompletableFutures.dereference(CompletableFutures.wrap(stage).exceptionally(fn));
    }

    public static <U> CompletionStage<U> supplyAsyncCompose(Supplier<CompletionStage<U>> supplier) {
        return CompletableFutures.dereference(CompletableFuture.supplyAsync(supplier));
    }

    public static <U> CompletionStage<U> supplyAsyncCompose(Supplier<CompletionStage<U>> supplier, Executor executor) {
        return CompletableFutures.dereference(CompletableFuture.supplyAsync(supplier, executor));
    }

    public static <T> CompletionStage<T> dereference(CompletionStage<? extends CompletionStage<T>> stage) {
        return stage.thenCompose(Function.identity());
    }

    private static <T> CompletionStage<CompletionStage<T>> wrap(CompletionStage<T> future) {
        return future.thenApply(CompletableFuture::completedFuture);
    }

    public static <R, A, B> CompletionStage<R> combine(CompletionStage<A> a, CompletionStage<B> b, BiFunction<A, B, R> function) {
        return a.thenCombine(b, function);
    }

    public static <R, A, B, C> CompletionStage<R> combine(CompletionStage<A> a, CompletionStage<B> b, CompletionStage<C> c, Function3<A, B, C, R> function) {
        CompletableFuture af = a.toCompletableFuture();
        CompletableFuture bf = b.toCompletableFuture();
        CompletableFuture cf = c.toCompletableFuture();
        return CompletableFuture.allOf(af, bf, cf).thenApply(ignored -> function.apply(af.join(), bf.join(), cf.join()));
    }

    public static <R, A, B, C, D> CompletionStage<R> combine(CompletionStage<A> a, CompletionStage<B> b, CompletionStage<C> c, CompletionStage<D> d, Function4<A, B, C, D, R> function) {
        CompletableFuture af = a.toCompletableFuture();
        CompletableFuture bf = b.toCompletableFuture();
        CompletableFuture cf = c.toCompletableFuture();
        CompletableFuture df = d.toCompletableFuture();
        return CompletableFuture.allOf(af, bf, cf, df).thenApply(ignored -> function.apply(af.join(), bf.join(), cf.join(), df.join()));
    }

    public static <R, A, B, C, D, E> CompletionStage<R> combine(CompletionStage<A> a, CompletionStage<B> b, CompletionStage<C> c, CompletionStage<D> d, CompletionStage<E> e, Function5<A, B, C, D, E, R> function) {
        CompletableFuture af = a.toCompletableFuture();
        CompletableFuture bf = b.toCompletableFuture();
        CompletableFuture cf = c.toCompletableFuture();
        CompletableFuture df = d.toCompletableFuture();
        CompletableFuture ef = e.toCompletableFuture();
        return CompletableFuture.allOf(af, bf, cf, df, ef).thenApply(ignored -> function.apply(af.join(), bf.join(), cf.join(), df.join(), ef.join()));
    }

    public static <R, A, B, C, D, E, F> CompletionStage<R> combine(CompletionStage<A> a, CompletionStage<B> b, CompletionStage<C> c, CompletionStage<D> d, CompletionStage<E> e, CompletionStage<F> f, Function6<A, B, C, D, E, F, R> function) {
        CompletableFuture af = a.toCompletableFuture();
        CompletableFuture bf = b.toCompletableFuture();
        CompletableFuture cf = c.toCompletableFuture();
        CompletableFuture df = d.toCompletableFuture();
        CompletableFuture ef = e.toCompletableFuture();
        CompletableFuture ff = f.toCompletableFuture();
        return CompletableFuture.allOf(af, bf, cf, df, ef, ff).thenApply(ignored -> function.apply(af.join(), bf.join(), cf.join(), df.join(), ef.join(), ff.join()));
    }

    public static <T> CompletionStage<T> combine(Function<CombinedFutures, T> function, CompletionStage<?> ... stages) {
        return CompletableFutures.combine(function, Arrays.asList(stages));
    }

    public static <T> CompletionStage<T> combine(Function<CombinedFutures, T> function, List<? extends CompletionStage<?>> stages) {
        CompletableFuture[] all = new CompletableFuture[stages.size()];
        for (int i = 0; i < stages.size(); ++i) {
            all[i] = stages.get(i).toCompletableFuture();
        }
        return CompletableFuture.allOf(all).thenApply(ignored -> function.apply(new CombinedFutures(stages)));
    }

    public static <R, A, B> CompletionStage<R> combineFutures(CompletionStage<A> a, CompletionStage<B> b, BiFunction<A, B, CompletionStage<R>> function) {
        CompletableFuture af = a.toCompletableFuture();
        CompletableFuture bf = b.toCompletableFuture();
        return CompletableFuture.allOf(af, bf).thenCompose(ignored -> (CompletionStage)function.apply(af.join(), bf.join()));
    }

    public static <R, A, B, C> CompletionStage<R> combineFutures(CompletionStage<A> a, CompletionStage<B> b, CompletionStage<C> c, Function3<A, B, C, CompletionStage<R>> function) {
        CompletableFuture af = a.toCompletableFuture();
        CompletableFuture bf = b.toCompletableFuture();
        CompletableFuture cf = c.toCompletableFuture();
        return CompletableFuture.allOf(af, bf, cf).thenCompose(ignored -> (CompletionStage)function.apply(af.join(), bf.join(), cf.join()));
    }

    public static <R, A, B, C, D> CompletionStage<R> combineFutures(CompletionStage<A> a, CompletionStage<B> b, CompletionStage<C> c, CompletionStage<D> d, Function4<A, B, C, D, CompletionStage<R>> function) {
        CompletableFuture af = a.toCompletableFuture();
        CompletableFuture bf = b.toCompletableFuture();
        CompletableFuture cf = c.toCompletableFuture();
        CompletableFuture df = d.toCompletableFuture();
        return CompletableFuture.allOf(af, bf, cf, df).thenCompose(ignored -> (CompletionStage)function.apply(af.join(), bf.join(), cf.join(), df.join()));
    }

    public static <R, A, B, C, D, E> CompletionStage<R> combineFutures(CompletionStage<A> a, CompletionStage<B> b, CompletionStage<C> c, CompletionStage<D> d, CompletionStage<E> e, Function5<A, B, C, D, E, CompletionStage<R>> function) {
        CompletableFuture af = a.toCompletableFuture();
        CompletableFuture bf = b.toCompletableFuture();
        CompletableFuture cf = c.toCompletableFuture();
        CompletableFuture df = d.toCompletableFuture();
        CompletableFuture ef = e.toCompletableFuture();
        return CompletableFuture.allOf(af, bf, cf, df, ef).thenCompose(ignored -> (CompletionStage)function.apply(af.join(), bf.join(), cf.join(), df.join(), ef.join()));
    }

    public static <R, A, B, C, D, E, F> CompletionStage<R> combineFutures(CompletionStage<A> a, CompletionStage<B> b, CompletionStage<C> c, CompletionStage<D> d, CompletionStage<E> e, CompletionStage<F> f, Function6<A, B, C, D, E, F, CompletionStage<R>> function) {
        CompletableFuture af = a.toCompletableFuture();
        CompletableFuture bf = b.toCompletableFuture();
        CompletableFuture cf = c.toCompletableFuture();
        CompletableFuture df = d.toCompletableFuture();
        CompletableFuture ef = e.toCompletableFuture();
        CompletableFuture ff = f.toCompletableFuture();
        return CompletableFuture.allOf(af, bf, cf, df, ef, ff).thenCompose(ignored -> (CompletionStage)function.apply(af.join(), bf.join(), cf.join(), df.join(), ef.join(), ff.join()));
    }

    public static <T> CompletableFuture<T> poll(Supplier<Optional<T>> pollingTask, Duration frequency, ScheduledExecutorService executorService) {
        CompletableFuture result = new CompletableFuture();
        ScheduledFuture<?> scheduled = executorService.scheduleAtFixedRate(() -> CompletableFutures.pollTask(pollingTask, result), 0L, frequency.toMillis(), TimeUnit.MILLISECONDS);
        result.whenComplete((r, ex) -> scheduled.cancel(true));
        return result;
    }

    private static <T> void pollTask(Supplier<Optional<T>> pollingTask, CompletableFuture<T> resultFuture) {
        try {
            pollingTask.get().ifPresent(resultFuture::complete);
        }
        catch (Exception ex) {
            resultFuture.completeExceptionally(ex);
        }
    }
}

