/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.search;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import jakarta.mail.Flags;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.james.events.Event;
import org.apache.james.events.EventListener;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.search.MessageSearchIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public abstract class ListeningMessageSearchIndex
implements MessageSearchIndex,
EventListener.ReactiveGroupEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListeningMessageSearchIndex.class);
    protected static final int UNLIMITED = -1;
    private static final ImmutableList<Class<? extends Event>> INTERESTING_EVENTS = ImmutableList.of(MailboxEvents.Added.class, MailboxEvents.Expunged.class, MailboxEvents.FlagsUpdated.class, MailboxEvents.MailboxDeletion.class);
    private final MailboxSessionMapperFactory factory;
    private final Set<SearchOverride> searchOverrides;
    private final SessionProvider sessionProvider;

    public abstract void postReindexing();

    public ListeningMessageSearchIndex(MailboxSessionMapperFactory factory, Set<SearchOverride> searchOverrides, SessionProvider sessionProvider) {
        this.factory = factory;
        this.searchOverrides = searchOverrides;
        this.sessionProvider = sessionProvider;
    }

    @Override
    public Flux<MessageUid> search(MailboxSession session, Mailbox mailbox, SearchQuery searchQuery) throws MailboxException {
        return this.searchOverrides.stream().filter(override -> override.applicable(searchQuery, session)).map(override -> override.search(session, mailbox, searchQuery)).findFirst().orElseGet(Throwing.supplier(() -> this.doSearch(session, mailbox, searchQuery)).sneakyThrow());
    }

    public boolean isHandling(Event event) {
        return INTERESTING_EVENTS.contains((Object)event.getClass());
    }

    public Mono<Void> reactiveEvent(Event event) {
        MailboxSession systemSession = this.sessionProvider.createSystemSession(event.getUsername());
        return this.handleMailboxEvent(event, systemSession, (MailboxEvents.MailboxEvent)event).then(Mono.fromRunnable(() -> this.factory.endProcessingRequest(systemSession)));
    }

    private Mono<Void> handleMailboxEvent(Event event, MailboxSession session, MailboxEvents.MailboxEvent mailboxEvent) {
        MailboxId mailboxId = mailboxEvent.getMailboxId();
        if (event instanceof MailboxEvents.Added) {
            return this.factory.getMailboxMapper(session).findMailboxById(mailboxId).flatMap(mailbox -> this.handleAdded(session, (Mailbox)mailbox, (MailboxEvents.Added)event)).onErrorResume(MailboxNotFoundException.class, e -> {
                LOGGER.info("Added event skipped for deleted mailbox {}", (Object)mailboxId.serialize());
                return Mono.empty();
            });
        }
        if (event instanceof MailboxEvents.Expunged) {
            MailboxEvents.Expunged expunged = (MailboxEvents.Expunged)event;
            return this.delete(session, mailboxId, expunged.getUids());
        }
        if (event instanceof MailboxEvents.FlagsUpdated) {
            MailboxEvents.FlagsUpdated flagsUpdated = (MailboxEvents.FlagsUpdated)event;
            return this.update(session, mailboxId, flagsUpdated.getUpdatedFlags());
        }
        if (event instanceof MailboxEvents.MailboxDeletion) {
            return this.deleteAll(session, mailboxId);
        }
        return Mono.empty();
    }

    protected Mono<Void> handleAdded(MailboxSession session, Mailbox mailbox, MailboxEvents.Added added) {
        return this.handleAdded(session, mailbox, added, MessageMapper.FetchType.FULL);
    }

    protected Mono<Void> handleAdded(MailboxSession session, Mailbox mailbox, MailboxEvents.Added added, MessageMapper.FetchType fetchType) {
        return Flux.fromIterable((Iterable)MessageRange.toRanges((Collection)added.getUids())).concatMap(range -> this.retrieveMailboxMessages(session, mailbox, (MessageRange)range, fetchType)).publishOn(Schedulers.parallel()).concatMap(mailboxMessage -> this.add(session, mailbox, (MailboxMessage)mailboxMessage, Optional.of(added))).then();
    }

    private Flux<MailboxMessage> retrieveMailboxMessages(MailboxSession session, Mailbox mailbox, MessageRange range, MessageMapper.FetchType fetchType) {
        return this.factory.getMessageMapper(session).findInMailboxReactive(mailbox, range, fetchType, -1);
    }

    protected abstract Flux<MessageUid> doSearch(MailboxSession var1, Mailbox var2, SearchQuery var3) throws MailboxException;

    public abstract Mono<Void> add(MailboxSession var1, Mailbox var2, MailboxMessage var3);

    public Mono<Void> add(MailboxSession session, Mailbox mailbox, MailboxMessage message, Optional<MailboxEvents.Added> added) {
        return this.add(session, mailbox, message);
    }

    public abstract Mono<Void> delete(MailboxSession var1, MailboxId var2, Collection<MessageUid> var3);

    public abstract Mono<Void> deleteAll(MailboxSession var1, MailboxId var2);

    public abstract Mono<Void> update(MailboxSession var1, MailboxId var2, List<UpdatedFlags> var3);

    public abstract Mono<Flags> retrieveIndexedFlags(Mailbox var1, MessageUid var2);

    public static interface SearchOverride {
        public boolean applicable(SearchQuery var1, MailboxSession var2);

        public Flux<MessageUid> search(MailboxSession var1, Mailbox var2, SearchQuery var3);
    }
}

