/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jsieve.tests.optional;

import java.util.Iterator;
import java.util.List;
import org.apache.jsieve.Argument;
import org.apache.jsieve.Arguments;
import org.apache.jsieve.SieveContext;
import org.apache.jsieve.StringListArgument;
import org.apache.jsieve.TagArgument;
import org.apache.jsieve.exception.SieveException;
import org.apache.jsieve.exception.SyntaxException;
import org.apache.jsieve.mail.MailAdapter;
import org.apache.jsieve.parser.generated.Token;
import org.apache.jsieve.tests.AbstractTest;

public class Body
extends AbstractTest {
    public static final String TEXT = ":text";
    public static final String RAW = ":raw";
    public static final String CONTENT = ":content";
    private TagArgument transformation;
    private StringListArgument contentTypes;
    private TagArgument matcher;
    private StringListArgument valuesToBeMatched;

    @Override
    protected void validateArguments(Arguments args, SieveContext ctx) throws SieveException {
        Iterator<Argument> matchingSpecifications = this.retrieveTransformationAndMatchingSpecificationIterator(args.getArgumentList());
        if (this.transformation.getTag().equals(TEXT)) {
            this.parseDefaultArguments(matchingSpecifications);
        } else if (this.transformation.getTag().equals(RAW)) {
            this.parseDefaultArguments(matchingSpecifications);
        } else if (this.transformation.getTag().equals(CONTENT)) {
            this.parseContentArguments(matchingSpecifications);
        } else {
            throw new SyntaxException("Unknown transformation " + this.transformation.getTag() + ". See RFC-5173 section 5.");
        }
    }

    private void parseContentArguments(Iterator<Argument> matchingSpecifications) throws SyntaxException {
        this.retrieveContentTypes(matchingSpecifications);
        this.retrieveMatcher(matchingSpecifications);
        this.retrieveMatchValues(matchingSpecifications);
        this.assureNoMoreArguments(matchingSpecifications);
    }

    private void parseDefaultArguments(Iterator<Argument> matchingSpecifications) throws SyntaxException {
        this.retrieveMatcher(matchingSpecifications);
        this.retrieveMatchValues(matchingSpecifications);
        this.assureNoMoreArguments(matchingSpecifications);
    }

    private Iterator<Argument> retrieveTransformationAndMatchingSpecificationIterator(List<Argument> arglist) throws SyntaxException {
        if (arglist.size() < 1) {
            throw new SyntaxException("Transformations should be specified. See RFC-5173 section 5.");
        }
        Argument arg = arglist.get(0);
        if (!(arg instanceof TagArgument)) {
            this.transformation = new TagArgument(new Token(0, TEXT));
            return arglist.iterator();
        }
        TagArgument transformationCandidate = (TagArgument)arg;
        if (transformationCandidate.getTag().equals(TEXT) || transformationCandidate.getTag().equals(RAW) || transformationCandidate.getTag().equals(CONTENT)) {
            this.transformation = (TagArgument)arg;
            Iterator<Argument> matchingSpecifications = arglist.iterator();
            matchingSpecifications.next();
            return matchingSpecifications;
        }
        this.transformation = new TagArgument(new Token(0, TEXT));
        return arglist.iterator();
    }

    @Override
    protected boolean executeBasic(MailAdapter mail, Arguments args, SieveContext ctx) throws SieveException {
        if (this.transformation.getTag().equals(RAW)) {
            return mail.isInBodyRaw(this.valuesToBeMatched.getList());
        }
        if (this.transformation.getTag().equals(CONTENT)) {
            return mail.isInBodyContent(this.contentTypes.getList(), this.valuesToBeMatched.getList());
        }
        if (this.transformation.getTag().equals(TEXT)) {
            return mail.isInBodyText(this.valuesToBeMatched.getList());
        }
        throw new RuntimeException("Invalid transformation caught. Is your argument parsing buggy ?");
    }

    private void retrieveContentTypes(Iterator<Argument> matchingSpecifications) throws SyntaxException {
        if (!matchingSpecifications.hasNext()) {
            throw new SyntaxException("Expecting the list of content types following :content");
        }
        Argument contentTypesArgument = matchingSpecifications.next();
        if (!(contentTypesArgument instanceof StringListArgument)) {
            throw new SyntaxException("Expecting a String list to specify content types and not a" + contentTypesArgument.getClass());
        }
        this.contentTypes = (StringListArgument)contentTypesArgument;
    }

    private void retrieveMatcher(Iterator<Argument> matchingSpecifications) throws SyntaxException {
        if (!matchingSpecifications.hasNext()) {
            throw new SyntaxException("Expecting a matcher :contains");
        }
        Argument matcherArgument = matchingSpecifications.next();
        if (!(matcherArgument instanceof TagArgument)) {
            throw new SyntaxException("Expecting a matcher :contains and not a" + matcherArgument.getClass());
        }
        if (!((TagArgument)matcherArgument).getTag().equals(":contains")) {
            throw new SyntaxException("Expecting a matcher :contains. Matcher " + ((TagArgument)matcherArgument).getTag() + " is currently not supported.");
        }
        this.matcher = (TagArgument)matcherArgument;
    }

    private void retrieveMatchValues(Iterator<Argument> matchingSpecifications) throws SyntaxException {
        if (!matchingSpecifications.hasNext()) {
            throw new SyntaxException("Matcher :contains should be followed by a StringList");
        }
        Argument matchValues = matchingSpecifications.next();
        if (!(matchValues instanceof StringListArgument)) {
            throw new SyntaxException("Matcher :contains should be followed by a StringList and not a " + matchValues.getClass());
        }
        this.valuesToBeMatched = (StringListArgument)matchValues;
    }

    private void assureNoMoreArguments(Iterator<Argument> matchingSpecifications) throws SyntaxException {
        if (matchingSpecifications.hasNext()) {
            throw new SyntaxException("Too many arguments for Body test");
        }
    }
}

