/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.quota;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.api.querybuilder.update.Update;
import jakarta.inject.Inject;
import java.util.function.Predicate;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.mailbox.cassandra.table.CassandraCurrentQuota;
import org.apache.james.mailbox.model.CurrentQuotas;
import org.apache.james.mailbox.model.QuotaOperation;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.CurrentQuotaManager;
import reactor.core.publisher.Mono;

@Deprecated
public class CassandraCurrentQuotaManagerV1
implements CurrentQuotaManager {
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement increaseStatement;
    private final PreparedStatement decreaseStatement;
    private final PreparedStatement getCurrentMessageCountStatement;
    private final PreparedStatement getCurrentStorageStatement;
    private final PreparedStatement getCurrentQuotasStatement;

    @Inject
    public CassandraCurrentQuotaManagerV1(CqlSession session) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.increaseStatement = session.prepare(((Update)QueryBuilder.update((String)"currentQuota").increment(CassandraCurrentQuota.MESSAGE_COUNT, (Term)QueryBuilder.bindMarker()).increment(CassandraCurrentQuota.STORAGE, (Term)QueryBuilder.bindMarker()).where((Relation)Relation.column((CqlIdentifier)CassandraCurrentQuota.QUOTA_ROOT).isEqualTo((Term)QueryBuilder.bindMarker()))).build());
        this.decreaseStatement = session.prepare(((Update)QueryBuilder.update((String)"currentQuota").decrement(CassandraCurrentQuota.MESSAGE_COUNT, (Term)QueryBuilder.bindMarker()).decrement(CassandraCurrentQuota.STORAGE, (Term)QueryBuilder.bindMarker()).where((Relation)Relation.column((CqlIdentifier)CassandraCurrentQuota.QUOTA_ROOT).isEqualTo((Term)QueryBuilder.bindMarker()))).build());
        this.getCurrentMessageCountStatement = session.prepare(((Select)QueryBuilder.selectFrom((String)"currentQuota").column(CassandraCurrentQuota.MESSAGE_COUNT).where((Relation)Relation.column((CqlIdentifier)CassandraCurrentQuota.QUOTA_ROOT).isEqualTo((Term)QueryBuilder.bindMarker()))).build());
        this.getCurrentStorageStatement = session.prepare(((Select)QueryBuilder.selectFrom((String)"currentQuota").column(CassandraCurrentQuota.STORAGE).where((Relation)Relation.column((CqlIdentifier)CassandraCurrentQuota.QUOTA_ROOT).isEqualTo((Term)QueryBuilder.bindMarker()))).build());
        this.getCurrentQuotasStatement = session.prepare(((Select)QueryBuilder.selectFrom((String)"currentQuota").columns(new CqlIdentifier[]{CassandraCurrentQuota.MESSAGE_COUNT, CassandraCurrentQuota.STORAGE}).where((Relation)Relation.column((CqlIdentifier)CassandraCurrentQuota.QUOTA_ROOT).isEqualTo((Term)QueryBuilder.bindMarker()))).build());
    }

    public Mono<Void> increase(QuotaOperation quotaOperation) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.increaseStatement.bind(new Object[]{quotaOperation.count().asLong(), quotaOperation.size().asLong(), quotaOperation.quotaRoot().getValue()}));
    }

    public Mono<Void> decrease(QuotaOperation quotaOperation) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.decreaseStatement.bind(new Object[]{quotaOperation.count().asLong(), quotaOperation.size().asLong(), quotaOperation.quotaRoot().getValue()}));
    }

    public Mono<QuotaCountUsage> getCurrentMessageCount(QuotaRoot quotaRoot) {
        return this.cassandraAsyncExecutor.executeSingleRow((Statement)this.getCurrentMessageCountStatement.bind(new Object[]{quotaRoot.getValue()})).map(row -> QuotaCountUsage.count((long)row.getLong(CassandraCurrentQuota.MESSAGE_COUNT))).defaultIfEmpty((Object)QuotaCountUsage.count((long)0L));
    }

    public Mono<QuotaSizeUsage> getCurrentStorage(QuotaRoot quotaRoot) {
        return this.cassandraAsyncExecutor.executeSingleRow((Statement)this.getCurrentStorageStatement.bind(new Object[]{quotaRoot.getValue()})).map(row -> QuotaSizeUsage.size((long)row.getLong(CassandraCurrentQuota.STORAGE))).defaultIfEmpty((Object)QuotaSizeUsage.size((long)0L));
    }

    public Mono<CurrentQuotas> getCurrentQuotas(QuotaRoot quotaRoot) {
        return this.cassandraAsyncExecutor.executeSingleRow((Statement)this.getCurrentQuotasStatement.bind(new Object[]{quotaRoot.getValue()})).map(row -> new CurrentQuotas(QuotaCountUsage.count((long)row.getLong(CassandraCurrentQuota.MESSAGE_COUNT)), QuotaSizeUsage.size((long)row.getLong(CassandraCurrentQuota.STORAGE)))).defaultIfEmpty((Object)CurrentQuotas.emptyQuotas());
    }

    public Mono<Void> setCurrentQuotas(QuotaOperation quotaOperation) {
        return this.getCurrentQuotas(quotaOperation.quotaRoot()).filter(Predicate.not(Predicate.isEqual(CurrentQuotas.from((QuotaOperation)quotaOperation)))).flatMap(storedQuotas -> this.cassandraAsyncExecutor.executeVoid((Statement)this.decreaseStatement.bind(new Object[]{storedQuotas.count().asLong(), storedQuotas.size().asLong(), quotaOperation.quotaRoot().asString()})).then(this.increase(quotaOperation)));
    }
}

