/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor.fetch;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.message.response.FetchResponse;
import org.apache.james.mailbox.model.Header;

public class MimeBodyElement
implements FetchResponse.BodyElement {
    private static final String NAME_DELIMITER = ": ";
    private static final byte[] NAME_DELIMITER_BYTES = ": ".getBytes(StandardCharsets.US_ASCII);
    private final String name;
    protected final List<Header> headers;
    protected long size;

    public MimeBodyElement(String name, List<Header> headers) {
        this.name = name;
        this.headers = headers;
        this.size = this.calculateSize(headers);
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected long calculateSize(List<Header> headers) {
        if (headers.isEmpty()) {
            return 0L;
        }
        long count = 0L;
        for (Header header : headers) {
            count += header.size() + (long)"\r\n".length();
        }
        return count + (long)"\r\n".length();
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        ExactSizeByteArrayOutputStream out = new ExactSizeByteArrayOutputStream((int)this.size);
        for (Header header : this.headers) {
            out.write(header.getName().getBytes(StandardCharsets.US_ASCII));
            out.write(NAME_DELIMITER_BYTES);
            out.write(header.getValue().getBytes(StandardCharsets.US_ASCII));
            out.write(ImapConstants.LINE_END_BYTES);
        }
        if (this.size > 0L) {
            out.write("\r\n".getBytes());
        }
        return new ByteArrayInputStream(out.getUnderlyingBuffer());
    }

    private static class ExactSizeByteArrayOutputStream
    extends ByteArrayOutputStream {
        public ExactSizeByteArrayOutputStream(int size) {
            super(size);
        }

        public byte[] getUnderlyingBuffer() {
            return this.buf;
        }
    }
}

