/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.hybrid;

import com.google.crypto.tink.HybridEncrypt;
import com.google.crypto.tink.hybrid.internal.LegacyFullHybridEncrypt;
import com.google.crypto.tink.internal.KeysetHandleInterface;
import com.google.crypto.tink.internal.LegacyProtoKey;
import com.google.crypto.tink.internal.MonitoringClient;
import com.google.crypto.tink.internal.MonitoringUtil;
import com.google.crypto.tink.internal.MutableMonitoringRegistry;
import com.google.crypto.tink.internal.MutablePrimitiveRegistry;
import com.google.crypto.tink.internal.PrimitiveConstructor;
import com.google.crypto.tink.internal.PrimitiveRegistry;
import com.google.crypto.tink.internal.PrimitiveSet;
import com.google.crypto.tink.internal.PrimitiveWrapper;
import java.security.GeneralSecurityException;

public class HybridEncryptWrapper
implements PrimitiveWrapper<HybridEncrypt, HybridEncrypt> {
    private static final HybridEncryptWrapper WRAPPER = new HybridEncryptWrapper();
    private static final PrimitiveConstructor<LegacyProtoKey, HybridEncrypt> LEGACY_PRIMITIVE_CONSTRUCTOR = PrimitiveConstructor.create(LegacyFullHybridEncrypt::create, LegacyProtoKey.class, HybridEncrypt.class);

    HybridEncryptWrapper() {
    }

    @Override
    public HybridEncrypt wrap(PrimitiveSet<HybridEncrypt> primitives) throws GeneralSecurityException {
        MonitoringClient.Logger encLogger;
        KeysetHandleInterface keysetHandle = primitives.getKeysetHandle();
        if (!primitives.getAnnotations().isEmpty()) {
            MonitoringClient client = MutableMonitoringRegistry.globalInstance().getMonitoringClient();
            encLogger = client.createLogger(keysetHandle, primitives.getAnnotations(), "hybrid_encrypt", "encrypt");
        } else {
            encLogger = MonitoringUtil.DO_NOTHING_LOGGER;
        }
        KeysetHandleInterface.Entry primary = keysetHandle.getPrimary();
        return new WrappedHybridEncrypt(new HybridEncryptWithId(primary == null ? null : primitives.getPrimitiveForEntry(primary), primary == null ? 0 : primary.getId()), encLogger);
    }

    @Override
    public Class<HybridEncrypt> getPrimitiveClass() {
        return HybridEncrypt.class;
    }

    @Override
    public Class<HybridEncrypt> getInputPrimitiveClass() {
        return HybridEncrypt.class;
    }

    public static void register() throws GeneralSecurityException {
        MutablePrimitiveRegistry.globalInstance().registerPrimitiveWrapper(WRAPPER);
        MutablePrimitiveRegistry.globalInstance().registerPrimitiveConstructor(LEGACY_PRIMITIVE_CONSTRUCTOR);
    }

    public static void registerToInternalPrimitiveRegistry(PrimitiveRegistry.Builder primitiveRegistryBuilder) throws GeneralSecurityException {
        primitiveRegistryBuilder.registerPrimitiveWrapper(WRAPPER);
    }

    private static class WrappedHybridEncrypt
    implements HybridEncrypt {
        private final HybridEncryptWithId primary;
        private final MonitoringClient.Logger encLogger;

        public WrappedHybridEncrypt(HybridEncryptWithId primary, MonitoringClient.Logger encLogger) {
            this.primary = primary;
            this.encLogger = encLogger;
        }

        @Override
        public byte[] encrypt(byte[] plaintext, byte[] contextInfo) throws GeneralSecurityException {
            if (this.primary.hybridEncrypt == null) {
                this.encLogger.logFailure();
                throw new GeneralSecurityException("keyset without primary key");
            }
            try {
                byte[] output = this.primary.hybridEncrypt.encrypt(plaintext, contextInfo);
                this.encLogger.log(this.primary.id, plaintext.length);
                return output;
            }
            catch (GeneralSecurityException e) {
                this.encLogger.logFailure();
                throw e;
            }
        }
    }

    private static class HybridEncryptWithId {
        public final HybridEncrypt hybridEncrypt;
        public final int id;

        public HybridEncryptWithId(HybridEncrypt hybridEncrypt, int id) {
            this.hybridEncrypt = hybridEncrypt;
            this.id = id;
        }
    }
}

