/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.cassandra;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.cassandra.CassandraMappingsSourcesDAO;
import org.apache.james.rrt.cassandra.CassandraRecipientRewriteTableDAO;
import org.apache.james.rrt.lib.AbstractRecipientRewriteTable;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.rrt.lib.Mappings;
import org.apache.james.rrt.lib.MappingsImpl;
import reactor.core.publisher.Flux;

public class CassandraRecipientRewriteTable
extends AbstractRecipientRewriteTable {
    private final CassandraRecipientRewriteTableDAO cassandraRecipientRewriteTableDAO;
    private final CassandraMappingsSourcesDAO cassandraMappingsSourcesDAO;

    @Inject
    CassandraRecipientRewriteTable(CassandraRecipientRewriteTableDAO cassandraRecipientRewriteTableDAO, CassandraMappingsSourcesDAO cassandraMappingsSourcesDAO) {
        this.cassandraRecipientRewriteTableDAO = cassandraRecipientRewriteTableDAO;
        this.cassandraMappingsSourcesDAO = cassandraMappingsSourcesDAO;
    }

    public void addMapping(MappingSource source, Mapping mapping) {
        this.cassandraRecipientRewriteTableDAO.addMapping(source, mapping).then(this.cassandraMappingsSourcesDAO.addMapping(mapping, source)).block();
    }

    public void removeMapping(MappingSource source, Mapping mapping) {
        this.cassandraRecipientRewriteTableDAO.removeMapping(source, mapping).then(this.cassandraMappingsSourcesDAO.removeMapping(mapping, source)).block();
    }

    public Mappings getStoredMappings(MappingSource source) {
        return (Mappings)this.cassandraRecipientRewriteTableDAO.retrieveMappings(source).blockOptional().orElse(MappingsImpl.empty());
    }

    public Map<MappingSource, Mappings> getAllMappings() {
        return (Map)this.cassandraRecipientRewriteTableDAO.getAllMappings().collect(ImmutableMap.toImmutableMap(Pair::getLeft, pair -> MappingsImpl.fromMappings((Mapping[])new Mapping[]{(Mapping)pair.getRight()}), Mappings::union)).block();
    }

    public Stream<MappingSource> listSources(Mapping mapping) throws RecipientRewriteTableException {
        Preconditions.checkArgument((boolean)listSourcesSupportedType.contains(mapping.getType()), (String)"Not supported mapping of type %s", (Object)mapping.getType());
        return this.cassandraMappingsSourcesDAO.retrieveSources(mapping).toStream();
    }

    public Flux<MappingSource> listSourcesReactive(Mapping mapping) {
        Preconditions.checkArgument((boolean)listSourcesSupportedType.contains(mapping.getType()), (String)"Not supported mapping of type %s", (Object)mapping.getType());
        return this.cassandraMappingsSourcesDAO.retrieveSources(mapping);
    }
}

