/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.utils;

import java.util.stream.Stream;
import org.apache.james.utils.ClassName;
import org.apache.james.utils.FullyQualifiedClassName;
import org.apache.james.utils.PackageName;

public interface NamingScheme {
    public static final NamingScheme IDENTITY = className -> Stream.of(className.asFullyQualified());

    public Stream<FullyQualifiedClassName> toFullyQualifiedClassNames(ClassName var1);

    public static class OptionalPackagePrefix
    implements NamingScheme {
        private final PackageName packageName;

        public OptionalPackagePrefix(PackageName packageName) {
            this.packageName = packageName;
        }

        @Override
        public Stream<FullyQualifiedClassName> toFullyQualifiedClassNames(ClassName className) {
            return Stream.of(className.asFullyQualified(), className.appendPackage(this.packageName));
        }
    }
}

