/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.protocols;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.ProvidesIntoSet;
import org.apache.james.ProtocolConfigurationSanitizer;
import org.apache.james.RunArguments;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.lifecycle.api.ConfigurationSanitizer;
import org.apache.james.modules.protocols.Pop3GuiceProbe;
import org.apache.james.pop3server.mailbox.DefaultMailboxAdapterFactory;
import org.apache.james.pop3server.mailbox.MailboxAdapterFactory;
import org.apache.james.pop3server.netty.POP3ServerFactory;
import org.apache.james.protocols.lib.netty.CertificateReloadable;
import org.apache.james.server.core.configuration.ConfigurationProvider;
import org.apache.james.utils.GuiceProbe;
import org.apache.james.utils.InitializationOperation;
import org.apache.james.utils.InitilizationOperationBuilder;
import org.apache.james.utils.KeystoreCreator;

public class POP3ServerModule
extends AbstractModule {
    protected void configure() {
        this.bind(POP3ServerFactory.class).in(Scopes.SINGLETON);
        this.bind(DefaultMailboxAdapterFactory.class).in(Scopes.SINGLETON);
        this.bind(MailboxAdapterFactory.class).to(DefaultMailboxAdapterFactory.class);
        Multibinder.newSetBinder((Binder)this.binder(), GuiceProbe.class).addBinding().to(Pop3GuiceProbe.class);
        Multibinder.newSetBinder((Binder)this.binder(), CertificateReloadable.Factory.class).addBinding().to(POP3ServerFactory.class);
    }

    @ProvidesIntoSet
    InitializationOperation configurePop3(ConfigurationProvider configurationProvider, POP3ServerFactory pop3ServerFactory) {
        return InitilizationOperationBuilder.forClass(POP3ServerFactory.class).init(() -> {
            pop3ServerFactory.configure(configurationProvider.getConfiguration("pop3server"));
            pop3ServerFactory.init();
        });
    }

    @ProvidesIntoSet
    ConfigurationSanitizer configurationSanitizer(ConfigurationProvider configurationProvider, KeystoreCreator keystoreCreator, FileSystem fileSystem, RunArguments runArguments) {
        return new ProtocolConfigurationSanitizer(configurationProvider, keystoreCreator, fileSystem, runArguments, "pop3server");
    }
}

