/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import jakarta.inject.Inject;
import java.io.Serializable;
import org.apache.james.jmap.api.identity.IdentityNotFoundException;
import org.apache.james.jmap.api.identity.IdentityRepository;
import org.apache.james.jmap.api.identity.IdentityUpdateRequest;
import org.apache.james.jmap.api.model.IdentityId;
import org.apache.james.jmap.core.Properties;
import org.apache.james.jmap.core.SetError;
import org.apache.james.jmap.core.SetError$;
import org.apache.james.jmap.json.IdentitySerializer$;
import org.apache.james.jmap.mail.IdentitySet$;
import org.apache.james.jmap.mail.IdentitySetParseException;
import org.apache.james.jmap.mail.IdentitySetParseException$;
import org.apache.james.jmap.mail.IdentitySetRequest;
import org.apache.james.jmap.mail.InvalidPropertyException;
import org.apache.james.jmap.mail.UnparsedIdentityId;
import org.apache.james.jmap.method.IdentitySetUpdatePerformer$;
import org.apache.james.jmap.method.IdentitySetUpdatePerformer$IdentitySetUpdateResponse$;
import org.apache.james.jmap.method.IdentitySetUpdatePerformer$IdentitySetUpdateResults$;
import org.apache.james.jmap.method.IdentitySetUpdatePerformer$IdentityUpdate$;
import org.apache.james.mailbox.MailboxSession;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsPath;
import play.api.libs.json.JsValue;
import play.api.libs.json.JsonValidationError;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005\u0011-q!B:u\u0011\u0003yhaBA\u0002i\"\u0005\u0011Q\u0001\u0005\b\u0003'\tA\u0011AA\u000b\u0011%\t9\"\u0001b\u0001\n\u0013\tI\u0002\u0003\u0005\u0002(\u0005\u0001\u000b\u0011BA\u000e\r%\tI#\u0001I\u0001$C\tYC\u0002\u0004\u0003\u000e\u0005\u0001%q\u0002\u0005\u000b\u0003+2!Q3A\u0005\u0002\tE\u0001BCA3\r\tE\t\u0015!\u0003\u0003\u0014!9\u00111\u0003\u0004\u0005\u0002\t\r\u0002\"CAF\r\u0005\u0005I\u0011\u0001B\u0015\u0011%\t\u0019JBI\u0001\n\u0003\u0011i\u0003C\u0005\u00022\u001a\t\t\u0011\"\u0011\u00024\"I\u0011Q\u0019\u0004\u0002\u0002\u0013\u0005\u0011q\u0019\u0005\n\u0003\u001f4\u0011\u0011!C\u0001\u0005cA\u0011\"!8\u0007\u0003\u0003%\t%a8\t\u0013\u00055h!!A\u0005\u0002\tU\u0002\"CA}\r\u0005\u0005I\u0011\tB\u001d\u0011%\tyPBA\u0001\n\u0003\u0012\t\u0001C\u0005\u0003\u0004\u0019\t\t\u0011\"\u0011\u0003\u0006!I!q\u0001\u0004\u0002\u0002\u0013\u0005#QH\u0004\n\u0005\u0003\n\u0011\u0011!E\u0001\u0005\u00072\u0011B!\u0004\u0002\u0003\u0003E\tA!\u0012\t\u000f\u0005Ma\u0003\"\u0001\u0003^!I!1\u0001\f\u0002\u0002\u0013\u0015#Q\u0001\u0005\n\u0005?2\u0012\u0011!CA\u0005CB\u0011B!\u001a\u0017\u0003\u0003%\tIa\u001a\t\u0013\tMd#!A\u0005\n\tUdABA\u0018\u0003\u0001\u000b\t\u0004\u0003\u0006\u0002Vq\u0011)\u001a!C\u0001\u0003/B!\"!\u001a\u001d\u0005#\u0005\u000b\u0011BA-\u0011)\t9\u0007\bBK\u0002\u0013\u0005\u0011\u0011\u000e\u0005\u000b\u0003cb\"\u0011#Q\u0001\n\u0005-\u0004bBA\n9\u0011\u0005\u00111\u000f\u0005\b\u0003wbB\u0011AA?\u0011%\tY\tHA\u0001\n\u0003\ti\tC\u0005\u0002\u0014r\t\n\u0011\"\u0001\u0002\u0016\"I\u00111\u0016\u000f\u0012\u0002\u0013\u0005\u0011Q\u0016\u0005\n\u0003cc\u0012\u0011!C!\u0003gC\u0011\"!2\u001d\u0003\u0003%\t!a2\t\u0013\u0005=G$!A\u0005\u0002\u0005E\u0007\"CAo9\u0005\u0005I\u0011IAp\u0011%\ti\u000fHA\u0001\n\u0003\ty\u000fC\u0005\u0002zr\t\t\u0011\"\u0011\u0002|\"I\u0011q \u000f\u0002\u0002\u0013\u0005#\u0011\u0001\u0005\n\u0005\u0007a\u0012\u0011!C!\u0005\u000bA\u0011Ba\u0002\u001d\u0003\u0003%\tE!\u0003\b\u0013\tu\u0014!!A\t\u0002\t}d!CA\u0018\u0003\u0005\u0005\t\u0012\u0001BA\u0011\u001d\t\u0019\u0002\rC\u0001\u0005\u0013C\u0011Ba\u00011\u0003\u0003%)E!\u0002\t\u0013\t}\u0003'!A\u0005\u0002\n-\u0005\"\u0003B3a\u0005\u0005I\u0011\u0011BI\u0011%\u0011\u0019\bMA\u0001\n\u0013\u0011)hB\u0004\u0003\u001e\u0006A\tAa(\u0007\u000f\t\u0005\u0016\u0001#\u0001\u0003$\"9\u00111C\u001c\u0005\u0002\t\u0015\u0006b\u0002BTo\u0011\u0005!\u0011\u0016\u0005\n\u0005?:\u0014\u0011!CA\u0005OD\u0011B!\u001a8\u0003\u0003%\tIa;\t\u0013\tMt'!A\u0005\n\tUdA\u0002BQ\u0003\u0001\u0013i\u000b\u0003\u0006\u00030v\u0012)\u001a!C\u0001\u0005cC!B!3>\u0005#\u0005\u000b\u0011\u0002BZ\u0011\u001d\t\u0019\"\u0010C\u0001\u0005\u0017D\u0011\"a#>\u0003\u0003%\tAa4\t\u0013\u0005MU(%A\u0005\u0002\tM\u0007\"CAY{\u0005\u0005I\u0011IAZ\u0011%\t)-PA\u0001\n\u0003\t9\rC\u0005\u0002Pv\n\t\u0011\"\u0001\u0003X\"I\u0011Q\\\u001f\u0002\u0002\u0013\u0005\u0013q\u001c\u0005\n\u0003[l\u0014\u0011!C\u0001\u00057D\u0011\"!?>\u0003\u0003%\tEa8\t\u0013\u0005}X(!A\u0005B\t\u0005\u0001\"\u0003B\u0002{\u0005\u0005I\u0011\tB\u0003\u0011%\u00119!PA\u0001\n\u0003\u0012\u0019O\u0002\u0004\u0003r\u0006\u0001%1\u001f\u0005\u000b\u0005kd%Q3A\u0005\u0002\t]\bB\u0003B\u0000\u0019\nE\t\u0015!\u0003\u0003z\"9\u00111\u0003'\u0005\u0002\r\u0005\u0001bBB\u0004\u0019\u0012\u00051\u0011\u0002\u0005\b\u00077aE\u0011AB\u000f\u0011%\tY\tTA\u0001\n\u0003\u0019\t\u0003C\u0005\u0002\u00142\u000b\n\u0011\"\u0001\u0004&!I\u0011\u0011\u0017'\u0002\u0002\u0013\u0005\u00131\u0017\u0005\n\u0003\u000bd\u0015\u0011!C\u0001\u0003\u000fD\u0011\"a4M\u0003\u0003%\ta!\u000b\t\u0013\u0005uG*!A\u0005B\u0005}\u0007\"CAw\u0019\u0006\u0005I\u0011AB\u0017\u0011%\tI\u0010TA\u0001\n\u0003\u001a\t\u0004C\u0005\u0002\u00002\u000b\t\u0011\"\u0011\u0003\u0002!I!1\u0001'\u0002\u0002\u0013\u0005#Q\u0001\u0005\n\u0005\u000fa\u0015\u0011!C!\u0007k9\u0011b!\u000f\u0002\u0003\u0003E\taa\u000f\u0007\u0013\tE\u0018!!A\t\u0002\ru\u0002bBA\n=\u0012\u00051\u0011\t\u0005\n\u0005\u0007q\u0016\u0011!C#\u0005\u000bA\u0011Ba\u0018_\u0003\u0003%\tia\u0011\t\u0013\t\u0015d,!A\u0005\u0002\u000e\u001d\u0003\"\u0003B:=\u0006\u0005I\u0011\u0002B;\u000f\u001d\u0019i%\u0001E\u0001\u0007\u001f2qa!\u0015\u0002\u0011\u0003\u0019\u0019\u0006C\u0004\u0002\u0014\u0015$\ta!\u0016\t\u0013\r]SM1A\u0005\u0002\re\u0003\u0002CB3K\u0002\u0006Iaa\u0017\t\u0013\r\u001dTM1A\u0005\u0002\re\u0003\u0002CB5K\u0002\u0006Iaa\u0017\t\u0013\r-TM1A\u0005\u0002\re\u0003\u0002CB7K\u0002\u0006Iaa\u0017\u0007\r\u0005\rA\u000fAB8\u0011)\u0019\t(\u001cB\u0001B\u0003%11\u000f\u0005\b\u0003'iG\u0011AB@\u0011\u001d\u00199*\u001cC\u0001\u00073Cqa!9n\t\u0013\u0019\u0019\u000fC\u0004\u0004\u00186$Iaa?\u00025%#WM\u001c;jif\u001cV\r^+qI\u0006$X\rU3sM>\u0014X.\u001a:\u000b\u0005U4\u0018AB7fi\"|GM\u0003\u0002xq\u0006!!.\\1q\u0015\tI(0A\u0003kC6,7O\u0003\u0002|y\u00061\u0011\r]1dQ\u0016T\u0011!`\u0001\u0004_J<7\u0001\u0001\t\u0004\u0003\u0003\tQ\"\u0001;\u00035%#WM\u001c;jif\u001cV\r^+qI\u0006$X\rU3sM>\u0014X.\u001a:\u0014\u0007\u0005\t9\u0001\u0005\u0003\u0002\n\u0005=QBAA\u0006\u0015\t\ti!A\u0003tG\u0006d\u0017-\u0003\u0003\u0002\u0012\u0005-!AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002\u007f\u00061AjT$H\u000bJ+\"!a\u0007\u0011\t\u0005u\u00111E\u0007\u0003\u0003?Q1!!\t}\u0003\u0015\u0019HN\u001a\u001bk\u0013\u0011\t)#a\b\u0003\r1{wmZ3s\u0003\u001daujR$F%\u0002\u0012A\"\u00169eCR,'+Z:vYR\u001c2!BA\u0004S\r)AD\u0002\u0002\u000e+B$\u0017\r^3GC&dWO]3\u0014\u0013q\t9!a\r\u00028\u0005u\u0002cAA\u001b\u000b5\t\u0011\u0001\u0005\u0003\u0002\n\u0005e\u0012\u0002BA\u001e\u0003\u0017\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u0002@\u0005=c\u0002BA!\u0003\u0017rA!a\u0011\u0002J5\u0011\u0011Q\t\u0006\u0004\u0003\u000fr\u0018A\u0002\u001fs_>$h(\u0003\u0002\u0002\u000e%!\u0011QJA\u0006\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0015\u0002T\ta1+\u001a:jC2L'0\u00192mK*!\u0011QJA\u0006\u0003\tIG-\u0006\u0002\u0002ZA!\u00111LA1\u001b\t\tiFC\u0002\u0002`Y\fA!\\1jY&!\u00111MA/\u0005I)f\u000e]1sg\u0016$\u0017\nZ3oi&$\u00180\u00133\u0002\u0007%$\u0007%A\u0005fq\u000e,\u0007\u000f^5p]V\u0011\u00111\u000e\t\u0005\u0003\u007f\ti'\u0003\u0003\u0002p\u0005M#!\u0003+ie><\u0018M\u00197f\u0003))\u0007pY3qi&|g\u000e\t\u000b\u0007\u0003k\n9(!\u001f\u0011\u0007\u0005UB\u0004C\u0004\u0002V\u0005\u0002\r!!\u0017\t\u000f\u0005\u001d\u0014\u00051\u0001\u0002l\u0005Q\u0011m]*fi\u0016\u0013(o\u001c:\u0016\u0005\u0005}\u0004\u0003BAA\u0003\u000fk!!a!\u000b\u0007\u0005\u0015e/\u0001\u0003d_J,\u0017\u0002BAE\u0003\u0007\u0013\u0001bU3u\u000bJ\u0014xN]\u0001\u0005G>\u0004\u0018\u0010\u0006\u0004\u0002v\u0005=\u0015\u0011\u0013\u0005\n\u0003+\u001a\u0003\u0013!a\u0001\u00033B\u0011\"a\u001a$!\u0003\u0005\r!a\u001b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u0013\u0016\u0005\u00033\nIj\u000b\u0002\u0002\u001cB!\u0011QTAT\u001b\t\tyJ\u0003\u0003\u0002\"\u0006\r\u0016!C;oG\",7m[3e\u0015\u0011\t)+a\u0003\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002*\u0006}%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAAXU\u0011\tY'!'\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t)\f\u0005\u0003\u00028\u0006\u0005WBAA]\u0015\u0011\tY,!0\u0002\t1\fgn\u001a\u0006\u0003\u0003\u007f\u000bAA[1wC&!\u00111YA]\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011\u001a\t\u0005\u0003\u0013\tY-\u0003\u0003\u0002N\u0006-!aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAj\u00033\u0004B!!\u0003\u0002V&!\u0011q[A\u0006\u0005\r\te.\u001f\u0005\n\u00037D\u0013\u0011!a\u0001\u0003\u0013\f1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAq!\u0019\t\u0019/!;\u0002T6\u0011\u0011Q\u001d\u0006\u0005\u0003O\fY!\u0001\u0006d_2dWm\u0019;j_:LA!a;\u0002f\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t\t0a>\u0011\t\u0005%\u00111_\u0005\u0005\u0003k\fYAA\u0004C_>dW-\u00198\t\u0013\u0005m'&!AA\u0002\u0005M\u0017A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!!.\u0002~\"I\u00111\\\u0016\u0002\u0002\u0003\u0007\u0011\u0011Z\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011\u0011Z\u0001\ti>\u001cFO]5oOR\u0011\u0011QW\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005E(1\u0002\u0005\n\u00037t\u0013\u0011!a\u0001\u0003'\u0014Q\"\u00169eCR,7+^2dKN\u001c8#\u0003\u0004\u0002\b\u0005M\u0012qGA\u001f+\t\u0011\u0019\u0002\u0005\u0003\u0003\u0016\t}QB\u0001B\f\u0015\u0011\u0011IBa\u0007\u0002\u000b5|G-\u001a7\u000b\u0007\tua/A\u0002ba&LAA!\t\u0003\u0018\tQ\u0011\nZ3oi&$\u00180\u00133\u0015\t\t\u0015\"q\u0005\t\u0004\u0003k1\u0001bBA+\u0013\u0001\u0007!1\u0003\u000b\u0005\u0005K\u0011Y\u0003C\u0005\u0002V)\u0001\n\u00111\u0001\u0003\u0014U\u0011!q\u0006\u0016\u0005\u0005'\tI\n\u0006\u0003\u0002T\nM\u0002\"CAn\u001d\u0005\u0005\t\u0019AAe)\u0011\t\tPa\u000e\t\u0013\u0005m\u0007#!AA\u0002\u0005MG\u0003BA[\u0005wA\u0011\"a7\u0012\u0003\u0003\u0005\r!!3\u0015\t\u0005E(q\b\u0005\n\u00037$\u0012\u0011!a\u0001\u0003'\fQ\"\u00169eCR,7+^2dKN\u001c\bcAA\u001b-M)aCa\u0012\u0003TAA!\u0011\nB(\u0005'\u0011)#\u0004\u0002\u0003L)!!QJA\u0006\u0003\u001d\u0011XO\u001c;j[\u0016LAA!\u0015\u0003L\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u0019\u0011\t\tU#1L\u0007\u0003\u0005/RAA!\u0017\u0002>\u0006\u0011\u0011n\\\u0005\u0005\u0003#\u00129\u0006\u0006\u0002\u0003D\u0005)\u0011\r\u001d9msR!!Q\u0005B2\u0011\u001d\t)&\u0007a\u0001\u0005'\tq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003j\t=\u0004CBA\u0005\u0005W\u0012\u0019\"\u0003\u0003\u0003n\u0005-!AB(qi&|g\u000eC\u0005\u0003ri\t\t\u00111\u0001\u0003&\u0005\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\t]\u0004\u0003BA\\\u0005sJAAa\u001f\u0002:\n1qJ\u00196fGR\fQ\"\u00169eCR,g)Y5mkJ,\u0007cAA\u001baM)\u0001Ga!\u0003TAQ!\u0011\nBC\u00033\nY'!\u001e\n\t\t\u001d%1\n\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014DC\u0001B@)\u0019\t)H!$\u0003\u0010\"9\u0011QK\u001aA\u0002\u0005e\u0003bBA4g\u0001\u0007\u00111\u000e\u000b\u0005\u0005'\u0013Y\n\u0005\u0004\u0002\n\t-$Q\u0013\t\t\u0003\u0013\u00119*!\u0017\u0002l%!!\u0011TA\u0006\u0005\u0019!V\u000f\u001d7fe!I!\u0011\u000f\u001b\u0002\u0002\u0003\u0007\u0011QO\u0001\u001a\u0013\u0012,g\u000e^5usN+G/\u00169eCR,'+Z:q_:\u001cX\rE\u0002\u00026]\u0012\u0011$\u00133f]RLG/_*fiV\u0003H-\u0019;f%\u0016\u001c\bo\u001c8tKN)q'a\u0002\u0003TQ\u0011!qT\u0001\u0006K6\u0004H/_\u000b\u0003\u0005W\u00032!!\u000e>'\u001di\u0014qAA\u001c\u0003{\tQA^1mk\u0016,\"Aa-\u0011\t\tU&QY\u0007\u0003\u0005oSAA!/\u0003<\u0006!!n]8o\u0015\u0011\u0011iLa0\u0002\t1L'm\u001d\u0006\u0005\u0005;\u0011\tM\u0003\u0002\u0003D\u0006!\u0001\u000f\\1z\u0013\u0011\u00119Ma.\u0003\u0011)\u001bxJ\u00196fGR\faA^1mk\u0016\u0004C\u0003\u0002BV\u0005\u001bDqAa,A\u0001\u0004\u0011\u0019\f\u0006\u0003\u0003,\nE\u0007\"\u0003BX\u0003B\u0005\t\u0019\u0001BZ+\t\u0011)N\u000b\u0003\u00034\u0006eE\u0003BAj\u00053D\u0011\"a7F\u0003\u0003\u0005\r!!3\u0015\t\u0005E(Q\u001c\u0005\n\u00037<\u0015\u0011!a\u0001\u0003'$B!!.\u0003b\"I\u00111\u001c%\u0002\u0002\u0003\u0007\u0011\u0011\u001a\u000b\u0005\u0003c\u0014)\u000fC\u0005\u0002\\.\u000b\t\u00111\u0001\u0002TR!!1\u0016Bu\u0011\u001d\u0011yK\u000fa\u0001\u0005g#BA!<\u0003pB1\u0011\u0011\u0002B6\u0005gC\u0011B!\u001d<\u0003\u0003\u0005\rAa+\u00031%#WM\u001c;jif\u001cV\r^+qI\u0006$XMU3tk2$8oE\u0004M\u0003\u000f\t9$!\u0010\u0002\u000fI,7/\u001e7ugV\u0011!\u0011 \t\u0007\u0003\u007f\u0011Y0a\r\n\t\tu\u00181\u000b\u0002\u0004'\u0016\f\u0018\u0001\u0003:fgVdGo\u001d\u0011\u0015\t\r\r1Q\u0001\t\u0004\u0003ka\u0005b\u0002B{\u001f\u0002\u0007!\u0011`\u0001\bkB$\u0017\r^3e+\t\u0019Y\u0001\u0005\u0005\u0004\u000e\rU!1\u0003BV\u001d\u0011\u0019ya!\u0005\u0011\t\u0005\r\u00131B\u0005\u0005\u0007'\tY!\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0007/\u0019IBA\u0002NCBTAaa\u0005\u0002\f\u0005Qan\u001c;Va\u0012\fG/\u001a3\u0016\u0005\r}\u0001\u0003CB\u0007\u0007+\tI&a \u0015\t\r\r11\u0005\u0005\n\u0005k\u0014\u0006\u0013!a\u0001\u0005s,\"aa\n+\t\te\u0018\u0011\u0014\u000b\u0005\u0003'\u001cY\u0003C\u0005\u0002\\Z\u000b\t\u00111\u0001\u0002JR!\u0011\u0011_B\u0018\u0011%\tY\u000eWA\u0001\u0002\u0004\t\u0019\u000e\u0006\u0003\u00026\u000eM\u0002\"CAn3\u0006\u0005\t\u0019AAe)\u0011\t\tpa\u000e\t\u0013\u0005mG,!AA\u0002\u0005M\u0017\u0001G%eK:$\u0018\u000e^=TKR,\u0006\u000fZ1uKJ+7/\u001e7ugB\u0019\u0011Q\u00070\u0014\u000by\u001byDa\u0015\u0011\u0011\t%#q\nB}\u0007\u0007!\"aa\u000f\u0015\t\r\r1Q\t\u0005\b\u0005k\f\u0007\u0019\u0001B})\u0011\u0019Iea\u0013\u0011\r\u0005%!1\u000eB}\u0011%\u0011\tHYA\u0001\u0002\u0004\u0019\u0019!\u0001\bJI\u0016tG/\u001b;z+B$\u0017\r^3\u0011\u0007\u0005URM\u0001\bJI\u0016tG/\u001b;z+B$\u0017\r^3\u0014\u0007\u0015\f9\u0001\u0006\u0002\u0004P\u0005\t2/\u001a:wKJ\u001cV\r\u001e)s_B,'\u000f^=\u0016\u0005\rm\u0003CBB\u0007\u0007;\u001a\t'\u0003\u0003\u0004`\re!aA*fiB!1QBB2\u0013\u0011\t\u0019m!\u0007\u0002%M,'O^3s'\u0016$\bK]8qKJ$\u0018\u0010I\u0001\u0015CN\u001c\u0018n\u001a8bE2,\u0007K]8qKJ$\u0018.Z:\u0002+\u0005\u001c8/[4oC\ndW\r\u0015:pa\u0016\u0014H/[3tA\u0005y1N\\8x]B\u0013x\u000e]3si&,7/\u0001\tl]><h\u000e\u0015:pa\u0016\u0014H/[3tAM\u0019Q.a\u0002\u0002%%$WM\u001c;jif\u0014V\r]8tSR|'/\u001f\t\u0005\u0007k\u001aY(\u0004\u0002\u0004x)!1\u0011\u0010B\u000e\u0003!IG-\u001a8uSRL\u0018\u0002BB?\u0007o\u0012!#\u00133f]RLG/\u001f*fa>\u001c\u0018\u000e^8ssR!1\u0011QBB!\r\t\t!\u001c\u0005\b\u0007cz\u0007\u0019AB:Q\ry7q\u0011\t\u0005\u0007\u0013\u001b\u0019*\u0004\u0002\u0004\f*!1QRBH\u0003\u0019IgN[3di*\u00111\u0011S\u0001\bU\u0006\\\u0017M\u001d;b\u0013\u0011\u0019)ja#\u0003\r%s'.Z2u\u0003\u0019)\b\u000fZ1uKR111TBd\u0007#\u0004ba!(\u0004,\u000e=VBABP\u0015\u0011\u0019\tka)\u0002\u0013A,(\r\\5tQ\u0016\u0014(\u0002BA\u0007\u0007KSA!!\"\u0004(*\u00111\u0011V\u0001\be\u0016\f7\r^8s\u0013\u0011\u0019ika(\u0003\u000bMkuN\\8\u0011\u0007\rEFJD\u0002\u00044\u0002qAa!.\u0004F:!1qWBb\u001d\u0011\u0019Il!1\u000f\t\rm6q\u0018\b\u0005\u0003\u0007\u001ai,C\u0001~\u0013\tYH0\u0003\u0002zu&\u0011q\u000f_\u0005\u0003kZDqa!3q\u0001\u0004\u0019Y-A\u0004sKF,Xm\u001d;\u0011\t\u0005m3QZ\u0005\u0005\u0007\u001f\fiF\u0001\nJI\u0016tG/\u001b;z'\u0016$(+Z9vKN$\bbBBja\u0002\u00071Q[\u0001\u000f[\u0006LGNY8y'\u0016\u001c8/[8o!\u0011\u00199n!8\u000e\u0005\re'bABnq\u00069Q.Y5mE>D\u0018\u0002BBp\u00073\u0014a\"T1jY\n|\u0007pU3tg&|g.\u0001\u0007qCJ\u001cXMU3rk\u0016\u001cH\u000f\u0006\u0003\u0004f\u000e]\b\u0003CA \u0007O\u001cYo!=\n\t\r%\u00181\u000b\u0002\u0007\u000b&$\b.\u001a:\u0011\t\u0005}2Q^\u0005\u0005\u0007_\f\u0019FA\u0005Fq\u000e,\u0007\u000f^5p]B!1QOBz\u0013\u0011\u0019)pa\u001e\u0003+%#WM\u001c;jif,\u0006\u000fZ1uKJ+\u0017/^3ti\"91\u0011`9A\u0002\tM\u0016\u0001\u00036t\u001f\nTWm\u0019;\u0015\u0011\ruH\u0011\u0001C\u0003\t\u0013\u0001ba!(\u0004,\u000e}\bcABY\u000b!9A1\u0001:A\u0002\tM\u0011AC5eK:$\u0018\u000e^=JI\"9Aq\u0001:A\u0002\rE\u0018!D;qI\u0006$XMU3rk\u0016\u001cH\u000fC\u0004\u0004TJ\u0004\ra!6")
public class IdentitySetUpdatePerformer {
    private final IdentityRepository identityRepository;

    public SMono<IdentitySetUpdateResults> update(IdentitySetRequest request, MailboxSession mailboxSession) {
        SFlux qual$1 = SFlux$.MODULE$.fromIterable((Iterable)request.update().getOrElse((Function0 & Serializable)() -> (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
        Function1 & Serializable x$1 = (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                UnparsedIdentityId unparsedId = (UnparsedIdentityId)tuple2._1();
                JsObject json = (JsObject)tuple2._2();
                Either either = unparsedId.validate().flatMap((Function1 & Serializable)identityId -> this.parseRequest(json).map((Function1 & Serializable)updateRequest -> this.update((IdentityId)identityId, (IdentityUpdateRequest)updateRequest, mailboxSession).onErrorResume((Function1 & Serializable)error -> SMono$.MODULE$.just((Object)new UpdateFailure(unparsedId, (Throwable)error)))));
                return (SMono)either.fold((Function1 & Serializable)error -> SMono$.MODULE$.just((Object)new UpdateFailure(unparsedId, (Throwable)error)), (Function1 & Serializable)updateRequestResult -> updateRequestResult);
            }
            throw new MatchError((Object)tuple2);
        };
        int x$2 = qual$1.concatMap$default$2();
        return qual$1.concatMap((Function1)x$1, x$2).collectSeq().map((Function1)IdentitySetUpdatePerformer$IdentitySetUpdateResults$.MODULE$);
    }

    private Either<Exception, IdentityUpdateRequest> parseRequest(JsObject jsObject) {
        return IdentitySet$.MODULE$.validateProperties(IdentitySetUpdatePerformer$IdentityUpdate$.MODULE$.serverSetProperty(), IdentitySetUpdatePerformer$IdentityUpdate$.MODULE$.knownProperties(), jsObject).flatMap((Function1 & Serializable)validJsObject -> IdentitySerializer$.MODULE$.deserializeIdentityUpdateRequest((JsValue)validJsObject).asEither().left().map((Function1 & Serializable)errors -> IdentitySetParseException$.MODULE$.from((Seq<Tuple2<JsPath, Seq<JsonValidationError>>>)errors)).map((Function1 & Serializable)parsedRequest -> parsedRequest));
    }

    private SMono<UpdateResult> update(IdentityId identityId, IdentityUpdateRequest updateRequest, MailboxSession mailboxSession) {
        return SMono$.MODULE$.fromPublisher(this.identityRepository.update(mailboxSession.getUser(), identityId, updateRequest)).then(SMono$.MODULE$.just((Object)new UpdateSuccess(identityId)));
    }

    @Inject
    public IdentitySetUpdatePerformer(IdentityRepository identityRepository) {
        this.identityRepository = identityRepository;
    }

    public static class IdentitySetUpdateResponse
    implements Product,
    Serializable {
        private final JsObject value;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public JsObject value() {
            return this.value;
        }

        public IdentitySetUpdateResponse copy(JsObject value) {
            return new IdentitySetUpdateResponse(value);
        }

        public JsObject copy$default$1() {
            return this.value();
        }

        public String productPrefix() {
            return "IdentitySetUpdateResponse";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.value();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof IdentitySetUpdateResponse;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "value";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof IdentitySetUpdateResponse)) return false;
            boolean bl = true;
            if (!bl) return false;
            IdentitySetUpdateResponse identitySetUpdateResponse = (IdentitySetUpdateResponse)x$1;
            JsObject jsObject = this.value();
            JsObject jsObject2 = identitySetUpdateResponse.value();
            if (jsObject == null) {
                if (jsObject2 != null) {
                    return false;
                }
            } else if (!jsObject.equals(jsObject2)) return false;
            if (!identitySetUpdateResponse.canEqual(this)) return false;
            return true;
        }

        public IdentitySetUpdateResponse(JsObject value) {
            this.value = value;
            Product.$init$((Product)this);
        }
    }

    public static class IdentitySetUpdateResults
    implements Product,
    Serializable {
        private final scala.collection.immutable.Seq<UpdateResult> results;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public scala.collection.immutable.Seq<UpdateResult> results() {
            return this.results;
        }

        public Map<IdentityId, IdentitySetUpdateResponse> updated() {
            return ((IterableOnceOps)this.results().flatMap((Function1 & Serializable)result -> {
                UpdateResult updateResult = result;
                if (updateResult instanceof UpdateSuccess) {
                    UpdateSuccess updateSuccess = (UpdateSuccess)updateResult;
                    return new Some((Object)new Tuple2((Object)updateSuccess.id(), (Object)IdentitySetUpdatePerformer$IdentitySetUpdateResponse$.MODULE$.empty()));
                }
                return None$.MODULE$;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        public Map<UnparsedIdentityId, SetError> notUpdated() {
            return ((IterableOnceOps)this.results().flatMap((Function1 & Serializable)result -> {
                UpdateResult updateResult = result;
                if (updateResult instanceof UpdateFailure) {
                    UpdateFailure updateFailure = (UpdateFailure)updateResult;
                    return new Some((Object)new Tuple2((Object)updateFailure.id(), (Object)updateFailure.asSetError()));
                }
                return None$.MODULE$;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        public IdentitySetUpdateResults copy(scala.collection.immutable.Seq<UpdateResult> results) {
            return new IdentitySetUpdateResults(results);
        }

        public scala.collection.immutable.Seq<UpdateResult> copy$default$1() {
            return this.results();
        }

        public String productPrefix() {
            return "IdentitySetUpdateResults";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.results();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof IdentitySetUpdateResults;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "results";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof IdentitySetUpdateResults)) return false;
            boolean bl = true;
            if (!bl) return false;
            IdentitySetUpdateResults identitySetUpdateResults = (IdentitySetUpdateResults)x$1;
            scala.collection.immutable.Seq<UpdateResult> seq = this.results();
            scala.collection.immutable.Seq<UpdateResult> seq2 = identitySetUpdateResults.results();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!identitySetUpdateResults.canEqual(this)) return false;
            return true;
        }

        public IdentitySetUpdateResults(scala.collection.immutable.Seq<UpdateResult> results) {
            this.results = results;
            Product.$init$((Product)this);
        }
    }

    public static class UpdateFailure
    implements UpdateResult,
    Product,
    Serializable {
        private final UnparsedIdentityId id;
        private final Throwable exception;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public UnparsedIdentityId id() {
            return this.id;
        }

        public Throwable exception() {
            return this.exception;
        }

        public SetError asSetError() {
            Throwable throwable = this.exception();
            if (throwable instanceof IdentitySetParseException) {
                IdentitySetParseException identitySetParseException = (IdentitySetParseException)throwable;
                IdentitySetUpdatePerformer$.MODULE$.org$apache$james$jmap$method$IdentitySetUpdatePerformer$$LOGGER().info("Error parsing Identity/set update", (Throwable)identitySetParseException);
                return identitySetParseException.setError();
            }
            if (throwable instanceof IdentityNotFoundException) {
                IdentityNotFoundException identityNotFoundException = (IdentityNotFoundException)throwable;
                IdentitySetUpdatePerformer$.MODULE$.org$apache$james$jmap$method$IdentitySetUpdatePerformer$$LOGGER().info("Identity not found in Identity/set update {}", (Object)identityNotFoundException.getMessage());
                return SetError$.MODULE$.notFound(identityNotFoundException.getMessage());
            }
            if (throwable instanceof InvalidPropertyException) {
                InvalidPropertyException invalidPropertyException = (InvalidPropertyException)throwable;
                IdentitySetUpdatePerformer$.MODULE$.org$apache$james$jmap$method$IdentitySetUpdatePerformer$$LOGGER().info("Invalid property in Identity/set update {}", (Object)invalidPropertyException.getCause().getMessage());
                return SetError$.MODULE$.invalidPatch(invalidPropertyException.getCause().getMessage());
            }
            if (throwable instanceof IllegalArgumentException) {
                IllegalArgumentException illegalArgumentException = (IllegalArgumentException)throwable;
                IdentitySetUpdatePerformer$.MODULE$.org$apache$james$jmap$method$IdentitySetUpdatePerformer$$LOGGER().info("Illegal argument in Identity/set update", (Throwable)illegalArgumentException);
                return SetError$.MODULE$.invalidArguments(illegalArgumentException.getMessage(), (Option<Properties>)None$.MODULE$);
            }
            IdentitySetUpdatePerformer$.MODULE$.org$apache$james$jmap$method$IdentitySetUpdatePerformer$$LOGGER().error("Failed to delete identity", throwable);
            return SetError$.MODULE$.serverFail(this.exception().getMessage());
        }

        public UpdateFailure copy(UnparsedIdentityId id, Throwable exception) {
            return new UpdateFailure(id, exception);
        }

        public UnparsedIdentityId copy$default$1() {
            return this.id();
        }

        public Throwable copy$default$2() {
            return this.exception();
        }

        public String productPrefix() {
            return "UpdateFailure";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.id();
                }
                case 1: {
                    return this.exception();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof UpdateFailure;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "id";
                }
                case 1: {
                    return "exception";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof UpdateFailure)) return false;
            boolean bl = true;
            if (!bl) return false;
            UpdateFailure updateFailure = (UpdateFailure)x$1;
            UnparsedIdentityId unparsedIdentityId = this.id();
            UnparsedIdentityId unparsedIdentityId2 = updateFailure.id();
            if (unparsedIdentityId == null) {
                if (unparsedIdentityId2 != null) {
                    return false;
                }
            } else if (!((Object)unparsedIdentityId).equals(unparsedIdentityId2)) return false;
            Throwable throwable = this.exception();
            Throwable throwable2 = updateFailure.exception();
            if (throwable == null) {
                if (throwable2 != null) {
                    return false;
                }
            } else if (!throwable.equals(throwable2)) return false;
            if (!updateFailure.canEqual(this)) return false;
            return true;
        }

        public UpdateFailure(UnparsedIdentityId id, Throwable exception) {
            this.id = id;
            this.exception = exception;
            Product.$init$((Product)this);
        }
    }

    public static interface UpdateResult {
    }

    public static class UpdateSuccess
    implements UpdateResult,
    Product,
    Serializable {
        private final IdentityId id;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public IdentityId id() {
            return this.id;
        }

        public UpdateSuccess copy(IdentityId id) {
            return new UpdateSuccess(id);
        }

        public IdentityId copy$default$1() {
            return this.id();
        }

        public String productPrefix() {
            return "UpdateSuccess";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.id();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof UpdateSuccess;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "id";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof UpdateSuccess)) return false;
            boolean bl = true;
            if (!bl) return false;
            UpdateSuccess updateSuccess = (UpdateSuccess)x$1;
            IdentityId identityId = this.id();
            IdentityId identityId2 = updateSuccess.id();
            if (identityId == null) {
                if (identityId2 != null) {
                    return false;
                }
            } else if (!identityId.equals(identityId2)) return false;
            if (!updateSuccess.canEqual(this)) return false;
            return true;
        }

        public UpdateSuccess(IdentityId id) {
            this.id = id;
            Product.$init$((Product)this);
        }
    }
}

