/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.util.pngj.chunks;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.util.pngj.IChunkFactory;
import org.jetbrains.letsPlot.util.pngj.ImageInfo;
import org.jetbrains.letsPlot.util.pngj.chunks.ChunkRaw;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunk;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkBKGD;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkCHRM;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkGAMA;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkHIST;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkICCP;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkIDAT;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkIEND;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkIHDR;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkITXT;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkOFFS;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkPHYS;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkPLTE;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkSBIT;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkSPLT;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkSRGB;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkSTER;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkTEXT;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkTIME;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkTRNS;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkUNKNOWN;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkZTXT;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u001c\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u001c\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u001a\u0010\u0012\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/chunks/ChunkFactory;", "Lorg/jetbrains/letsPlot/util/pngj/IChunkFactory;", "parse", "", "(Z)V", "getParse", "()Z", "setParse", "createChunk", "Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunk;", "chunkRaw", "Lorg/jetbrains/letsPlot/util/pngj/chunks/ChunkRaw;", "imgInfo", "Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;", "createEmptyChunkExtended", "id", "", "createEmptyChunkKnown", "createEmptyChunkUnknown", "plot-api"})
public final class ChunkFactory
implements IChunkFactory {
    private boolean parse;

    @JvmOverloads
    public ChunkFactory(boolean parse) {
        this.parse = parse;
    }

    public /* synthetic */ ChunkFactory(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    public final boolean getParse() {
        return this.parse;
    }

    public final void setParse(boolean bl) {
        this.parse = bl;
    }

    @Override
    @NotNull
    public PngChunk createChunk(@NotNull ChunkRaw chunkRaw, @Nullable ImageInfo imgInfo) {
        Intrinsics.checkNotNullParameter((Object)chunkRaw, (String)"chunkRaw");
        PngChunk c = this.createEmptyChunkKnown(chunkRaw.getId(), imgInfo);
        if (c == null) {
            c = this.createEmptyChunkExtended(chunkRaw.getId(), imgInfo);
        }
        if (c == null) {
            c = this.createEmptyChunkUnknown(chunkRaw.getId(), imgInfo);
        }
        c.setRaw(chunkRaw);
        if (this.parse && chunkRaw.getData() != null) {
            c.parseFromRaw(chunkRaw);
        }
        return c;
    }

    private final PngChunk createEmptyChunkKnown(String id, ImageInfo imgInfo) {
        if (Intrinsics.areEqual((Object)id, (Object)"IDAT")) {
            return new PngChunkIDAT(imgInfo);
        }
        if (Intrinsics.areEqual((Object)id, (Object)"IHDR")) {
            return new PngChunkIHDR(imgInfo);
        }
        if (Intrinsics.areEqual((Object)id, (Object)"PLTE")) {
            return new PngChunkPLTE(imgInfo);
        }
        if (Intrinsics.areEqual((Object)id, (Object)"IEND")) {
            return new PngChunkIEND(imgInfo);
        }
        if (Intrinsics.areEqual((Object)id, (Object)"tEXt")) {
            return new PngChunkTEXT(imgInfo);
        }
        if (Intrinsics.areEqual((Object)id, (Object)"iTXt")) {
            return new PngChunkITXT(imgInfo);
        }
        if (Intrinsics.areEqual((Object)id, (Object)"zTXt")) {
            return new PngChunkZTXT(imgInfo);
        }
        if (Intrinsics.areEqual((Object)id, (Object)"bKGD")) {
            return new PngChunkBKGD(imgInfo);
        }
        if (Intrinsics.areEqual((Object)id, (Object)"gAMA")) {
            return new PngChunkGAMA(imgInfo);
        }
        if (Intrinsics.areEqual((Object)id, (Object)"pHYs")) {
            return new PngChunkPHYS(imgInfo);
        }
        if (Intrinsics.areEqual((Object)id, (Object)"iCCP")) {
            return new PngChunkICCP(imgInfo);
        }
        if (Intrinsics.areEqual((Object)id, (Object)"tIME")) {
            return new PngChunkTIME(imgInfo);
        }
        if (Intrinsics.areEqual((Object)id, (Object)"tRNS")) {
            return new PngChunkTRNS(imgInfo);
        }
        if (Intrinsics.areEqual((Object)id, (Object)"cHRM")) {
            return new PngChunkCHRM(imgInfo);
        }
        if (Intrinsics.areEqual((Object)id, (Object)"sBIT")) {
            return new PngChunkSBIT(imgInfo);
        }
        if (Intrinsics.areEqual((Object)id, (Object)"sRGB")) {
            return new PngChunkSRGB(imgInfo);
        }
        if (Intrinsics.areEqual((Object)id, (Object)"hIST")) {
            return new PngChunkHIST(imgInfo);
        }
        if (Intrinsics.areEqual((Object)id, (Object)"sPLT")) {
            return new PngChunkSPLT(imgInfo);
        }
        return null;
    }

    private final PngChunk createEmptyChunkUnknown(String id, ImageInfo imgInfo) {
        return new PngChunkUNKNOWN(id, imgInfo);
    }

    private final PngChunk createEmptyChunkExtended(String id, ImageInfo imgInfo) {
        if (Intrinsics.areEqual((Object)id, (Object)"oFFs")) {
            return new PngChunkOFFS(imgInfo);
        }
        return Intrinsics.areEqual((Object)id, (Object)"sTER") ? (PngChunk)new PngChunkSTER(imgInfo) : null;
    }

    @JvmOverloads
    public ChunkFactory() {
        this(false, 1, null);
    }
}

