/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JLabel;
import javax.swing.JSlider;
import org.apache.log4j.Level;

final class ThresholdSlider
extends JSlider {
    final List priorityList;

    ThresholdSlider() {
        Level[] levels = new Level[]{Level.OFF, Level.FATAL, Level.ERROR, Level.WARN, Level.INFO, Level.DEBUG, Level.TRACE, Level.ALL};
        this.priorityList = Arrays.asList(levels);
        this.priorityList.sort((o1, o2) -> {
            Level p1 = (Level)o1;
            Level p2 = (Level)o2;
            if (p1.toInt() == p2.toInt()) {
                return 0;
            }
            if (p1.toInt() < p2.toInt()) {
                return -1;
            }
            return 1;
        });
        this.setModel(new DefaultBoundedRangeModel(this.priorityList.indexOf(Level.TRACE), 0, 0, this.priorityList.size() - 1));
        Hashtable<Integer, JLabel> labelMap = new Hashtable<Integer, JLabel>();
        for (Object aPriorityList : this.priorityList) {
            Level item = (Level)aPriorityList;
            labelMap.put(this.priorityList.indexOf(item), new JLabel(item.toString()));
        }
        this.setOrientation(1);
        this.setInverted(true);
        this.setLabelTable(labelMap);
        this.setPaintLabels(true);
        this.setSnapToTicks(true);
    }

    void setChosenLevel(Level level) {
        this.setValue(this.priorityList.indexOf(level));
    }

    Level getSelectedLevel() {
        Level level = (Level)this.priorityList.get(this.getValue());
        if (level == null) {
            level = Level.TRACE;
        }
        return level;
    }
}

