"use strict";
/*! Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StandardInits = void 0;
const mona_dish_1 = require("mona-dish");
/**
 * helpers with various init and html patterns
 *
 * We use jsdom global which builds up a
 * dom tree and emulates a full environment
 *
 * Note the buildup and loading is asynchronous so
 * we have to work with Promises and asyncs to get things
 * where we want to have them
 *
 * This is a pattern pretty much for every test which iterates over
 * multiple doms
 */
var StandardInits;
(function (StandardInits) {
    StandardInits.HTML_DEFAULT = `<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Title</title>
</head>
<body>
<div id="id_1"></div>
<div id="id_2" booga="blarg"></div>
<div id="id_3"></div>
<div id="id_4"></div>
</body>
</html>`;
    StandardInits.HTML_SHADOW = `<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Title</title>
</head>
<body>
<form id="blarg">
    <input type="text" id="blarg:input_1" name="blarg:input_1" value="input_1_val"></input>
    <input type="hidden" id="jakarta.faces.ViewState" name="jakarta.faces.ViewState" value="blubbblubblubb"></input>
    <input type="button" id="blarg:input_2" name="blarg:input_2" value="input_1_val"></input>
    <div id="shadowDomArea">
            <input type="button" id="blarg:input_3" name="blarg:input_3" value="input_3_val"></input>
    </div>
</form>
</body>
</html>`;
    /**
     * a page simulating basically a simple faces form
     */
    const HTML_FORM_DEFAULT = `<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Title</title>
</head>
<body>
<form id="blarg">
    <input type="text" id="input_1" name="input_1" value="input_1_val"></input>
    <input type="text" id="input_2_text" name="input_2_text" value="input_2_text_val"></input>
    <input type="hidden" id="jakarta.faces.ViewState" name="jakarta.faces.ViewState" value="blubbblubblubb"></input>
    <input type="button" id="input_2" name="input_2" value="input_1_val"></input>
</form>
</body>
</html>`;
    /**
     * a page simulating basically a simple faces form
     */
    const HTML_FORM_PREFIXED = `<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Title</title>
</head>
<body>
<form id="form1">
    <input type="text" id="form1:input_1::field" name="form1:input_1" value="form1:input_1_val"></input>
    <input type="hidden" id="form1:jakarta.faces.ViewState" name="jakarta.faces.ViewState" value="blubbblubblubb"></input>
    <input type="button" id="form1:input_2::field" name="form1:input_2" value="form1:input_1_val"></input>
    <input type="text" id="form1:input_3::field" name="form1:input_23 value="form1:input_1_val"></input>
</form>
</body>
</html>`;
    /**
     * a page based on Tobago for a file upload
     */
    const HTML_TOBAGO_FILE_FORM = `<!DOCTYPE html>
<html lang='de'>
 <head>
  <meta charset='UTF-8'>
  <meta name='viewport' content='width=device-width, initial-scale=1.0'>
  <title>Test</title>
 </head>
 <body>
  <tobago-page locale='de' class='container-fluid' id='page' focus-on-error='true' wait-overlay-delay-full='1000' wait-overlay-delay-ajax='1000'>
   <form action='/content/100-upload/File_Upload.xhtml' id='page::form' method='post' enctype='multipart/form-data' accept-charset='UTF-8' data-tobago-context-path=''>
    <input type='hidden' name='jakarta.faces.source' id='jakarta.faces.source' disabled='disabled'>
    <tobago-focus id='page::lastFocusId'>
     <input type='hidden' name='page::lastFocusId' id='page::lastFocusId::field'>
    </tobago-focus>
    <input type='hidden' name='org.apache.myfaces.tobago.webapp.Secret' id='org.apache.myfaces.tobago.webapp.Secret' value='secretValue'>
    <tobago-file id='page:fileAjax' class='tobago-auto-spacing'>
     <div class='input-group'>
      <input type='file' tabindex='-1' id='page:fileAjax::field' class='form-control' name='page:fileAjax'>
      <tobago-behavior event='change' client-id='page:fileAjax' field-id='page:fileAjax::field' execute='page:fileAjax'></tobago-behavior>
      <label class='input-group-text' for='page:fileAjax::field'><span><i class='bi-folder2-open'></i></span></label>
     </div>
    </tobago-file>
    <div class='tobago-page-menuStore'>
    </div>
    <span id='page::jsf-state-container'><input type='hidden' name='jakarta.faces.ViewState' id='j_id__v_0:jakarta.faces.ViewState:1' value='viewStateValue' autocomplete='off'><input type='hidden' name='jakarta.faces.RenderKitId' value='tobago'><input type='hidden' id='j_id__v_0:jakarta.faces.ClientWindow:1' name='jakarta.faces.ClientWindow' value='clientWindowValue'></span>
   </form>
  </tobago-page>
 </body>
</html>`;
    StandardInits.HTML_TOBAGO_SHEET_WITH_STYLE = `<!DOCTYPE html>
<html lang='de'>
<head>
  <meta charset='UTF-8'>
  <meta name='viewport' content='width=device-width, initial-scale=1.0'>
  <title>Test
  </title>
  <link rel='stylesheet' href='./fixtures/css/tobago.css' type='text/css'>
  <link rel='stylesheet' href='./fixtures/css/bootstrap-icons.css' type='text/css'>
  <script src='./fixtures/jakarta.faces.resource/faces.js.jsf' type='text/javascript'></script>
  <script src='./fixtures/js/tobago.js' type='module'></script>
</head>
<body>
<tobago-page locale='de' class='container-fluid' id='page' focus-on-error='true' wait-overlay-delay-full='1000'
             wait-overlay-delay-ajax='1000'>
  <form action='/content/080-sheet/30-event/Sheet_Event.xhtml' id='page::form' method='post'
        accept-charset='UTF-8' data-tobago-context-path=''>
    <input type='hidden' name='javax.faces.source' id='javax.faces.source' disabled='disabled'>
    <tobago-focus id='page::lastFocusId'>
      <input type='hidden' name='page::lastFocusId' id='page::lastFocusId::field'>
    </tobago-focus>
    <input type='hidden' name='org.apache.myfaces.tobago.webapp.Secret' id='org.apache.myfaces.tobago.webapp.Secret'
           value='secretValue'>
    <div class='tobago-page-menuStore'>
    </div>
    <span id='page::jsf-state-container'><input type='hidden' name='javax.faces.ViewState'
                                                id='j_id__v_0:javax.faces.ViewState:1'
                                                value='viewStateValue' autocomplete='off'><input
            type='hidden' name='javax.faces.RenderKitId' value='tobago'><input type='hidden'
                                                                               id='j_id__v_0:javax.faces.ClientWindow:1'
                                                                               name='javax.faces.ClientWindow'
                                                                               value='clientWindowValue'></span>
    <button type='button' id='page:ajaxButton' name='page:ajaxButton'
            class='tobago-button btn btn-secondary tobago-auto-spacing'>
      <tobago-behavior event='click' client-id='page:ajaxButton' execute='page:ajaxButton'
                       render='page:s1'></tobago-behavior>
      <span>Ajax</span></button>
    <tobago-sheet id='page:s1' data-tobago-selection-mode='multi' data-tobago-first='0' rows='0' row-count='2'>
      <style nonce='nonceValue' id='page:s1:j_id_4'>#page\\:s1 {
        max-height: 500px;
      }
      </style>
      <input id='page:s1::scrollPosition' name='page:s1::scrollPosition' type='hidden' value='[0,0]'>
      <input id='page:s1::selected' name='page:s1::selected' type='hidden' value='[]'>
      <div class='tobago-body'>
        <table cellspacing='0' cellpadding='0' summary='' class='table'>
          <thead>
          <tr>
            <th>
              <span><tobago-out id='page:s1:_col0'><span class='form-control-plaintext'>Name</span></tobago-out></span>
            </th>
          </tr>
          </thead>
          <tbody>
          <tr row-index='0'>
            <td>
              <tobago-out id='page:s1:0:t_name'><span class='form-control-plaintext'>Earth</span></tobago-out>
            </td>
            <td>
              <div>
              </div>
            </td>
          </tr>
          <tr row-index='1'>
            <td>
              <tobago-out id='page:s1:1:t_name'><span class='form-control-plaintext'>Moon</span></tobago-out>
            </td>
            <td>
              <div>
              </div>
            </td>
          </tr>
          </tbody>
        </table>
      </div>
    </tobago-sheet>
  </form>
  <noscript>
    <div class='tobago-page-noscript'>Diese Seite benötigt JavaScript, allerdings ist JavaScript in Ihrem Browser
      derzeit deaktiviert. Um JavaScript zu aktivieren, lesen Sie ggf. die Anleitung Ihres Browsers.
    </div>
  </noscript>
</tobago-page>
</body>
</html>`;
    /**
     * a page simulating basically a simple faces form
     */
    StandardInits.HTML_PREFIX_EMBEDDED_BODY = `<form id="form1">
  <tobago-in id="page:input" class="tobago-auto-spacing">
     <input type="text" name="page:input" id="page:input::field" class="form-control" value="input_value">
     <tobago-behavior event="change" client-id="page:input" field-id="page:input::field" execute="page:input" render="page:output"></tobago-behavior>
  </tobago-in>
  
  <tobago-out id="page:output" class="tobago-auto-spacing">
    <input type="text" name="page:output" id="page:output::field" class="form-control">
  </tobago-out>
</form>`;
    const HTML_FORM_PREFIXED_EMBEDDED = `<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Title</title>
</head>
<body>
    ${StandardInits.HTML_PREFIX_EMBEDDED_BODY}
</body>
</html>`;
    const HTML_FORM_NAMESPACED = `<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Title</title>
</head>
<body>
<form id="jd_0:blarg">
    <input type="text" id="jd_0:input_1" name="jd_0:input_1" value="input_1_val"></input>
    <input type="hidden" id="jd_0:jakarta.faces.ViewState" name="jakarta.faces.ViewState" value="blubbblubblubb"></input>
    <input type="button" id="jd_0:input_2" name="input_2" value="input_1_val"></input>
</form>
</body>
</html>`;
    const VIRTUAL_ELEMENT = `<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Title</title>
</head>
<body>
<form id="jd_0:blarg">
    <tobago-multi-select id="page:numbers">
        <input type="checkbox" name="page:numbers" id="page:numbers:1" value="1"></input>
        <input type="checkbox" name="page:numbers" id="page:numbers:2" value="2"></input>
        <input type="checkbox" name="page:numbers" id="page:numbers:3" value="3"></input>
    </tobago-multi-select>
</form>
</body>
</html>`;
    const CHECKBOX_RADIO_FORM = `
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Title</title>
</head>
<body>
<form id="form1">
        <input type="checkbox"  checked name="page:numbers:1" id="page:numbers:1" value="1"></input>
        <input type="checkbox" name="page:numbers:2" id="page:numbers:2" value="2"></input>
        <input type="checkbox" name="page:numbers:3" id="page:numbers:3" value="3"></input>
</form>

<form id="form2">
        <input type="radio"  checked name="page:numbers:r:1" id="page:numbers:r:1" value="1"></input>
        <input type="radio" name="page:numbers:r:2" id="page:numbers:r:2" value="2"></input>
        <input type="radio" name="page:numbers:r:3" id="page:numbers:r:3" value="3"></input>
</form>
</body>
</html>    
    `;
    /**
     * a page simulating basically a simple faces form
     */
    const HTML_FILE_FORM_DEFAULT = `<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Title</title>
</head>
<body>
<form id="blarg" enctype="multipart/form-data">
    <input type="file" id="fíleupload" name="fíleupload"></input>
    <input type="text" id="input_1" name="input_1" value="input_1_val"></input>
    <input type="hidden" id="jakarta.faces.ViewState" name="jakarta.faces.ViewState" value="blubbblubblubb"></input>
    <input type="button" id="input_2" name="input_2" value="input_1_val"></input>
</form>
</body>
</html>`;
    StandardInits.STD_XML = `<?xml version="1.0" encoding="utf-8"?><partial-response><changes><update id="value_1"><![CDATA[<span id="out1">2</span>]]></update><update id="jakarta.faces.ViewState"><![CDATA[j_id1:j_id3]]></update></changes></partial-response>`;
    /**
     * a page containing a faces.js input with a new separator char
     * @param separatorChar
     * @constructor
     */
    function HTML_DEFAULT_SEPARATOR_CHAR(separatorChar, IS_40 = true) {
        return `<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Title</title>
    <script type="text/javascript"
            src="./fixtures/${IS_40 ? 'jakarta' : 'javax'}.faces.resource/${IS_40 ? 'faces' : 'jsf'}.js.jsf?ln=jakarta.faces&separator=${separatorChar}"></script>
</head>
<body>
<form id="blarg">
    <input type="text" id="input_1" name="input_1"/>
    <input type="button" id="input_2" name="input_2"/>
</form>
</body>
</html>
    
    `;
    }
    StandardInits.ERROR_CHAIN_PAGE = `
    <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Title</title>
</head>
<body>
<h2>Error Chain Testcase</h2>
<script type="text/javascript">
/**
* code identical to mojarra test, both stem from me
* so mojarras side EPL here ASL2!
* 
* @param event
*/
function triggerRequestChain(event) {
    for(let cnt = 0; cnt < 5; cnt++) {
        faces.ajax.request(event.target, "click", {
            render:"form1",
            onerror: function() {
                document.getElementById("errorCalled").innerHTML = "1";
            }
        })
    }
}
</script>
<div id="errorCalled"></div>
<form id="form1">
    <div id="form1:out1">0</div>
    <input type="button" id="form1:button1" onclick="triggerRequestChain(event)">
</form>
</body>
</html>
    `;
    /**
     * This is a standardized small page mockup
     * testing the various aspects of the protocol
     * under pure html conditions
     *
     * We get the jsf out of the way and basically simulate what the browser sees
     */
    StandardInits.PROTOCOL_PAGE = `<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Title</title>
</head>
<body>
<h2>protocol testcase1</h2>

<div id="centerDiv">

    <h1>Selenium Testprobe for insert update delete and attribute change</h1>

    <h2>This test tests all aspects of the protocol, under xhr and iframe conditions</h2>

    <div id="testResults">
        
        <h3>Test Results</h3>

        <div id="evalarea1">eval area 1 triggered by eval</div>
        
        <div id="evalarea2">eval area 2 triggered by update</div>
        
        <div id="evalarea3">eval area 3 triggered by insert</div>
        
        <div id="evalarea4">eval area 4 triggered by a click on the changed attributes area</div>

        <div id="changesArea">update insert area</div>
        
        <div id="deleteable">delete area will be deleted once you press the delete button</div>
        
        <div id="attributeChange">attributes changes area</div>
    
        <div id="resource_area_1"></div>
        <div id="resource_area_2"></div>
        <div id="resource_area_3"></div>
        <div id="nonce_result"></div>
   
    </div>

    <h2>Call actions via normal ppr</h2>

    <form id="form1" action="boog.html">
    
        <input type="hidden" id="jakarta.faces.ViewState" name="jakarta.faces.ViewState" value="blubbblubblubb"></input>
    
        <input type="button" id="cmd_eval" value="eval"
               onclick="emitPPR(this, ('undefined' == typeof event)? null: event, 'eval1');"/>
               
        <input type="button" id="cmd_update_insert" value="update insert"
               onclick="emitPPR(this, ('undefined' == typeof event)? null: event, 'updateinsert1');"/>

        <input type="button" id="cmd_simple_resource" value="simple resource"
               onclick="emitPPR(this, ('undefined' == typeof event)? null: event, 'simpleresource');"/>

        <input type="button" id="cmd_complex_resource" value="complex resource"
               onclick="emitPPR(this, ('undefined' == typeof event)? null: event, 'complex_resource');"/>
               
        <input type="button" id="cmd_complex_resource2" value="complex resource2"
               onclick="emitPPR(this, ('undefined' == typeof event)? null: event, 'complex_resource2');"/>       
               
        <input type="button" id="cmd_update_insert2" value="update insert second protocol path"
               onclick="emitPPR(this, ('undefined' == typeof event)? null: event, 'updateinsert2');"/>

        <input type="button" id="cmd_delete" value="delete"
               onclick="emitPPR(this, ('undefined' == typeof event)? null: event, 'delete1');"/>

        <input type="button" id="cmd_replace" value="Replace Body"
               onclick="emitPPR(this, ('undefined' == typeof event)? null: event, 'body_replace1');"/>

        <input type="button" id="cmd_attributeschange" value="change attributes"
               onclick="emitPPR(this, ('undefined' == typeof event)? null: event, 'attributes');"/>

        <input type="button" id="cmd_illegalresponse" value="illegal response, error trigger"
               onclick="emitPPR(this, ('undefined' == typeof event)? null: event, 'illegalResponse');"/>

        <input type="button" id="cmd_viewstate" value="Viewstate only update trigger"
               onclick="emitPPR(this, ('undefined' == typeof event)? null: event, 'viewstate');"/>

        <input type="button" id="cmd_error" value="Server error with error response"
               onclick="emitPPR(this, ('undefined' == typeof event)? null: event, 'errors');"/>

        <input type="button" id="cmd_error_component" value="Error: no component given"
               onclick="(window.faces || window.jsf).ajax.request(null, event, {}); return false"/>

    </form>

    <script type="text/javascript">
        document.getElementById("evalarea1").innerHTML = "booga";

        var target = "./test.mockup";

        function emitPPR(source, event, action, useIframe, formName) {
            document.getElementById(formName || "form1").action = target;

            (window?.faces ?? window.jsf).ajax.request(/*String|Dom Node*/ source, /*|EVENT|*/ (window.event) ? window.event : event, /*{|OPTIONS|}*/ {op: action});
        }
    </script>
</div>
</body>`;
    function basicXML() {
        return new window.DOMParser().parseFromString(StandardInits.STD_XML, "text/xml");
    }
    StandardInits.basicXML = basicXML;
    function standardInit(scope, initFunc = defaultHtml) {
        global.navigator = {
            language: "en-En"
        };
        return initFunc(false).then((closeFunc) => {
            scope.currentTest.closeIt = () => {
                closeFunc();
                delete global.navigator;
            };
        });
    }
    StandardInits.standardInit = standardInit;
    function standardClose(scope) {
        scope.currentTest.closeIt();
    }
    StandardInits.standardClose = standardClose;
    function defaultHtml(withJsf = true) {
        return init(StandardInits.HTML_DEFAULT, withJsf);
    }
    StandardInits.defaultHtml = defaultHtml;
    function defaultHtml_23(withJsf = true) {
        return init(StandardInits.HTML_DEFAULT.replace(/jakarta/gi, "javax"), withJsf, false);
    }
    StandardInits.defaultHtml_23 = defaultHtml_23;
    function defaultMyFaces(withJsf = true) {
        return init(HTML_FORM_DEFAULT, withJsf);
    }
    StandardInits.defaultMyFaces = defaultMyFaces;
    function defaultMyFacesNamespaces(withJsf = true) {
        return init(HTML_FORM_NAMESPACED, withJsf);
    }
    StandardInits.defaultMyFacesNamespaces = defaultMyFacesNamespaces;
    function initVirtualElement(withJsf = true) {
        return init(VIRTUAL_ELEMENT, withJsf);
    }
    StandardInits.initVirtualElement = initVirtualElement;
    function initCheckboxRadioForm(withJsf = true) {
        return init(CHECKBOX_RADIO_FORM, withJsf);
    }
    StandardInits.initCheckboxRadioForm = initCheckboxRadioForm;
    function defaultMyFaces23(withJsf = true) {
        return init(HTML_FORM_DEFAULT.replace(/jakarta/gi, "javax"), withJsf, false);
    }
    StandardInits.defaultMyFaces23 = defaultMyFaces23;
    function defaultFileForm(withJsf = true) {
        return init(HTML_FILE_FORM_DEFAULT, withJsf);
    }
    StandardInits.defaultFileForm = defaultFileForm;
    function tobagoFileForm(withJsf = true) {
        return init(HTML_TOBAGO_FILE_FORM, withJsf);
    }
    StandardInits.tobagoFileForm = tobagoFileForm;
    function defaultFileForm_23(withJsf = true) {
        return init(HTML_FILE_FORM_DEFAULT.replace(/jakarta/gi, "javax"), withJsf, false);
    }
    StandardInits.defaultFileForm_23 = defaultFileForm_23;
    function shadowDomMyFaces(withJsf = true) {
        return init(StandardInits.HTML_SHADOW, withJsf).then((close) => {
            let shadow = mona_dish_1.DomQuery.byId(window.document).byId("shadowDomArea").attachShadow();
            shadow.innerHtml = `
                <input type="button" id="input_3" name="input_3" value="input_3_val" ></input>
                <div id="shadowContent">before update</div>
            `;
            return close;
        });
    }
    StandardInits.shadowDomMyFaces = shadowDomMyFaces;
    function protocolPage(withJsf = true, IS_40 = true) {
        return init((IS_40) ? StandardInits.PROTOCOL_PAGE : StandardInits.PROTOCOL_PAGE.replace(/jakarta/gi, "javax"), withJsf, IS_40);
    }
    StandardInits.protocolPage = protocolPage;
    function errorChainPage(withJsf = true, IS_40 = true) {
        return init((IS_40) ? StandardInits.ERROR_CHAIN_PAGE : StandardInits.ERROR_CHAIN_PAGE.replace(/jakarta/gi, "javax"), withJsf, IS_40);
    }
    StandardInits.errorChainPage = errorChainPage;
    function prefixEmbeddedPage(withJsf = true, IS_40 = true) {
        return init((IS_40) ? HTML_FORM_PREFIXED_EMBEDDED : HTML_FORM_PREFIXED_EMBEDDED.replace(/jakarta/gi, "javax"), withJsf, IS_40);
    }
    StandardInits.prefixEmbeddedPage = prefixEmbeddedPage;
    function defaultSeparatorChar(separatorChar, withJsf = true, IS_40 = true) {
        let template = HTML_DEFAULT_SEPARATOR_CHAR(separatorChar, IS_40);
        return init(template, withJsf);
    }
    StandardInits.defaultSeparatorChar = defaultSeparatorChar;
    /**
     * we need to manually apply the jsf top the global namespace
     *
     * the reason simply is that
     * we use our typescript dependency system on the tests
     * which forfeits the global namespace.
     *
     * The global namespace is used after the build automatically
     * by using the window build
     *
     * @param data
     * @param Implementation
     */
    let applyJsfToGlobals = function (data, Implementation, PushImpl) {
        var _a, _b;
        global.faces = data.faces;
        global.myfaces = data.myfaces;
        global.window.faces = data.faces;
        global.window.myfaces = data.myfaces;
        global.Implementation = Implementation.Implementation;
        global.PushImpl = PushImpl.PushImpl;
        //bypass a bug on windows jsdom, domparser not an auto global but on window only
        global.DOMParser = (_a = global === null || global === void 0 ? void 0 : global.DOMParser) !== null && _a !== void 0 ? _a : window.DOMParser;
        global.document = (_b = global === null || global === void 0 ? void 0 : global.document) !== null && _b !== void 0 ? _b : window.document;
    };
    let applyJsfToGlobals23 = function (data, Implementation, PushImpl) {
        var _a, _b;
        global.jsf = data.jsf;
        global.myfaces = data.myfaces;
        global.window.jsf = data.jsf;
        global.window.myfaces = data.myfaces;
        global.Implementation = Implementation.Implementation;
        global.window.Implementation = Implementation.Implementation;
        global.PushImpl = PushImpl.PushImpl;
        //bypass a bug on windows jsdom, domparser not an auto global but on window only
        global.DOMParser = (_a = global === null || global === void 0 ? void 0 : global.DOMParser) !== null && _a !== void 0 ? _a : window.DOMParser;
        global.document = (_b = global === null || global === void 0 ? void 0 : global.document) !== null && _b !== void 0 ? _b : window.document;
    };
    /**
     * init the jsdom global
     * @param clean
     * @param template
     */
    let initJSDOM = function (template) {
        return __awaiter(this, void 0, void 0, function* () {
            // @ts-ignore
            return Promise.resolve().then(() => __importStar(require('jsdom-global'))).then((domIt) => {
                var _a, _b;
                let params = {
                    contentType: "text/html",
                    runScripts: "dangerously",
                    resources: "usable",
                    url: `file://${__dirname}/index.html`
                };
                //we have two different apis depending whether we allow module interop with sinon or not
                return (_b = ((_a = domIt === null || domIt === void 0 ? void 0 : domIt.default) !== null && _a !== void 0 ? _a : domIt)) === null || _b === void 0 ? void 0 : _b(template, params);
            });
        });
    };
    /**
     * init the jsf subsystem
     */
    let initJSF = function (IS_40 = true) {
        return __awaiter(this, void 0, void 0, function* () {
            // @ts-ignore
            const facesImport = IS_40 ? Promise.resolve().then(() => __importStar(require("../../../../api/faces"))) : Promise.resolve().then(() => __importStar(require("../../../../api/jsf")));
            return facesImport.then((data) => {
                let Implementation = require("../../../../impl/AjaxImpl");
                let PushImpl = require("../../../../impl/PushImpl");
                IS_40 ? applyJsfToGlobals(data, Implementation, PushImpl) : applyJsfToGlobals23(data, Implementation, PushImpl);
            }).catch(err => {
                console.error(err);
            });
        });
    };
    /**
     * lets clean up some old data which might interfere
     */
    let resetGlobals = function () {
        var _a, _b;
        (_a = global === null || global === void 0 ? void 0 : global.Implementation) === null || _a === void 0 ? void 0 : _a.reset();
        (_b = global === null || global === void 0 ? void 0 : global.PushImpl) === null || _b === void 0 ? void 0 : _b.reset();
        (global.faces) ? delete global.faces : null;
        (global.jsf) ? delete global.jsf : null;
        delete global.myfaces;
        (global.Implementation) ? delete global.Implementation : null;
        delete global.PushImpl;
    };
    /**
     * entry point which initializes the test system with a template and with or without jsf
     *
     * @param template
     * @param withJsf
     */
    function init(template, withJsf = true, IS_JSF_40 = true) {
        return __awaiter(this, void 0, void 0, function* () {
            //let dom2 = new JSDOM(template)
            //return initMyFacesFromDom(dom2);
            let clean = null;
            //we use jsdom global to fulfill our requirements
            //we need to import dynamically and use awaits
            if (withJsf) {
                resetGlobals();
                // @ts-ignore
                yield initJSDOM(template).then(data => clean = data);
                yield initJSF(IS_JSF_40);
            }
            else {
                // @ts-ignore
                yield Promise.resolve().then(() => __importStar(require('jsdom-global'))).then((domIt) => {
                    var _a, _b;
                    clean = (_b = ((_a = domIt === null || domIt === void 0 ? void 0 : domIt.default) !== null && _a !== void 0 ? _a : domIt)) === null || _b === void 0 ? void 0 : _b(template);
                });
            }
            //the async is returning a promise on the caller level
            //which gets the return value on once done
            return clean;
        });
    }
})(StandardInits || (exports.StandardInits = StandardInits = {}));
//# sourceMappingURL=StandardInits.js.map