/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.Parameter;
import javax.persistence.TemporalType;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.ParameterExpression;
import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.OrderedMap;
import org.apache.openjpa.meta.QueryMetaData;
import org.apache.openjpa.persistence.EntityManagerImpl;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.OpenJPAQuerySPI;
import org.apache.openjpa.persistence.ParameterImpl;
import org.apache.openjpa.persistence.criteria.BindableParameter;

public abstract class AbstractQuery<X>
implements OpenJPAQuerySPI<X> {
    private static final Localizer _loc = Localizer.forPackage(AbstractQuery.class);
    protected boolean _relaxBindParameterTypeChecking;
    protected boolean _convertPositionalParams;
    protected final QueryMetaData _qmd;
    protected transient EntityManagerImpl _em;
    protected Map<Parameter<?>, Object> _boundParams;
    protected Map<Object, Parameter<?>> _declaredParams;

    public AbstractQuery(QueryMetaData qmd, EntityManagerImpl em) {
        this._qmd = qmd;
        this._em = em;
        this._boundParams = new HashMap();
    }

    Map<Object, Object> getParameterValues() {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        if (this._boundParams == null) {
            return result;
        }
        for (Map.Entry<Object, Parameter<?>> entry : this.getDeclaredParameters().entrySet()) {
            Object paramKey = entry.getKey();
            Parameter<?> param = entry.getValue();
            result.put(paramKey, this._boundParams.get(param));
        }
        return result;
    }

    public boolean isProcedure() {
        return "openjpa.StoredProcedure.SQL".equals(this.getLanguage());
    }

    public boolean isNative() {
        return "openjpa.SQL".equals(this.getLanguage());
    }

    protected abstract void assertOpen();

    protected abstract void lock();

    protected abstract void unlock();

    protected abstract OrderedMap<Object, Class<?>> getParamTypes();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OpenJPAQuery<X> setParameter(int pos, Object value) {
        if (this._convertPositionalParams) {
            return this.setParameter("_" + pos, value);
        }
        this.assertOpen();
        this._em.assertNotCloseInvoked();
        this.lock();
        try {
            Parameter<?> param;
            if (pos < 1) {
                throw new IllegalArgumentException(_loc.get("illegal-index", pos).getMessage());
            }
            if (this.isNative() || this.isProcedure()) {
                param = new ParameterImpl<Object>(pos, Object.class);
                this.declareParameter(pos, param);
            } else {
                param = this.getParameter(pos);
            }
            this.bindValue(param, value);
            AbstractQuery abstractQuery = this;
            return abstractQuery;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public OpenJPAQuery<X> setParameter(int position, Calendar value, TemporalType t) {
        return this.setParameter(position, this.convertTemporalType(value, t));
    }

    @Override
    public OpenJPAQuery<X> setParameter(int position, Date value, TemporalType type) {
        return this.setParameter(position, this.convertTemporalType(value, type));
    }

    Object convertTemporalType(Date value, TemporalType type) {
        switch (type) {
            case DATE: {
                return value;
            }
            case TIME: {
                return new Time(value.getTime());
            }
            case TIMESTAMP: {
                return new Timestamp(value.getTime());
            }
        }
        return null;
    }

    Object convertTemporalType(Calendar value, TemporalType type) {
        return this.convertTemporalType(value.getTime(), type);
    }

    @Override
    public boolean hasPositionalParameters() {
        return !this.getDeclaredParameterKeys(Integer.class).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] getPositionalParameters() {
        this.lock();
        try {
            Set<Integer> positionalKeys = this.getDeclaredParameterKeys(Integer.class);
            Object[] result = new Object[this.calculateMaxKey(positionalKeys)];
            for (Integer pos : positionalKeys) {
                Parameter<?> param = this.getParameter(pos);
                result[pos.intValue() - 1] = this.isBound(param) ? this.getParameterValue(pos) : null;
            }
            Object[] objectArray = result;
            return objectArray;
        }
        finally {
            this.unlock();
        }
    }

    int calculateMaxKey(Set<Integer> p) {
        if (p == null) {
            return 0;
        }
        int max = Integer.MIN_VALUE;
        for (Integer i : p) {
            max = Math.max(max, i);
        }
        return max;
    }

    @Override
    public OpenJPAQuery<X> setParameters(Object ... params) {
        this.assertOpen();
        this._em.assertNotCloseInvoked();
        this.lock();
        try {
            this.clearBinding();
            for (int i = 0; params != null && i < params.length; ++i) {
                this.setParameter(i + 1, params[i]);
            }
            AbstractQuery abstractQuery = this;
            return abstractQuery;
        }
        finally {
            this.unlock();
        }
    }

    void clearBinding() {
        if (this._boundParams != null) {
            this._boundParams.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getNamedParameters() {
        this.lock();
        try {
            HashMap<String, Object> result = new HashMap<String, Object>();
            Set<String> namedKeys = this.getDeclaredParameterKeys(String.class);
            Object object = namedKeys.iterator();
            while (object.hasNext()) {
                String name;
                Parameter<?> param = this.getParameter(name = object.next());
                result.put(name, this.isBound(param) ? this.getParameterValue(name) : null);
            }
            object = result;
            return object;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OpenJPAQuery<X> setParameters(Map params) {
        this.assertOpen();
        this._em.assertNotCloseInvoked();
        this.lock();
        try {
            this.clearBinding();
            if (params != null) {
                for (Map.Entry entry : params.entrySet()) {
                    this.setParameter((String)entry.getKey(), entry.getValue());
                }
            }
            AbstractQuery abstractQuery = this;
            return abstractQuery;
        }
        finally {
            this.unlock();
        }
    }

    public <T> Parameter<T> getParameter(String name, Class<T> type) {
        Parameter<?> param = this.getParameter(name);
        if (param.getParameterType().isAssignableFrom(type)) {
            throw new IllegalArgumentException(param + " does not match the requested type " + type);
        }
        return param;
    }

    public <T> Parameter<T> getParameter(int pos, Class<T> type) {
        if (this._convertPositionalParams) {
            return this.getParameter("_" + pos, type);
        }
        Parameter<?> param = this.getParameter(pos);
        if (param.getParameterType().isAssignableFrom(type)) {
            throw new IllegalArgumentException(param + " does not match the requested type " + type);
        }
        return param;
    }

    public <T> T getParameterValue(Parameter<T> p) {
        if (!this.isBound(p)) {
            throw new IllegalArgumentException(_loc.get("param-missing", p, this.getQueryString(), this.getBoundParameterKeys()).getMessage());
        }
        return (T)this._boundParams.get(p);
    }

    public Set<Parameter<?>> getParameters() {
        HashSet result = new HashSet(this.getDeclaredParameters().values());
        return result;
    }

    public <T> OpenJPAQuery<X> setParameter(Parameter<T> p, T arg1) {
        this.bindValue(p, arg1);
        if (BindableParameter.class.isInstance(p)) {
            ((BindableParameter)BindableParameter.class.cast(p)).setValue(arg1);
        }
        return this;
    }

    public OpenJPAQuery<X> setParameter(Parameter<Date> p, Date date, TemporalType type) {
        return this.setParameter((Parameter)p, (Object)((Date)this.convertTemporalType(date, type)));
    }

    public TypedQuery<X> setParameter(Parameter<Calendar> p, Calendar cal, TemporalType type) {
        return this.setParameter((Parameter)p, (Object)((Calendar)this.convertTemporalType(cal, type)));
    }

    public Parameter<?> getParameter(String name) {
        if (this.isNative()) {
            throw new IllegalStateException(_loc.get("param-named-non-native", name).getMessage());
        }
        Parameter<?> param = this.getDeclaredParameters().get(name);
        if (param == null) {
            Set<ParameterExpression> exps = this.getDeclaredParameterKeys(ParameterExpression.class);
            for (ParameterExpression e : exps) {
                if (!name.equals(e.getName())) continue;
                return e;
            }
            throw new IllegalArgumentException(_loc.get("param-missing-name", name, this.getQueryString(), this.getDeclaredParameterKeys()).getMessage());
        }
        return param;
    }

    public Parameter<?> getParameter(int pos) {
        if (this._convertPositionalParams) {
            return this.getParameter("_" + pos);
        }
        Parameter<?> param = this.getDeclaredParameters().get(pos);
        if (param == null) {
            throw new IllegalArgumentException(_loc.get("param-missing-pos", pos, this.getQueryString(), this.getDeclaredParameterKeys()).getMessage());
        }
        return param;
    }

    public Object getParameterValue(String name) {
        return this._boundParams.get(this.getParameter(name));
    }

    public Object getParameterValue(int pos) {
        Parameter<?> param = this.getParameter(pos);
        this.assertBound(param);
        return this._boundParams.get(param);
    }

    public Set<?> getBoundParameterKeys() {
        if (this._boundParams == null) {
            return Collections.EMPTY_SET;
        }
        this.getDeclaredParameters();
        HashSet<Object> result = new HashSet<Object>();
        for (Map.Entry<Object, Parameter<?>> entry : this._declaredParams.entrySet()) {
            if (!this.isBound(entry.getValue())) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    public Set<?> getDeclaredParameterKeys() {
        return this.getDeclaredParameters().keySet();
    }

    public <T> Set<T> getDeclaredParameterKeys(Class<T> keyType) {
        HashSet result = new HashSet();
        for (Object key : this.getDeclaredParameterKeys()) {
            if (!keyType.isInstance(key)) continue;
            result.add(key);
        }
        return result;
    }

    public Map<Object, Parameter<?>> getDeclaredParameters() {
        if (this._declaredParams == null) {
            this._declaredParams = new HashMap();
            OrderedMap<Object, Class<?>> paramTypes = null;
            if (this._qmd != null) {
                paramTypes = this._qmd.getParamTypes();
            }
            if (paramTypes == null) {
                paramTypes = this.getParamTypes();
                if (this._qmd != null) {
                    this._qmd.setParamTypes(paramTypes);
                }
            }
            for (Map.Entry<Object, Class<?>> entry : paramTypes.entrySet()) {
                ParameterImpl param;
                Object key = entry.getKey();
                Class<?> expectedValueType = entry.getValue();
                if (key instanceof Integer) {
                    param = new ParameterImpl((Integer)key, expectedValueType);
                } else if (key instanceof String) {
                    param = new ParameterImpl((String)key, expectedValueType);
                } else if (key instanceof Parameter) {
                    param = (ParameterImpl)key;
                } else {
                    throw new IllegalArgumentException("parameter identifier " + key + " unrecognized");
                }
                this.declareParameter(key, param);
            }
        }
        return this._declaredParams;
    }

    public void declareParameter(Object key, Parameter<?> param) {
        if (this._declaredParams == null) {
            this._declaredParams = new HashMap();
        }
        this._declaredParams.put(key, param);
    }

    public boolean isBound(Parameter<?> param) {
        return this._boundParams != null && this._boundParams.containsKey(param);
    }

    void assertBound(Parameter<?> param) {
        if (!this.isBound(param)) {
            throw new IllegalStateException(_loc.get("param-not-bound", param, this.getQueryString(), this.getBoundParameterKeys()).getMessage());
        }
    }

    void bindValue(Parameter<?> param, Object value) {
        Object bindVal = this.assertValueAssignable(param, value);
        this._boundParams.put(param, bindVal);
    }

    @Override
    public OpenJPAQuery<X> setParameter(String name, Calendar value, TemporalType type) {
        return this.setParameter(name, this.convertTemporalType(value, type));
    }

    @Override
    public OpenJPAQuery<X> setParameter(String name, Date value, TemporalType type) {
        return this.setParameter(name, this.convertTemporalType(value, type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OpenJPAQuery<X> setParameter(String name, Object value) {
        this.assertOpen();
        this._em.assertNotCloseInvoked();
        this.lock();
        try {
            if (this.isNative()) {
                throw new IllegalArgumentException(_loc.get("no-named-params", name, this.getQueryString()).toString());
            }
            this.bindValue(this.getParameter(name), value);
            AbstractQuery abstractQuery = this;
            return abstractQuery;
        }
        finally {
            this.unlock();
        }
    }

    Object assertValueAssignable(Parameter<?> param, Object v) {
        Class expectedType = param.getParameterType();
        if (v == null) {
            if (expectedType.isPrimitive()) {
                throw new IllegalArgumentException(_loc.get("param-null-primitive", param).getMessage());
            }
            return v;
        }
        if (this.getRelaxBindParameterTypeChecking()) {
            try {
                return Filters.convert(v, expectedType);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(_loc.get("param-type-mismatch", new Object[]{param, this.getQueryString(), v, v.getClass().getName(), expectedType.getName()}).getMessage());
            }
        }
        if (!Filters.canConvert(v.getClass(), expectedType, true)) {
            throw new IllegalArgumentException(_loc.get("param-type-mismatch", new Object[]{param, this.getQueryString(), v, v.getClass().getName(), expectedType.getName()}).getMessage());
        }
        return v;
    }

    @Override
    public boolean getRelaxBindParameterTypeChecking() {
        return this._relaxBindParameterTypeChecking;
    }

    @Override
    public void setRelaxBindParameterTypeChecking(Object value) {
        if (value != null) {
            if (value instanceof String) {
                this._relaxBindParameterTypeChecking = "true".equalsIgnoreCase(value.toString());
            } else if (value instanceof Boolean) {
                this._relaxBindParameterTypeChecking = (Boolean)value;
            }
        }
    }
}

