/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.definition.schema;

import io.swagger.models.Swagger;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.SchemaMeta;
import org.apache.servicecomb.core.definition.schema.AbstractSchemaFactory;
import org.apache.servicecomb.core.definition.schema.SchemaContext;
import org.apache.servicecomb.serviceregistry.api.registry.StaticMicroservice;
import org.apache.servicecomb.swagger.SwaggerUtils;
import org.apache.servicecomb.swagger.generator.core.SwaggerGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class StaticSchemaFactory
extends AbstractSchemaFactory<SchemaContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StaticSchemaFactory.class);

    public void loadSchema(MicroserviceMeta microserviceMeta, StaticMicroservice microservice) {
        SchemaContext context = new SchemaContext();
        context.setMicroserviceMeta(microserviceMeta);
        context.setSchemaId(microserviceMeta.getShortName());
        context.setProviderClass(microservice.getSchemaIntfCls());
        this.getOrCreateSchema(context);
    }

    @Override
    protected SchemaMeta createSchema(SchemaContext context) {
        SwaggerGenerator generator = this.generateSwagger(context);
        Swagger swagger = generator.getSwagger();
        String swaggerContent = SwaggerUtils.swaggerToString((Swagger)swagger);
        LOGGER.info("generate swagger for {}/{}/{}, swagger: {}", new Object[]{context.getMicroserviceMeta().getAppId(), context.getMicroserviceName(), context.getSchemaId(), swaggerContent});
        return this.schemaLoader.registerSchema(context.getMicroserviceMeta(), context.getSchemaId(), swagger);
    }
}

