/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Function;
import com.google.common.cache.Cache;
import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.annotations.MonitorTags;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.AnnotatedNumberMonitor;
import com.netflix.servo.monitor.AnnotatedStringMonitor;
import com.netflix.servo.monitor.BasicCompositeMonitor;
import com.netflix.servo.monitor.BasicCounter;
import com.netflix.servo.monitor.BasicTimer;
import com.netflix.servo.monitor.CompositeMonitor;
import com.netflix.servo.monitor.CompositeMonitorWrapper;
import com.netflix.servo.monitor.ContextualCounter;
import com.netflix.servo.monitor.ContextualTimer;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.MonitorWrapper;
import com.netflix.servo.monitor.MonitoredCache;
import com.netflix.servo.monitor.MonitoredThreadPool;
import com.netflix.servo.monitor.Timer;
import com.netflix.servo.tag.SortedTagList;
import com.netflix.servo.tag.TagList;
import com.netflix.servo.tag.TaggingContext;
import com.netflix.servo.util.Reflection;
import com.netflix.servo.util.Throwables;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class Monitors {
    private static final String DEFAULT_ID = "default";
    private static final CounterFactory COUNTER_FUNCTION = new CounterFactory();

    private Monitors() {
    }

    public static Timer newTimer(String name) {
        return Monitors.newTimer(name, TimeUnit.MILLISECONDS);
    }

    public static Timer newTimer(String name, TaggingContext context) {
        return Monitors.newTimer(name, TimeUnit.MILLISECONDS, context);
    }

    public static Timer newTimer(String name, TimeUnit unit) {
        return new BasicTimer(MonitorConfig.builder(name).build(), unit);
    }

    public static Timer newTimer(String name, TimeUnit unit, TaggingContext context) {
        MonitorConfig config = MonitorConfig.builder(name).build();
        return new ContextualTimer(config, context, new TimerFactory(unit));
    }

    public static Counter newCounter(String name) {
        return new BasicCounter(MonitorConfig.builder(name).build());
    }

    public static Counter newCounter(String name, TaggingContext context) {
        MonitorConfig config = MonitorConfig.builder(name).build();
        return new ContextualCounter(config, context, COUNTER_FUNCTION);
    }

    public static CompositeMonitor<?> newObjectMonitor(Object obj) {
        return Monitors.newObjectMonitor(null, obj);
    }

    public static CompositeMonitor<?> newObjectMonitor(String id, Object obj) {
        TagList tags = Monitors.getMonitorTags(obj);
        ArrayList monitors = new ArrayList();
        Monitors.addMonitors(monitors, id, tags, obj);
        Class<?> c = obj.getClass();
        String objectId = id == null ? DEFAULT_ID : id;
        return new BasicCompositeMonitor(Monitors.newObjectConfig(c, objectId, tags), monitors);
    }

    public static CompositeMonitor<?> newThreadPoolMonitor(String id, ThreadPoolExecutor pool) {
        return Monitors.newObjectMonitor(id, new MonitoredThreadPool(pool));
    }

    public static CompositeMonitor<?> newCacheMonitor(String id, Cache<?, ?> cache) {
        return Monitors.newObjectMonitor(id, new MonitoredCache(cache));
    }

    public static void registerObject(Object obj) {
        Monitors.registerObject(null, obj);
    }

    public static void unregisterObject(Object obj) {
        Monitors.unregisterObject(null, obj);
    }

    public static void unregisterObject(String id, Object obj) {
        DefaultMonitorRegistry.getInstance().unregister(Monitors.newObjectMonitor(id, obj));
    }

    public static void registerObject(String id, Object obj) {
        DefaultMonitorRegistry.getInstance().register(Monitors.newObjectMonitor(id, obj));
    }

    public static boolean isObjectRegistered(Object obj) {
        return Monitors.isObjectRegistered(null, obj);
    }

    public static boolean isObjectRegistered(String id, Object obj) {
        return DefaultMonitorRegistry.getInstance().isRegistered(Monitors.newObjectMonitor(id, obj));
    }

    static <T> Monitor<T> wrap(TagList tags, Monitor<T> monitor) {
        AbstractMonitor m = monitor instanceof CompositeMonitor ? new CompositeMonitorWrapper(tags, (CompositeMonitor)monitor) : MonitorWrapper.create(tags, monitor);
        return m;
    }

    static void addMonitors(List<Monitor<?>> monitors, String id, TagList tags, Object obj) {
        Monitors.addMonitorFields(monitors, id, tags, obj);
        Monitors.addAnnotatedFields(monitors, id, tags, obj);
    }

    static void addMonitorFields(List<Monitor<?>> monitors, String id, TagList tags, Object obj) {
        try {
            SortedTagList.Builder builder = SortedTagList.builder();
            builder.withTag("class", Monitors.className(obj.getClass()));
            if (tags != null) {
                builder.withTags(tags);
            }
            if (id != null) {
                builder.withTag("id", id);
            }
            SortedTagList classTags = builder.build();
            Set<Field> fields = Reflection.getAllFields(obj.getClass());
            for (Field field : fields) {
                if (!Monitors.isMonitorType(field.getType())) continue;
                field.setAccessible(true);
                Monitor m = (Monitor)field.get(obj);
                if (m == null) {
                    throw new NullPointerException("field " + field.getName() + " in class " + field.getDeclaringClass().getName() + " is null, all monitor fields must be initialized before registering");
                }
                monitors.add(Monitors.wrap(classTags, m));
            }
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    static void addAnnotatedFields(List<Monitor<?>> monitors, String id, TagList tags, Object obj) {
        Class<com.netflix.servo.annotations.Monitor> annoClass = com.netflix.servo.annotations.Monitor.class;
        try {
            Set<Field> fields = Reflection.getFieldsAnnotatedBy(obj.getClass(), annoClass);
            for (Field field : fields) {
                com.netflix.servo.annotations.Monitor anno = field.getAnnotation(annoClass);
                if (anno == null) continue;
                MonitorConfig config = Monitors.newConfig(obj.getClass(), field.getName(), id, anno, tags);
                if (anno.type() == DataSourceType.INFORMATIONAL) {
                    monitors.add(new AnnotatedStringMonitor(config, obj, field));
                    continue;
                }
                Monitors.checkType(anno, field.getType(), field.getDeclaringClass());
                monitors.add(new AnnotatedNumberMonitor(config, obj, field));
            }
            Set<Method> methods = Reflection.getMethodsAnnotatedBy(obj.getClass(), annoClass);
            for (Method method : methods) {
                com.netflix.servo.annotations.Monitor anno = method.getAnnotation(annoClass);
                if (anno == null) continue;
                MonitorConfig config = Monitors.newConfig(obj.getClass(), method.getName(), id, anno, tags);
                if (anno.type() == DataSourceType.INFORMATIONAL) {
                    monitors.add(new AnnotatedStringMonitor(config, obj, method));
                    continue;
                }
                Monitors.checkType(anno, method.getReturnType(), method.getDeclaringClass());
                monitors.add(new AnnotatedNumberMonitor(config, obj, method));
            }
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    private static TagList getMonitorTags(Object obj) {
        try {
            Set<Field> fields = Reflection.getFieldsAnnotatedBy(obj.getClass(), MonitorTags.class);
            Iterator<Field> iterator = fields.iterator();
            if (iterator.hasNext()) {
                Field field = iterator.next();
                field.setAccessible(true);
                return (TagList)field.get(obj);
            }
            Set<Method> methods = Reflection.getMethodsAnnotatedBy(obj.getClass(), MonitorTags.class);
            Iterator<Method> iterator2 = methods.iterator();
            if (iterator2.hasNext()) {
                Method method = iterator2.next();
                method.setAccessible(true);
                return (TagList)method.invoke(obj, new Object[0]);
            }
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
        return null;
    }

    private static void checkType(com.netflix.servo.annotations.Monitor anno, Class<?> type, Class<?> container) {
        if (!Monitors.isNumericType(type)) {
            String msg = "annotation of type " + anno.type().name() + " can only be used with numeric values, " + anno.name() + " in class " + container.getName() + " is applied to a field or method of type " + type.getName();
            throw new IllegalArgumentException(msg);
        }
    }

    private static boolean isNumericType(Class<?> c) {
        return Number.class.isAssignableFrom(c) || Double.TYPE == c || Float.TYPE == c || Long.TYPE == c || Integer.TYPE == c || Short.TYPE == c || Byte.TYPE == c;
    }

    private static boolean isMonitorType(Class<?> c) {
        return Monitor.class.isAssignableFrom(c);
    }

    private static MonitorConfig newObjectConfig(Class<?> c, String id, TagList tags) {
        MonitorConfig.Builder builder = MonitorConfig.builder(id);
        String className = Monitors.className(c);
        if (!className.isEmpty()) {
            builder.withTag("class", className);
        }
        if (tags != null) {
            builder.withTags(tags);
        }
        return builder.build();
    }

    private static String className(Class c) {
        String simpleName = c.getSimpleName();
        return simpleName.isEmpty() ? Monitors.className(c.getEnclosingClass()) : simpleName;
    }

    private static MonitorConfig newConfig(Class<?> c, String defaultName, String id, com.netflix.servo.annotations.Monitor anno, TagList tags) {
        String name = anno.name();
        if (name.isEmpty()) {
            name = defaultName;
        }
        MonitorConfig.Builder builder = MonitorConfig.builder(name);
        builder.withTag("class", Monitors.className(c));
        builder.withTag(anno.type());
        builder.withTag(anno.level());
        if (tags != null) {
            builder.withTags(tags);
        }
        if (id != null) {
            builder.withTag("id", id);
        }
        return builder.build();
    }

    private static class CounterFactory
    implements Function<MonitorConfig, Counter> {
        private CounterFactory() {
        }

        public Counter apply(MonitorConfig config) {
            return new BasicCounter(config);
        }
    }

    private static class TimerFactory
    implements Function<MonitorConfig, Timer> {
        private final TimeUnit unit;

        public TimerFactory(TimeUnit unit) {
            this.unit = unit;
        }

        public Timer apply(MonitorConfig config) {
            return new BasicTimer(config, this.unit);
        }
    }
}

