/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.sse;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.reactivex.netty.protocol.http.client.ClientRequestResponseConverter;
import io.reactivex.netty.protocol.http.sse.ServerSentEventDecoder;

@ChannelHandler.Sharable
public class SseChannelHandler
extends SimpleChannelInboundHandler<Object> {
    public static final String NAME = "sse-inbound-handler";
    public static final String SSE_DECODER_HANDLER_NAME = "rx-sse-decoder";
    public static final String SSE_DECODER_POST_INBOUND_HANDLER = "rx-sse-decoder-post-inbound";

    public SseChannelHandler() {
        super(false);
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpResponse) {
            ctx.channel().attr(ClientRequestResponseConverter.DISCARD_CONNECTION).set((Object)true);
            ChannelPipeline pipeline = ctx.channel().pipeline();
            if (!HttpHeaders.isTransferEncodingChunked((HttpMessage)((HttpResponse)msg))) {
                pipeline.addFirst(SSE_DECODER_HANDLER_NAME, (ChannelHandler)new ServerSentEventDecoder());
                pipeline.addAfter(NAME, SSE_DECODER_POST_INBOUND_HANDLER, (ChannelHandler)new ServerSentEventDecoder());
            } else {
                pipeline.addAfter(NAME, SSE_DECODER_HANDLER_NAME, (ChannelHandler)new ServerSentEventDecoder());
            }
            ctx.fireChannelRead(msg);
        } else if (msg instanceof LastHttpContent) {
            LastHttpContent lastHttpContent = (LastHttpContent)msg;
            lastHttpContent.content().retain();
            if (lastHttpContent.content().isReadable()) {
                ctx.fireChannelRead((Object)lastHttpContent.content());
            }
            ctx.fireChannelRead(msg);
        } else if (msg instanceof HttpContent) {
            ctx.fireChannelRead((Object)((HttpContent)msg).content());
        } else {
            ctx.fireChannelRead(msg);
        }
    }
}

