/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.crypto.keygen;

import org.springframework.security.crypto.codec.Base64;
import org.springframework.security.crypto.keygen.BytesKeyGenerator;
import org.springframework.security.crypto.keygen.KeyGenerators;
import org.springframework.security.crypto.keygen.StringKeyGenerator;

public class Base64StringKeyGenerator
implements StringKeyGenerator {
    private static final int DEFAULT_KEY_LENGTH = 32;
    private final BytesKeyGenerator keyGenerator;

    public Base64StringKeyGenerator() {
        this(32);
    }

    public Base64StringKeyGenerator(int keyLength) {
        if (keyLength < 32) {
            throw new IllegalArgumentException("keyLength must be greater than or equal to32");
        }
        this.keyGenerator = KeyGenerators.secureRandom(keyLength);
    }

    @Override
    public String generateKey() {
        byte[] key = this.keyGenerator.generateKey();
        byte[] base64EncodedKey = Base64.encode(key);
        return new String(base64EncodedKey);
    }
}

