/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.vertx.accesslog.element.impl;

import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.web.RoutingContext;
import org.apache.servicecomb.transport.rest.vertx.accesslog.AccessLogParam;
import org.apache.servicecomb.transport.rest.vertx.accesslog.element.AccessLogItem;
import org.springframework.util.StringUtils;

public class LocalHostItem
implements AccessLogItem<RoutingContext> {
    public static final String EMPTY_RESULT = "-";

    @Override
    public String getFormattedItem(AccessLogParam<RoutingContext> accessLogParam) {
        return accessLogParam.getLocalAddress();
    }

    public static String getLocalAddress(AccessLogParam<RoutingContext> accessLogParam) {
        HttpServerRequest request = accessLogParam.getContextData().request();
        if (null == request) {
            return EMPTY_RESULT;
        }
        SocketAddress localAddress = request.localAddress();
        if (null == localAddress) {
            return EMPTY_RESULT;
        }
        String localHost = localAddress.host();
        if (StringUtils.isEmpty((Object)localHost)) {
            return EMPTY_RESULT;
        }
        return localHost;
    }
}

