/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.locator;

import jakarta.ws.rs.core.Response;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.common.rest.definition.RestOperationMeta;
import org.apache.servicecomb.common.rest.locator.MicroservicePaths;
import org.apache.servicecomb.common.rest.locator.OperationGroup;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationLocator {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationLocator.class);
    private static final String SLASH = "/";
    protected RestOperationMeta operation;
    protected Map<String, String> pathVarMap = new HashMap<String, String>();
    protected boolean resourceFound = false;

    public RestOperationMeta getOperation() {
        return this.operation;
    }

    public Map<String, String> getPathVarMap() {
        return this.pathVarMap;
    }

    public void locate(String microserviceName, String path, String httpMethod, MicroservicePaths microservicePaths) {
        this.operation = this.locateStaticPathOperation(path, httpMethod, microservicePaths.getStaticPathOperationMap());
        if (this.operation != null) {
            return;
        }
        this.operation = this.locateDynamicPathOperation(path, microservicePaths.getDynamicPathOperationList(), httpMethod);
        if (this.operation != null) {
            return;
        }
        Response.Status status = Response.Status.NOT_FOUND;
        if (this.resourceFound) {
            status = Response.Status.METHOD_NOT_ALLOWED;
        }
        LOGGER.error("locate path failed, status:{}, http method:{}, path:{}, microserviceName:{}", new Object[]{status, httpMethod, path, microserviceName});
        throw new InvocationException((Response.StatusType)status, status.getReasonPhrase());
    }

    protected RestOperationMeta locateStaticPathOperation(String path, String httpMethod, Map<String, OperationGroup> staticPathOperations) {
        OperationGroup group = staticPathOperations.get(path);
        if (group == null) {
            return null;
        }
        this.resourceFound = true;
        return (RestOperationMeta)group.findValue(httpMethod);
    }

    protected RestOperationMeta locateDynamicPathOperation(String path, Collection<RestOperationMeta> resourceList, String httpMethod) {
        for (RestOperationMeta resource : resourceList) {
            String remainPath = resource.getAbsolutePathRegExp().match(path, this.pathVarMap);
            if (!"".equals(remainPath)) continue;
            this.resourceFound = true;
            if (!this.checkHttpMethod(resource, httpMethod)) continue;
            return resource;
        }
        return null;
    }

    protected boolean checkHttpMethod(RestOperationMeta operation, String httpMethod) {
        return operation.getHttpMethod().equals(httpMethod);
    }

    static String getStandardPath(String path) {
        if (((String)path).length() > 0 && !((String)path).endsWith(SLASH)) {
            path = (String)path + SLASH;
        }
        return path;
    }
}

