/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.discovery;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.foundation.common.cache.VersionedCache;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.foundation.common.exceptions.ServiceCombException;
import org.apache.servicecomb.registry.DiscoveryManager;
import org.apache.servicecomb.registry.discovery.DiscoveryContext;
import org.apache.servicecomb.registry.discovery.DiscoveryFilter;
import org.apache.servicecomb.registry.discovery.DiscoveryTreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DiscoveryTree {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiscoveryTree.class);
    private final Map<String, Map<String, DiscoveryTreeNode>> root = new ConcurrentHashMapEx();
    private final Object lock = new Object();
    private List<DiscoveryFilter> filters = Collections.emptyList();
    private final DiscoveryManager discoveryManager;

    public DiscoveryTree(DiscoveryManager discoveryManager) {
        this.discoveryManager = discoveryManager;
    }

    @Autowired
    public void setDiscoveryFilters(List<DiscoveryFilter> filters) {
        this.filters = filters;
        this.log();
    }

    private void log() {
        StringBuilder sb = new StringBuilder();
        sb.append("DiscoveryFilters(name, enabled, order, group):");
        for (DiscoveryFilter filter : this.filters) {
            sb.append("(").append(filter.getClass().getName()).append(",").append(filter.enabled()).append(",").append(filter.getOrder()).append(",").append(filter.isGroupingFilter()).append(")");
        }
        LOGGER.info(sb.toString());
    }

    boolean isMatch(VersionedCache existing, VersionedCache inputCache) {
        return existing != null && existing.isSameVersion(inputCache);
    }

    boolean isExpired(VersionedCache existing, VersionedCache inputCache) {
        return existing == null || existing.isExpired(inputCache);
    }

    public DiscoveryTreeNode discovery(DiscoveryContext context, String appId, String microserviceName) {
        VersionedCache instanceVersionedCache = this.discoveryManager.getOrCreateVersionedCache(appId, microserviceName);
        return this.discovery(appId, microserviceName, context, instanceVersionedCache);
    }

    DiscoveryTreeNode discovery(String appId, String microserviceName, DiscoveryContext context, VersionedCache inputCache) {
        DiscoveryTreeNode tmpRoot = this.getOrCreateRoot(appId, microserviceName, inputCache);
        DiscoveryTreeNode parent = tmpRoot.children().computeIfAbsent(inputCache.name(), name -> new DiscoveryTreeNode().fromCache(inputCache));
        return this.doDiscovery(context, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DiscoveryTreeNode getOrCreateRoot(String appId, String microserviceName, VersionedCache inputCache) {
        DiscoveryTreeNode tmpRoot = (DiscoveryTreeNode)((Object)this.root.computeIfAbsent(appId, k -> new ConcurrentHashMapEx()).get(microserviceName));
        if (this.isMatch(tmpRoot, inputCache)) {
            return tmpRoot;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.isExpired(tmpRoot, inputCache)) {
                tmpRoot = (DiscoveryTreeNode)new DiscoveryTreeNode().cacheVersion(inputCache.cacheVersion());
                this.root.get(appId).put(microserviceName, tmpRoot);
                return tmpRoot;
            }
            if (tmpRoot.isSameVersion(inputCache)) {
                return tmpRoot;
            }
        }
        tmpRoot = (DiscoveryTreeNode)new DiscoveryTreeNode().cacheVersion(inputCache.cacheVersion());
        this.root.get(appId).put(microserviceName, tmpRoot);
        return tmpRoot;
    }

    protected DiscoveryTreeNode doDiscovery(DiscoveryContext context, DiscoveryTreeNode parent) {
        int idx = 0;
        while (idx < this.filters.size()) {
            DiscoveryTreeNode rerunNode;
            DiscoveryFilter filter = this.filters.get(idx);
            if (!filter.enabled()) {
                ++idx;
                continue;
            }
            context.setCurrentNode(parent);
            DiscoveryTreeNode child = filter.discovery(context, parent);
            if (child == null) {
                throw new ServiceCombException(filter.getClass().getName() + " discovery return null.");
            }
            child.level(idx + 1);
            if (!filter.isGroupingFilter()) {
                child.name(parent.name());
            }
            if (child.isEmpty() && (rerunNode = context.popRerunFilter()) != null) {
                parent = rerunNode;
                idx = parent.level();
                continue;
            }
            parent = child;
            ++idx;
        }
        return parent;
    }
}

