/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.common.base;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.servicecomb.foundation.common.base.DynamicEnum;

public interface EnumUtils {
    public static <T> T readEnum(Field enumField) {
        try {
            return (T)enumField.get(null);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("failed to read enum, field=" + enumField, e);
        }
    }

    public static boolean isEnumField(Class<?> cls, Field field) {
        return Modifier.isStatic(field.getModifiers()) && cls.equals(field.getType());
    }

    public static Stream<Field> findEnumFields(Class<?> cls) {
        return Arrays.stream(cls.getFields()).filter(field -> EnumUtils.isEnumField(cls, field));
    }

    public static boolean isDynamicEnum(Type cls) {
        return cls instanceof DynamicEnum;
    }
}

