/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.ui.internal;

import org.apache.sling.ide.eclipse.core.ProjectUtil;
import org.apache.sling.ide.eclipse.core.internal.ProjectHelper;
import org.apache.sling.ide.eclipse.ui.internal.SlingLaunchpadCombo;
import org.apache.sling.ide.eclipse.ui.propertyPages.SlingProjectPropertyPage;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionValidator;
import org.eclipse.ui.dialogs.WizardDataTransferPage;
import org.eclipse.wst.server.core.IServer;

public class ImportWizardPage
extends WizardDataTransferPage {
    private SlingLaunchpadCombo repositoryCombo;
    private Label importLabel;
    private Button containerBrowseButton;
    private IProject project;
    private Text containerNameField;
    private Label adjustJcrRootText;
    private IFolder importRoot;
    private Composite adjustComposite;
    private boolean hasValidFilter;

    public ImportWizardPage(String pageName, IStructuredSelection selection) {
        super(pageName);
        this.setTitle(pageName);
        this.setDescription("Import content from a Repository into the workspace");
        Object selectedResource = selection.getFirstElement();
        if (selectedResource instanceof IProject) {
            this.importRoot = ProjectUtil.getSyncDirectory((IProject)((IProject)selectedResource));
        } else if (selectedResource instanceof IFile) {
            this.importRoot = (IFolder)((IFile)selectedResource).getParent();
        } else if (selectedResource instanceof IFolder) {
            this.importRoot = (IFolder)selectedResource;
        }
        if (this.importRoot != null) {
            this.project = this.importRoot.getProject();
        }
        this.hasValidFilter = false;
    }

    public IResource getResource() {
        return this.importRoot;
    }

    protected boolean allowNewContainerName() {
        return false;
    }

    protected void createOptionsGroup(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(4, 4, true, false);
        container.setLayoutData((Object)gridData);
        this.importLabel = new Label(container, 0);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setSize(composite.computeSize(-1, -1));
        Composite container = new Composite(composite, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(4, 4, true, false);
        gridData.minimumWidth = 450;
        container.setLayoutData((Object)gridData);
        new Label(container, 0).setText("Repository: ");
        this.repositoryCombo = new SlingLaunchpadCombo(container, this.project);
        this.repositoryCombo.getWidget().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ImportWizardPage.this.determinePageCompletion();
                ImportWizardPage.this.updateWidgetEnablements();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ImportWizardPage.this.determinePageCompletion();
                ImportWizardPage.this.updateWidgetEnablements();
            }
        });
        this.repositoryCombo.refreshRepositoryList((IProgressMonitor)new NullProgressMonitor());
        Composite containerGroup = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        containerGroup.setLayout((Layout)layout);
        containerGroup.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        containerGroup.setFont(composite.getFont());
        Label resourcesLabel = new Label(containerGroup, 0);
        resourcesLabel.setText("Import into:");
        resourcesLabel.setFont(composite.getFont());
        this.containerNameField = new Text(containerGroup, 2052);
        this.containerNameField.addListener(24, (Listener)this);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.containerNameField.setLayoutData((Object)data);
        this.containerNameField.setFont(composite.getFont());
        this.containerBrowseButton = new Button(containerGroup, 8);
        this.containerBrowseButton.setText("Select location...");
        this.containerBrowseButton.setLayoutData((Object)new GridData(256));
        this.containerBrowseButton.addListener(13, (Listener)this);
        this.containerBrowseButton.setFont(composite.getFont());
        this.setButtonLayoutData(this.containerBrowseButton);
        if (this.importRoot != null) {
            this.containerNameField.setText(this.importRoot.getFullPath().toPortableString());
        } else {
            this.setErrorMessage("Select an import location");
        }
        this.adjustComposite = new Composite(composite, 0);
        this.adjustComposite.setLayout((Layout)new RowLayout());
        this.adjustJcrRootText = new Label(this.adjustComposite, 0);
        this.adjustJcrRootText.setFont(containerGroup.getFont());
        this.adjustJcrRootText();
        Link openPropertiesLink = new Link(this.adjustComposite, 0);
        openPropertiesLink.setText("(<a>change</a>)");
        openPropertiesLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SlingProjectPropertyPage.openPropertyDialog(ImportWizardPage.this.getShell(), ImportWizardPage.this.project);
                ImportWizardPage.this.updateWidgetEnablements();
            }
        });
        this.createOptionsGroup(composite);
        this.setControl((Control)composite);
        this.updateWidgetEnablements();
    }

    public void handleEvent(Event event) {
        if (event.widget == this.containerBrowseButton) {
            this.handleContainerBrowseButtonPressed();
        }
        this.updateWidgetEnablements();
        this.determinePageCompletion();
    }

    protected IPath queryForLocation(IProject initialSelection, String msg, String title) {
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getControl().getShell(), (IContainer)initialSelection, this.allowNewContainerName(), msg);
        if (title != null) {
            dialog.setTitle(title);
        }
        dialog.showClosedProjects(false);
        dialog.setValidator(new ISelectionValidator(){

            public String isValid(Object selection) {
                if (!(selection instanceof IPath)) {
                    return "Please select a valid import location";
                }
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IContainer container = (IContainer)root.findMember((IPath)selection);
                if (container instanceof IProject) {
                    return "Please select a folder inside the project";
                }
                if (!ProjectHelper.isContentProject((IProject)container.getProject())) {
                    return "Project " + container.getProject().getName() + " is not a content project";
                }
                if (!ProjectUtil.isInsideContentSyncRoot((IResource)container)) {
                    return "Please select a folder inside the content sync root folder " + String.valueOf(ProjectUtil.getSyncDirectory((IProject)container.getProject()).getProjectRelativePath());
                }
                return null;
            }
        });
        dialog.open();
        Object[] result = dialog.getResult();
        if (result != null && result.length == 1) {
            return (IPath)result[0];
        }
        return null;
    }

    private void handleContainerBrowseButtonPressed() {
        IPath result = this.queryForLocation(this.project, "Select a location to import data to", "Select location");
        if (result != null) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            this.importRoot = (IFolder)root.findMember(result);
            this.project = this.importRoot.getProject();
            this.containerNameField.setText(this.importRoot.getFullPath().toPortableString());
            this.repositoryCombo.setProject(this.project);
            this.repositoryCombo.refreshRepositoryList((IProgressMonitor)new NullProgressMonitor());
        }
    }

    public IServer getServer() {
        return this.repositoryCombo.getServer();
    }

    protected boolean validateOptionsGroup() {
        if (this.getControl() == null) {
            return true;
        }
        if (this.repositoryCombo == null || this.repositoryCombo.getServer() == null) {
            this.setErrorMessage("Please select a server instance");
            return false;
        }
        return true;
    }

    protected void updateWidgetEnablements() {
        super.updateWidgetEnablements();
        boolean pageComplete = this.determinePageCompletion();
        this.setPageComplete(pageComplete);
        if (pageComplete) {
            this.setMessage(null);
        }
        if (this.importLabel == null) {
            return;
        }
        this.adjustComposite.setVisible(this.project != null);
        this.adjustComposite.getParent().layout();
        if (this.importRoot != null) {
            IFile filterFile = this.getFilter();
            if (filterFile != null && filterFile.exists()) {
                this.importLabel.setText("Will apply import filter from /" + String.valueOf(filterFile.getProjectRelativePath()) + ".");
                if (!this.hasValidFilter) {
                    this.hasValidFilter = true;
                    this.setPageComplete(this.determinePageCompletion());
                }
            }
            this.importLabel.setVisible(true);
        }
        this.importLabel.getParent().layout();
    }

    private IFile getFilter() {
        IPath filterPath = ProjectUtil.findFilterPath((IProject)this.project);
        if (filterPath == null) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(filterPath);
    }

    protected boolean validateSourceGroup() {
        if (this.getControl() == null) {
            return true;
        }
        if (!this.hasValidFilter) {
            this.setErrorMessage("No valid filter found in this project!");
            return false;
        }
        if (this.adjustJcrRootText != null) {
            this.adjustJcrRootText();
            this.adjustJcrRootText.getParent().pack();
        }
        if (this.project == null || this.importRoot == null) {
            this.setErrorMessage("Please select a location to import to");
            return false;
        }
        String repositoryError = this.repositoryCombo.getErrorMessage(new SlingLaunchpadCombo.ValidationFlag[0]);
        if (repositoryError != null) {
            this.setErrorMessage(repositoryError);
            return false;
        }
        return true;
    }

    private void adjustJcrRootText() {
        if (this.project != null) {
            this.adjustJcrRootText.setText("Content sync root is: " + this.project.getName() + "/" + String.valueOf(ProjectUtil.getSyncDirectoryValue((IProject)this.project)));
        }
    }
}

