/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.models;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.caconfig.resource.ConfigurationResourceResolver;
import org.apache.sling.cms.CMSUtils;
import org.apache.sling.cms.PageTemplate;
import org.apache.sling.cms.PageTemplateManager;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={Resource.class}, adapters={PageTemplateManager.class})
public class PageTemplateManagerImpl
implements PageTemplateManager {
    private static final Logger log = LoggerFactory.getLogger(PageTemplateManagerImpl.class);
    private Resource resource;
    @OSGiService
    private ConfigurationResourceResolver configurationResourceResolver;

    public PageTemplateManagerImpl(Resource resource) {
        this.resource = resource;
    }

    private List<PageTemplate> getSiteTemplates() {
        return CMSUtils.adaptResources((Collection)this.configurationResourceResolver.getResourceCollection(this.resource, "site", "templates"), PageTemplate.class);
    }

    public List<PageTemplate> getAvailableTemplates() {
        String path = this.resource.getPath();
        ArrayList<PageTemplate> availableTemplates = new ArrayList<PageTemplate>();
        block0: for (PageTemplate template : this.getSiteTemplates()) {
            log.debug("Checking to see if template {} is available for path {}", (Object)template.getResource().getPath(), (Object)path);
            for (String allowedPath : template.getAllowedPaths()) {
                log.trace("Checking to see if path {} matches regex {}", (Object)path, (Object)allowedPath);
                if (!path.matches(allowedPath)) continue;
                availableTemplates.add(template);
                log.debug("Template {} is available for path {}", (Object)template.getResource().getPath(), (Object)path);
                continue block0;
            }
        }
        return availableTemplates;
    }

    public String toString() {
        return "PageTemplateManager [siteTemplates=" + this.getSiteTemplates() + ", resource=" + this.resource + "]";
    }
}

