/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.reference.forms.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.cms.ResourceTree;
import org.apache.sling.cms.reference.forms.FieldHandler;
import org.apache.sling.cms.reference.forms.FormException;
import org.apache.sling.cms.reference.forms.FormRequest;
import org.apache.sling.cms.reference.forms.FormValueProvider;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class, Resource.class}, adapters={FormRequest.class})
public class FormRequestImpl
implements FormRequest {
    private static final Logger log = LoggerFactory.getLogger(FormRequestImpl.class);
    private final List<FieldHandler> fieldHandlers;
    private final Map<String, Object> formData = new HashMap<String, Object>();
    private final SlingHttpServletRequest request;

    @Inject
    public FormRequestImpl(@Self SlingHttpServletRequest request, @OSGiService(injectionStrategy=InjectionStrategy.OPTIONAL) List<FormValueProvider> formValueProvider, @OSGiService(injectionStrategy=InjectionStrategy.OPTIONAL) List<FieldHandler> fieldHandlers) {
        this.request = request;
        this.fieldHandlers = fieldHandlers;
        if (request.getSession().getAttribute(this.getSessionId()) != null) {
            this.formData.putAll((Map)request.getSession().getAttribute(this.getSessionId()));
        }
        if (this.getFormResource() != null && this.getFormResource().getChild("providers") != null) {
            this.loadProviders(formValueProvider);
        }
    }

    private void loadProviders(List<FormValueProvider> formValueProvider) {
        List providers = ResourceTree.stream((Resource)this.getFormResource().getChild("providers")).map(ResourceTree::getResource).collect(Collectors.toList());
        block0: for (Resource provider : providers) {
            log.debug("Looking for handler for: {}", (Object)provider);
            if (formValueProvider == null) continue;
            for (FormValueProvider fvp : formValueProvider) {
                if (!fvp.handles(provider)) continue;
                log.debug("Invoking field value provider: {}", fvp.getClass());
                fvp.loadValues(this.request, provider, this.formData);
                continue block0;
            }
        }
    }

    @Override
    public ValueMap getFormData() {
        return new ValueMapDecorator(this.formData);
    }

    @Override
    public Resource getFormResource() {
        return this.request.getResource();
    }

    @Override
    public SlingHttpServletRequest getOriginalRequest() {
        return this.request;
    }

    public boolean initFields() {
        List fields = ResourceTree.stream((Resource)this.getFormResource().getChild("fields")).map(ResourceTree::getResource).collect(Collectors.toList());
        boolean successful = true;
        for (Resource field : fields) {
            this.formData.remove(this.getErrorKey(field));
            try {
                log.debug("Looking for handler for: {}", (Object)field);
                for (FieldHandler fieldHandler : this.fieldHandlers) {
                    if (!fieldHandler.handles(field)) continue;
                    log.debug("Invoking field handler: {}", fieldHandler.getClass());
                    fieldHandler.handleField(this.request, field, this.formData);
                }
            }
            catch (FormException fe) {
                log.warn("Failed to populate field {} due to exception", (Object)field, (Object)fe);
                successful = false;
                this.formData.put(this.getErrorKey(field), fe.getMessage());
            }
        }
        return successful;
    }

    private String getErrorKey(Resource field) {
        return "fielderror-" + (String)field.getValueMap().get("name", String.class);
    }

    @Override
    public String getSessionId() {
        return "errorval-" + Optional.ofNullable(this.getFormResource()).map(Resource::getPath).orElse("null");
    }
}

