/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.base.its.setup;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;
import java.util.UUID;
import junitx.util.PrivateAccessor;
import org.apache.sling.discovery.ClusterView;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.TopologyView;
import org.apache.sling.discovery.base.commons.DefaultTopologyView;
import org.apache.sling.discovery.commons.providers.DefaultClusterView;
import org.apache.sling.discovery.commons.providers.DefaultInstanceDescription;
import org.junit.Assert;

public class TopologyHelper {
    public static DefaultInstanceDescription createInstanceDescription(ClusterView clusterView) {
        return TopologyHelper.createInstanceDescription(UUID.randomUUID().toString(), false, clusterView);
    }

    public static DefaultInstanceDescription createInstanceDescription(String instanceId, boolean isLocal, ClusterView clusterView) {
        if (!(clusterView instanceof DefaultClusterView)) {
            throw new IllegalArgumentException("Must pass a clusterView of type " + DefaultClusterView.class);
        }
        DefaultInstanceDescription i = new DefaultInstanceDescription((DefaultClusterView)clusterView, false, isLocal, instanceId, new HashMap());
        return i;
    }

    public static DefaultTopologyView createTopologyView(String clusterViewId, String slingId) {
        DefaultTopologyView t = new DefaultTopologyView();
        DefaultClusterView c = new DefaultClusterView(clusterViewId);
        DefaultInstanceDescription i = new DefaultInstanceDescription(c, true, false, slingId, new HashMap());
        LinkedList<DefaultInstanceDescription> instances = new LinkedList<DefaultInstanceDescription>();
        instances.add(i);
        t.addInstances(instances);
        return t;
    }

    public static DefaultTopologyView cloneTopologyView(DefaultTopologyView original) {
        DefaultTopologyView t = new DefaultTopologyView();
        for (DefaultClusterView c : original.getClusterViews()) {
            t.addInstances((Collection)TopologyHelper.clone(c).getInstances());
        }
        return t;
    }

    public static DefaultClusterView clone(DefaultClusterView original) {
        DefaultClusterView c = new DefaultClusterView(original.getId());
        for (DefaultInstanceDescription id : original.getInstances()) {
            c.addInstanceDescription(TopologyHelper.cloneWOClusterView(id));
        }
        return c;
    }

    public static DefaultInstanceDescription cloneWOClusterView(DefaultInstanceDescription original) {
        DefaultInstanceDescription id = new DefaultInstanceDescription(null, original.isLeader(), original.isLocal(), original.getSlingId(), new HashMap(original.getProperties()));
        return id;
    }

    public static DefaultInstanceDescription createAndAddInstanceDescription(DefaultTopologyView newView, ClusterView clusterView) {
        DefaultInstanceDescription i = TopologyHelper.createInstanceDescription(clusterView);
        return TopologyHelper.addInstanceDescription(newView, i);
    }

    public static DefaultInstanceDescription addInstanceDescription(DefaultTopologyView newView, DefaultInstanceDescription i) {
        LinkedList<DefaultInstanceDescription> instances = new LinkedList<DefaultInstanceDescription>();
        instances.add(i);
        newView.addInstances(instances);
        return i;
    }

    public static DefaultTopologyView cloneTopologyView(DefaultTopologyView view, String newLeader) throws NoSuchFieldException {
        DefaultTopologyView clone = TopologyHelper.cloneTopologyView(view);
        DefaultClusterView cluster = (DefaultClusterView)clone.getClusterViews().iterator().next();
        for (DefaultInstanceDescription id : cluster.getInstances()) {
            PrivateAccessor.setField((Object)id, (String)"isLeader", (Object)id.getSlingId().equals(newLeader));
        }
        return clone;
    }

    public static void assertTopologyConsistsOf(TopologyView topology, String ... slingIds) {
        Assert.assertNotNull((Object)topology);
        Assert.assertEquals((long)slingIds.length, (long)topology.getInstances().size());
        for (int i = 0; i < slingIds.length; ++i) {
            String aSlingId = slingIds[i];
            Set instances = topology.getInstances();
            boolean found = false;
            for (InstanceDescription anInstance : instances) {
                if (!anInstance.getSlingId().equals(aSlingId)) continue;
                found = true;
                break;
            }
            Assert.assertTrue((boolean)found);
        }
    }
}

