/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.parameters;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestPartsIterator
implements Iterator<Part> {
    private static final Logger LOG = LoggerFactory.getLogger(RequestPartsIterator.class);
    private final FileItemIterator itemIterator;

    public RequestPartsIterator(HttpServletRequest servletRequest) throws IOException, FileUploadException {
        ServletFileUpload upload = new ServletFileUpload();
        upload.setFileCountMax(50L);
        this.itemIterator = upload.getItemIterator(servletRequest);
    }

    @Override
    public boolean hasNext() {
        try {
            return this.itemIterator.hasNext();
        }
        catch (FileUploadException e) {
            LOG.error("hasNext Item failed cause:" + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("hasNext Item failed cause:" + e.getMessage(), (Throwable)e);
        }
        return false;
    }

    @Override
    public Part next() {
        try {
            return new StreamedRequestPart(this.itemIterator.next());
        }
        catch (IOException e) {
            LOG.error("next Item failed cause:" + e.getMessage(), (Throwable)e);
        }
        catch (FileUploadException e) {
            LOG.error("next Item failed cause:" + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove is not supported on a request stream.");
    }

    private static class StreamedRequestPart
    implements Part {
        private final FileItemStream fileItem;
        private final InputStream inputStream;

        public StreamedRequestPart(FileItemStream fileItem) throws IOException {
            this.fileItem = fileItem;
            this.inputStream = fileItem.openStream();
        }

        public InputStream getInputStream() throws IOException {
            return this.inputStream;
        }

        public String getContentType() {
            return this.fileItem.getContentType();
        }

        public String getName() {
            return this.fileItem.getFieldName();
        }

        public long getSize() {
            return 0L;
        }

        public void write(String s) throws IOException {
            throw new UnsupportedOperationException("Writing parts directly to disk is not supported by this implementation, use getInputStream instead");
        }

        public void delete() throws IOException {
        }

        public String getHeader(String headerName) {
            return this.fileItem.getHeaders().getHeader(headerName);
        }

        public Collection<String> getHeaders(String headerName) {
            return this.toCollection(this.fileItem.getHeaders().getHeaders(headerName));
        }

        public Collection<String> getHeaderNames() {
            return this.toCollection(this.fileItem.getHeaders().getHeaderNames());
        }

        public String getSubmittedFileName() {
            return this.fileItem.getName();
        }

        private <T> Collection<T> toCollection(Iterator<T> i) {
            if (i == null) {
                return Collections.emptyList();
            }
            ArrayList<T> c = new ArrayList<T>();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c;
        }
    }
}

