/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.extensions.threaddump.internal;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.apache.felix.shell.Command;
import org.apache.sling.extensions.threaddump.internal.BaseThreadDumper;

public class ThreadDumpCommand
extends BaseThreadDumper
implements Command {
    private static final String CMD_NAME = "threads";
    private static final String OPT_STACK = "-s";

    public String getName() {
        return CMD_NAME;
    }

    public String getShortDescription() {
        return "dumps the JVM threads";
    }

    public String getUsage() {
        return "threads [-s] <id> ...";
    }

    public void execute(String command, PrintStream out, PrintStream err) {
        if (command.startsWith(CMD_NAME)) {
            command = command.substring(CMD_NAME.length());
        }
        boolean longListing = false;
        LinkedList<Long> threadIds = new LinkedList<Long>();
        StringTokenizer tokener = new StringTokenizer(command, ", \t");
        while (tokener.hasMoreTokens()) {
            String token = tokener.nextToken().trim();
            if (OPT_STACK.equals(token)) {
                longListing = true;
                continue;
            }
            try {
                long threadId = Long.parseLong(token);
                threadIds.add(threadId);
            }
            catch (NumberFormatException nfe) {
                this.noSuchThread(err, token);
            }
        }
        PrintWriter pw = new PrintWriter(out);
        if (threadIds.isEmpty()) {
            this.printThreads(pw, longListing);
        } else {
            while (!threadIds.isEmpty()) {
                Long threadId = (Long)threadIds.removeFirst();
                if (this.printThread(pw, threadId, longListing)) continue;
                this.noSuchThread(err, threadId);
            }
        }
        pw.flush();
    }

    private void noSuchThread(PrintStream err, Object threadId) {
        err.println("No such Thread: " + threadId);
        err.flush();
    }
}

