/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.junit.rules;

import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunOnceRule
implements TestRule {
    private static final Logger LOG = LoggerFactory.getLogger(RunOnceRule.class);
    private static AtomicBoolean run = new AtomicBoolean(false);
    private final TestRule rule;

    public <T extends TestRule> RunOnceRule(T rule) {
        this.rule = rule;
    }

    public Statement apply(Statement base, Description description) {
        if (!run.getAndSet(true)) {
            LOG.debug("Applying {} once", this.rule.getClass());
            return this.rule.apply(base, description);
        }
        return base;
    }
}

