/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.validation.impl.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.sling.validation.model.ChildResource;
import org.apache.sling.validation.model.ResourceProperty;
import org.apache.sling.validation.model.ValidationModel;

public class MergedValidationModel
implements ValidationModel {
    private final ValidationModel baseModel;
    private final Map<String, ResourceProperty> resourcePropertiesMap;
    private final Map<String, ChildResource> childResourceMap;
    @Nonnull
    private final String source;

    public MergedValidationModel(ValidationModel baseModel, ValidationModel ... modelsToMerge) {
        this.baseModel = baseModel;
        this.resourcePropertiesMap = new HashMap<String, ResourceProperty>();
        for (ResourceProperty resourceProperty : baseModel.getResourceProperties()) {
            this.resourcePropertiesMap.put(resourceProperty.getName(), resourceProperty);
        }
        this.childResourceMap = new HashMap<String, ChildResource>();
        for (ChildResource childResource : baseModel.getChildren()) {
            this.childResourceMap.put(childResource.getName(), childResource);
        }
        StringBuilder sourceStringBuilder = new StringBuilder(baseModel.getSource());
        for (ValidationModel modelToMerge : modelsToMerge) {
            for (ResourceProperty resourceProperty : modelToMerge.getResourceProperties()) {
                if (this.resourcePropertiesMap.containsKey(resourceProperty.getName())) continue;
                this.resourcePropertiesMap.put(resourceProperty.getName(), resourceProperty);
            }
            for (ChildResource childResource : modelToMerge.getChildren()) {
                if (this.childResourceMap.containsKey(childResource.getName())) continue;
                this.childResourceMap.put(childResource.getName(), childResource);
            }
            for (String path : modelToMerge.getApplicablePaths()) {
                if (!this.isPathRestricted(path, baseModel.getApplicablePaths())) continue;
                String msg = String.format("The path '%s' from one of the models to merge is more specific than any of the base paths (%s)", path, baseModel.getApplicablePaths());
                throw new IllegalArgumentException(msg);
            }
            sourceStringBuilder.append(" + ").append(modelToMerge.getSource());
        }
        this.source = sourceStringBuilder.toString();
    }

    private boolean isPathRestricted(String path, Collection<String> pathsToCompareWith) {
        for (String basePath : pathsToCompareWith) {
            if (!basePath.startsWith(path)) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public Collection<ResourceProperty> getResourceProperties() {
        return this.resourcePropertiesMap.values();
    }

    @Nonnull
    public String getValidatingResourceType() {
        return this.baseModel.getValidatingResourceType();
    }

    @Nonnull
    public Collection<String> getApplicablePaths() {
        return this.baseModel.getApplicablePaths();
    }

    @Nonnull
    public Collection<ChildResource> getChildren() {
        return this.childResourceMap.values();
    }

    @Nonnull
    public String getSource() {
        return this.source;
    }
}

