/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.session;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.common.cli.HiveFileProcessor;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.exec.FetchFormatter;
import org.apache.hadoop.hive.ql.history.HiveHistory;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.processors.SetProcessor;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.common.util.HiveVersionInfo;
import org.apache.hive.service.auth.HiveAuthFactory;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.FetchType;
import org.apache.hive.service.cli.GetInfoType;
import org.apache.hive.service.cli.GetInfoValue;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.operation.ExecuteStatementOperation;
import org.apache.hive.service.cli.operation.GetCatalogsOperation;
import org.apache.hive.service.cli.operation.GetColumnsOperation;
import org.apache.hive.service.cli.operation.GetFunctionsOperation;
import org.apache.hive.service.cli.operation.GetSchemasOperation;
import org.apache.hive.service.cli.operation.GetTableTypesOperation;
import org.apache.hive.service.cli.operation.GetTypeInfoOperation;
import org.apache.hive.service.cli.operation.MetadataOperation;
import org.apache.hive.service.cli.operation.Operation;
import org.apache.hive.service.cli.operation.OperationManager;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.hive.service.cli.session.SessionManager;
import org.apache.hive.service.cli.thrift.TProtocolVersion;
import org.apache.hive.service.server.ThreadWithGarbageCleanup;

public class HiveSessionImpl
implements HiveSession {
    private final SessionHandle sessionHandle;
    private String username;
    private final String password;
    private HiveConf hiveConf;
    private final SessionState sessionState;
    private String ipAddress;
    private static final String FETCH_WORK_SERDE_CLASS = "org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe";
    private static final Log LOG = LogFactory.getLog(HiveSessionImpl.class);
    private SessionManager sessionManager;
    private OperationManager operationManager;
    private final Set<OperationHandle> opHandleSet = new HashSet<OperationHandle>();
    private boolean isOperationLogEnabled;
    private File sessionLogDir;
    private volatile long lastAccessTime;

    public HiveSessionImpl(TProtocolVersion protocol, String username, String password, HiveConf serverhiveConf, String ipAddress) {
        this.username = username;
        this.password = password;
        this.sessionHandle = new SessionHandle(protocol);
        this.hiveConf = new HiveConf(serverhiveConf);
        this.ipAddress = ipAddress;
        this.hiveConf.set(HiveConf.ConfVars.HIVESESSIONID.varname, this.sessionHandle.getHandleIdentifier().toString());
        this.hiveConf.set("output.formatter", FetchFormatter.ThriftFormatter.class.getName());
        this.hiveConf.setInt("output.protocol", protocol.getValue());
        this.sessionState = new SessionState(this.hiveConf, username);
        this.sessionState.setUserIpAddress(ipAddress);
        this.sessionState.setIsHiveServerQuery(true);
        this.lastAccessTime = System.currentTimeMillis();
        SessionState.start((SessionState)this.sessionState);
    }

    @Override
    public void initialize(Map<String, String> sessionConfMap) throws Exception {
        this.processGlobalInitFile();
        try {
            this.sessionState.reloadAuxJars();
        }
        catch (IOException e) {
            String msg = "fail to load reloadable jar file path" + e;
            LOG.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        SessionState.setCurrentSessionState((SessionState)this.sessionState);
        if (sessionConfMap != null) {
            this.configureSession(sessionConfMap);
        }
    }

    private void processGlobalInitFile() {
        GlobalHivercFileProcessor processor = new GlobalHivercFileProcessor();
        try {
            String hiverc = this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_GLOBAL_INIT_FILE_LOCATION);
            if (hiverc != null) {
                File hivercFile = new File(hiverc);
                if (hivercFile.isDirectory()) {
                    hivercFile = new File(hivercFile, ".hiverc");
                }
                if (hivercFile.isFile()) {
                    LOG.info((Object)("Running global init file: " + hivercFile));
                    int rc = processor.processFile(hivercFile.getAbsolutePath());
                    if (rc != 0) {
                        LOG.error((Object)"Failed on initializing global .hiverc file");
                    }
                } else {
                    LOG.debug((Object)("Global init file " + hivercFile + " does not exist"));
                }
            }
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed on initializing global .hiverc file", (Throwable)e);
        }
    }

    private void configureSession(Map<String, String> sessionConfMap) throws Exception {
        SessionState.setCurrentSessionState((SessionState)this.sessionState);
        for (Map.Entry<String, String> entry : sessionConfMap.entrySet()) {
            String key = entry.getKey();
            if (key.startsWith("set:")) {
                SetProcessor.setVariable((String)key.substring(4), (String)entry.getValue());
                continue;
            }
            if (key.startsWith("use:")) {
                SessionState.get().setCurrentDatabase(entry.getValue());
                continue;
            }
            this.hiveConf.verifyAndSet(key, entry.getValue());
        }
    }

    @Override
    public void setOperationLogSessionDir(File operationLogRootDir) {
        this.sessionLogDir = new File(operationLogRootDir, this.sessionHandle.getHandleIdentifier().toString());
        this.isOperationLogEnabled = true;
        if (!this.sessionLogDir.exists() && !this.sessionLogDir.mkdir()) {
            LOG.warn((Object)("Unable to create operation log session directory: " + this.sessionLogDir.getAbsolutePath()));
            this.isOperationLogEnabled = false;
        }
        if (this.isOperationLogEnabled) {
            LOG.info((Object)("Operation log session directory is created: " + this.sessionLogDir.getAbsolutePath()));
        }
    }

    @Override
    public boolean isOperationLogEnabled() {
        return this.isOperationLogEnabled;
    }

    @Override
    public File getOperationLogSessionDir() {
        return this.sessionLogDir;
    }

    @Override
    public TProtocolVersion getProtocolVersion() {
        return this.sessionHandle.getProtocolVersion();
    }

    @Override
    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    @Override
    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    private OperationManager getOperationManager() {
        return this.operationManager;
    }

    @Override
    public void setOperationManager(OperationManager operationManager) {
        this.operationManager = operationManager;
    }

    @Override
    public void open() {
        SessionState.start((SessionState)this.sessionState);
    }

    protected synchronized void acquire(boolean userAccess) {
        SessionState.setCurrentSessionState((SessionState)this.sessionState);
        if (userAccess) {
            this.lastAccessTime = System.currentTimeMillis();
        }
    }

    protected synchronized void release(boolean userAccess) {
        SessionState.detachSession();
        if (ThreadWithGarbageCleanup.currentThread() instanceof ThreadWithGarbageCleanup) {
            ThreadWithGarbageCleanup currentThread = (ThreadWithGarbageCleanup)ThreadWithGarbageCleanup.currentThread();
            currentThread.cacheThreadLocalRawStore();
        }
        if (userAccess) {
            this.lastAccessTime = System.currentTimeMillis();
        }
    }

    @Override
    public SessionHandle getSessionHandle() {
        return this.sessionHandle;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public HiveConf getHiveConf() {
        this.hiveConf.setVar(HiveConf.ConfVars.HIVEFETCHOUTPUTSERDE, FETCH_WORK_SERDE_CLASS);
        return this.hiveConf;
    }

    @Override
    public IMetaStoreClient getMetaStoreClient() throws HiveSQLException {
        try {
            return Hive.get((HiveConf)this.getHiveConf()).getMSC();
        }
        catch (HiveException e) {
            throw new HiveSQLException("Failed to get metastore connection", e);
        }
        catch (MetaException e) {
            throw new HiveSQLException("Failed to get metastore connection", e);
        }
    }

    @Override
    public GetInfoValue getInfo(GetInfoType getInfoType) throws HiveSQLException {
        this.acquire(true);
        try {
            switch (getInfoType) {
                case CLI_SERVER_NAME: {
                    GetInfoValue getInfoValue = new GetInfoValue("Hive");
                    return getInfoValue;
                }
                case CLI_DBMS_NAME: {
                    GetInfoValue getInfoValue = new GetInfoValue("Apache Hive");
                    return getInfoValue;
                }
                case CLI_DBMS_VER: {
                    GetInfoValue getInfoValue = new GetInfoValue(HiveVersionInfo.getVersion());
                    return getInfoValue;
                }
                case CLI_MAX_COLUMN_NAME_LEN: {
                    GetInfoValue getInfoValue = new GetInfoValue(128);
                    return getInfoValue;
                }
                case CLI_MAX_SCHEMA_NAME_LEN: {
                    GetInfoValue getInfoValue = new GetInfoValue(128);
                    return getInfoValue;
                }
                case CLI_MAX_TABLE_NAME_LEN: {
                    GetInfoValue getInfoValue = new GetInfoValue(128);
                    return getInfoValue;
                }
            }
            throw new HiveSQLException("Unrecognized GetInfoType value: " + getInfoType.toString());
        }
        finally {
            this.release(true);
        }
    }

    @Override
    public OperationHandle executeStatement(String statement, Map<String, String> confOverlay) throws HiveSQLException {
        return this.executeStatementInternal(statement, confOverlay, false);
    }

    @Override
    public OperationHandle executeStatementAsync(String statement, Map<String, String> confOverlay) throws HiveSQLException {
        return this.executeStatementInternal(statement, confOverlay, true);
    }

    private OperationHandle executeStatementInternal(String statement, Map<String, String> confOverlay, boolean runAsync) throws HiveSQLException {
        this.acquire(true);
        OperationManager operationManager = this.getOperationManager();
        ExecuteStatementOperation operation = operationManager.newExecuteStatementOperation(this.getSession(), statement, confOverlay, runAsync);
        OperationHandle opHandle = operation.getHandle();
        try {
            operation.run();
            this.opHandleSet.add(opHandle);
            OperationHandle operationHandle = opHandle;
            return operationHandle;
        }
        catch (HiveSQLException e) {
            if (!runAsync) {
                operationManager.closeOperation(opHandle);
            }
            throw e;
        }
        finally {
            this.release(true);
        }
    }

    @Override
    public OperationHandle getTypeInfo() throws HiveSQLException {
        this.acquire(true);
        OperationManager operationManager = this.getOperationManager();
        GetTypeInfoOperation operation = operationManager.newGetTypeInfoOperation(this.getSession());
        OperationHandle opHandle = operation.getHandle();
        try {
            operation.run();
            this.opHandleSet.add(opHandle);
            OperationHandle operationHandle = opHandle;
            return operationHandle;
        }
        catch (HiveSQLException e) {
            operationManager.closeOperation(opHandle);
            throw e;
        }
        finally {
            this.release(true);
        }
    }

    @Override
    public OperationHandle getCatalogs() throws HiveSQLException {
        this.acquire(true);
        OperationManager operationManager = this.getOperationManager();
        GetCatalogsOperation operation = operationManager.newGetCatalogsOperation(this.getSession());
        OperationHandle opHandle = operation.getHandle();
        try {
            operation.run();
            this.opHandleSet.add(opHandle);
            OperationHandle operationHandle = opHandle;
            return operationHandle;
        }
        catch (HiveSQLException e) {
            operationManager.closeOperation(opHandle);
            throw e;
        }
        finally {
            this.release(true);
        }
    }

    @Override
    public OperationHandle getSchemas(String catalogName, String schemaName) throws HiveSQLException {
        this.acquire(true);
        OperationManager operationManager = this.getOperationManager();
        GetSchemasOperation operation = operationManager.newGetSchemasOperation(this.getSession(), catalogName, schemaName);
        OperationHandle opHandle = operation.getHandle();
        try {
            operation.run();
            this.opHandleSet.add(opHandle);
            OperationHandle operationHandle = opHandle;
            return operationHandle;
        }
        catch (HiveSQLException e) {
            operationManager.closeOperation(opHandle);
            throw e;
        }
        finally {
            this.release(true);
        }
    }

    @Override
    public OperationHandle getTables(String catalogName, String schemaName, String tableName, List<String> tableTypes) throws HiveSQLException {
        this.acquire(true);
        OperationManager operationManager = this.getOperationManager();
        MetadataOperation operation = operationManager.newGetTablesOperation(this.getSession(), catalogName, schemaName, tableName, tableTypes);
        OperationHandle opHandle = operation.getHandle();
        try {
            operation.run();
            this.opHandleSet.add(opHandle);
            OperationHandle operationHandle = opHandle;
            return operationHandle;
        }
        catch (HiveSQLException e) {
            operationManager.closeOperation(opHandle);
            throw e;
        }
        finally {
            this.release(true);
        }
    }

    @Override
    public OperationHandle getTableTypes() throws HiveSQLException {
        this.acquire(true);
        OperationManager operationManager = this.getOperationManager();
        GetTableTypesOperation operation = operationManager.newGetTableTypesOperation(this.getSession());
        OperationHandle opHandle = operation.getHandle();
        try {
            operation.run();
            this.opHandleSet.add(opHandle);
            OperationHandle operationHandle = opHandle;
            return operationHandle;
        }
        catch (HiveSQLException e) {
            operationManager.closeOperation(opHandle);
            throw e;
        }
        finally {
            this.release(true);
        }
    }

    @Override
    public OperationHandle getColumns(String catalogName, String schemaName, String tableName, String columnName) throws HiveSQLException {
        this.acquire(true);
        OperationManager operationManager = this.getOperationManager();
        GetColumnsOperation operation = operationManager.newGetColumnsOperation(this.getSession(), catalogName, schemaName, tableName, columnName);
        OperationHandle opHandle = operation.getHandle();
        try {
            operation.run();
            this.opHandleSet.add(opHandle);
            OperationHandle operationHandle = opHandle;
            return operationHandle;
        }
        catch (HiveSQLException e) {
            operationManager.closeOperation(opHandle);
            throw e;
        }
        finally {
            this.release(true);
        }
    }

    @Override
    public OperationHandle getFunctions(String catalogName, String schemaName, String functionName) throws HiveSQLException {
        this.acquire(true);
        OperationManager operationManager = this.getOperationManager();
        GetFunctionsOperation operation = operationManager.newGetFunctionsOperation(this.getSession(), catalogName, schemaName, functionName);
        OperationHandle opHandle = operation.getHandle();
        try {
            operation.run();
            this.opHandleSet.add(opHandle);
            OperationHandle operationHandle = opHandle;
            return operationHandle;
        }
        catch (HiveSQLException e) {
            operationManager.closeOperation(opHandle);
            throw e;
        }
        finally {
            this.release(true);
        }
    }

    @Override
    public void close() throws HiveSQLException {
        try {
            this.acquire(true);
            for (OperationHandle opHandle : this.opHandleSet) {
                this.operationManager.closeOperation(opHandle);
            }
            this.opHandleSet.clear();
            this.cleanupSessionLogDir();
            HiveHistory hiveHist = this.sessionState.getHiveHistory();
            if (null != hiveHist) {
                hiveHist.closeStream();
            }
            this.sessionState.close();
        }
        catch (IOException ioe) {
            throw new HiveSQLException("Failure to close", ioe);
        }
        finally {
            this.release(true);
        }
    }

    private void cleanupSessionLogDir() {
        if (this.isOperationLogEnabled) {
            try {
                FileUtils.forceDelete((File)this.sessionLogDir);
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to cleanup session log dir: " + this.sessionHandle), (Throwable)e);
            }
        }
    }

    @Override
    public SessionState getSessionState() {
        return this.sessionState;
    }

    @Override
    public String getUserName() {
        return this.username;
    }

    @Override
    public void setUserName(String userName) {
        this.username = userName;
    }

    @Override
    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public void closeExpiredOperations() {
        List<Operation> operations;
        OperationHandle[] handles = this.opHandleSet.toArray(new OperationHandle[this.opHandleSet.size()]);
        if (handles.length > 0 && !(operations = this.operationManager.removeExpiredOperations(handles)).isEmpty()) {
            this.closeTimedOutOperations(operations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeTimedOutOperations(List<Operation> operations) {
        this.acquire(false);
        try {
            for (Operation operation : operations) {
                this.opHandleSet.remove(operation.getHandle());
                try {
                    operation.close();
                }
                catch (Exception e) {
                    LOG.warn((Object)("Exception is thrown closing timed-out operation " + operation.getHandle()), (Throwable)e);
                }
            }
        }
        finally {
            this.release(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelOperation(OperationHandle opHandle) throws HiveSQLException {
        this.acquire(true);
        try {
            this.sessionManager.getOperationManager().cancelOperation(opHandle);
        }
        finally {
            this.release(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeOperation(OperationHandle opHandle) throws HiveSQLException {
        this.acquire(true);
        try {
            this.operationManager.closeOperation(opHandle);
            this.opHandleSet.remove(opHandle);
        }
        finally {
            this.release(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableSchema getResultSetMetadata(OperationHandle opHandle) throws HiveSQLException {
        this.acquire(true);
        try {
            TableSchema tableSchema = this.sessionManager.getOperationManager().getOperationResultSetSchema(opHandle);
            return tableSchema;
        }
        finally {
            this.release(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowSet fetchResults(OperationHandle opHandle, FetchOrientation orientation, long maxRows, FetchType fetchType) throws HiveSQLException {
        this.acquire(true);
        try {
            if (fetchType == FetchType.QUERY_OUTPUT) {
                RowSet rowSet = this.operationManager.getOperationNextRowSet(opHandle, orientation, maxRows);
                return rowSet;
            }
            RowSet rowSet = this.operationManager.getOperationLogRowSet(opHandle, orientation, maxRows);
            return rowSet;
        }
        finally {
            this.release(true);
        }
    }

    protected HiveSession getSession() {
        return this;
    }

    @Override
    public String getIpAddress() {
        return this.ipAddress;
    }

    @Override
    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    @Override
    public String getDelegationToken(HiveAuthFactory authFactory, String owner, String renewer) throws HiveSQLException {
        HiveAuthFactory.verifyProxyAccess(this.getUsername(), owner, this.getIpAddress(), this.getHiveConf());
        return authFactory.getDelegationToken(owner, renewer);
    }

    @Override
    public void cancelDelegationToken(HiveAuthFactory authFactory, String tokenStr) throws HiveSQLException {
        HiveAuthFactory.verifyProxyAccess(this.getUsername(), this.getUserFromToken(authFactory, tokenStr), this.getIpAddress(), this.getHiveConf());
        authFactory.cancelDelegationToken(tokenStr);
    }

    @Override
    public void renewDelegationToken(HiveAuthFactory authFactory, String tokenStr) throws HiveSQLException {
        HiveAuthFactory.verifyProxyAccess(this.getUsername(), this.getUserFromToken(authFactory, tokenStr), this.getIpAddress(), this.getHiveConf());
        authFactory.renewDelegationToken(tokenStr);
    }

    private String getUserFromToken(HiveAuthFactory authFactory, String tokenStr) throws HiveSQLException {
        return authFactory.getUserFromToken(tokenStr);
    }

    private class GlobalHivercFileProcessor
    extends HiveFileProcessor {
        private GlobalHivercFileProcessor() {
        }

        protected BufferedReader loadFile(String fileName) throws IOException {
            FileInputStream initStream = null;
            BufferedReader bufferedReader = null;
            initStream = new FileInputStream(fileName);
            bufferedReader = new BufferedReader(new InputStreamReader(initStream));
            return bufferedReader;
        }

        protected int processCmd(String cmd) {
            int rc = 0;
            String cmd_trimed = cmd.trim();
            try {
                HiveSessionImpl.this.executeStatementInternal(cmd_trimed, null, false);
            }
            catch (HiveSQLException e) {
                rc = -1;
                LOG.warn((Object)"Failed to execute HQL command in global .hiverc file.", (Throwable)e);
            }
            return rc;
        }
    }
}

