/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.server;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hive.service.server.ThreadWithGarbageCleanup;

public class ThreadFactoryWithGarbageCleanup
implements ThreadFactory {
    private static Map<Long, RawStore> threadRawStoreMap = new HashMap<Long, RawStore>();
    private final String namePrefix;

    public ThreadFactoryWithGarbageCleanup(String threadPoolName) {
        this.namePrefix = threadPoolName;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        ThreadWithGarbageCleanup newThread = new ThreadWithGarbageCleanup(runnable);
        newThread.setName(this.namePrefix + ": Thread-" + newThread.getId());
        return newThread;
    }

    public static Map<Long, RawStore> getThreadRawStoreMap() {
        return threadRawStoreMap;
    }
}

