/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli.shaded;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.shaded.Option;
import org.apache.commons.cli.shaded.ParseException;
import org.apache.commons.cli.shaded.TypeHandler;
import org.apache.commons.cli.shaded.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLine
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<String> args = new LinkedList<String>();
    private final List<Option> options = new ArrayList<Option>();

    protected CommandLine() {
    }

    public boolean hasOption(String opt2) {
        return this.options.contains(this.resolveOption(opt2));
    }

    public boolean hasOption(char opt2) {
        return this.hasOption(String.valueOf(opt2));
    }

    @Deprecated
    public Object getOptionObject(String opt2) {
        try {
            return this.getParsedOptionValue(opt2);
        }
        catch (ParseException pe) {
            System.err.println("Exception found converting " + opt2 + " to desired type: " + pe.getMessage());
            return null;
        }
    }

    public Object getParsedOptionValue(String opt2) throws ParseException {
        String res = this.getOptionValue(opt2);
        Option option = this.resolveOption(opt2);
        if (option == null || res == null) {
            return null;
        }
        return TypeHandler.createValue(res, option.getType());
    }

    public Object getOptionObject(char opt2) {
        return this.getOptionObject(String.valueOf(opt2));
    }

    public String getOptionValue(String opt2) {
        String[] values = this.getOptionValues(opt2);
        return values == null ? null : values[0];
    }

    public String getOptionValue(char opt2) {
        return this.getOptionValue(String.valueOf(opt2));
    }

    public String[] getOptionValues(String opt2) {
        ArrayList<String> values = new ArrayList<String>();
        for (Option option : this.options) {
            if (!opt2.equals(option.getOpt()) && !opt2.equals(option.getLongOpt())) continue;
            values.addAll(option.getValuesList());
        }
        return values.isEmpty() ? null : values.toArray(new String[values.size()]);
    }

    private Option resolveOption(String opt2) {
        opt2 = Util.stripLeadingHyphens(opt2);
        for (Option option : this.options) {
            if (opt2.equals(option.getOpt())) {
                return option;
            }
            if (!opt2.equals(option.getLongOpt())) continue;
            return option;
        }
        return null;
    }

    public String[] getOptionValues(char opt2) {
        return this.getOptionValues(String.valueOf(opt2));
    }

    public String getOptionValue(String opt2, String defaultValue) {
        String answer = this.getOptionValue(opt2);
        return answer != null ? answer : defaultValue;
    }

    public String getOptionValue(char opt2, String defaultValue) {
        return this.getOptionValue(String.valueOf(opt2), defaultValue);
    }

    public Properties getOptionProperties(String opt2) {
        Properties props = new Properties();
        for (Option option : this.options) {
            if (!opt2.equals(option.getOpt()) && !opt2.equals(option.getLongOpt())) continue;
            List<String> values = option.getValuesList();
            if (values.size() >= 2) {
                props.put(values.get(0), values.get(1));
                continue;
            }
            if (values.size() != 1) continue;
            props.put(values.get(0), "true");
        }
        return props;
    }

    public String[] getArgs() {
        String[] answer = new String[this.args.size()];
        this.args.toArray(answer);
        return answer;
    }

    public List<String> getArgList() {
        return this.args;
    }

    protected void addArg(String arg) {
        this.args.add(arg);
    }

    protected void addOption(Option opt2) {
        this.options.add(opt2);
    }

    public Iterator<Option> iterator() {
        return this.options.iterator();
    }

    public Option[] getOptions() {
        List<Option> processed = this.options;
        Option[] optionsArray = new Option[processed.size()];
        return processed.toArray(optionsArray);
    }
}

