/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.MetaData;

public class AbstractConstraintMetaData
extends MetaData {
    protected String name;
    protected String table;
    protected List<String> memberNames = null;
    protected List<ColumnMetaData> columns = null;

    public AbstractConstraintMetaData() {
    }

    public AbstractConstraintMetaData(AbstractConstraintMetaData acmd) {
        super(null, acmd);
        this.name = acmd.name;
        this.table = acmd.table;
        if (acmd.memberNames != null) {
            for (String memberName : acmd.memberNames) {
                this.addMember(memberName);
            }
        }
        if (acmd.columns != null) {
            for (ColumnMetaData colmd : acmd.columns) {
                this.addColumn(new ColumnMetaData(colmd));
            }
        }
    }

    public void addMember(String memberName) {
        if (this.memberNames == null) {
            this.memberNames = new ArrayList<String>();
        }
        this.memberNames.add(memberName);
    }

    public void addColumn(ColumnMetaData colmd) {
        if (this.columns == null) {
            this.columns = new ArrayList<ColumnMetaData>();
        }
        this.columns.add(colmd);
        colmd.parent = this;
    }

    public ColumnMetaData newColumnMetaData() {
        ColumnMetaData colmd = new ColumnMetaData();
        this.addColumn(colmd);
        return colmd;
    }

    public final String[] getMemberNames() {
        if (this.memberNames == null) {
            return null;
        }
        return this.memberNames.toArray(new String[this.memberNames.size()]);
    }

    public final ColumnMetaData[] getColumnMetaData() {
        if (this.columns == null) {
            return null;
        }
        return this.columns.toArray(new ColumnMetaData[this.columns.size()]);
    }

    public int getNumberOfMembers() {
        return this.memberNames != null ? this.memberNames.size() : 0;
    }

    public int getNumberOfColumns() {
        return this.columns != null ? this.columns.size() : 0;
    }
}

