/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hack.resource;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.storm.hack.relocation.Relocator;
import org.apache.storm.hack.resource.ResourceTransformer;

public class ClojureTransformer
implements ResourceTransformer {
    private final HashMap<String, String> entries = new HashMap();

    @Override
    public boolean canTransformResource(String s) {
        return s.endsWith(".clj");
    }

    @Override
    public void processResource(String s, InputStream inputStream, List<Relocator> relocators) throws IOException {
        int b;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((b = inputStream.read()) != -1) {
            out.write(b);
        }
        String data = out.toString();
        for (Relocator rel : relocators) {
            data = rel.applyToSourceContent(data);
        }
        this.entries.put(s, data);
    }

    @Override
    public boolean hasTransformedResource() {
        return !this.entries.isEmpty();
    }

    @Override
    public void modifyOutputStream(JarOutputStream jarOut) throws IOException {
        for (String key : this.entries.keySet()) {
            jarOut.putNextEntry(new JarEntry(key));
            jarOut.write(this.entries.get(key).getBytes());
        }
    }
}

