/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.evaluators.config;

import org.apache.axiom.om.OMElement;
import org.apache.synapse.commons.evaluators.EvaluatorException;
import org.apache.synapse.commons.evaluators.config.AbstractEvaluatorSerializer;
import org.apache.synapse.commons.evaluators.source.HeaderTextRetriever;
import org.apache.synapse.commons.evaluators.source.ParameterTextRetriever;
import org.apache.synapse.commons.evaluators.source.PropertyTextRetriever;
import org.apache.synapse.commons.evaluators.source.SOAPEnvelopeTextRetriever;
import org.apache.synapse.commons.evaluators.source.SourceTextRetriever;

public abstract class TextProcessingEvaluatorSerializer
extends AbstractEvaluatorSerializer {
    protected void serializeSourceTextRetriever(SourceTextRetriever textRetriever, OMElement element) throws EvaluatorException {
        if (textRetriever instanceof HeaderTextRetriever) {
            element.addAttribute(fac.createOMAttribute("type", nullNS, "header"));
            this.addSourceAttribute(textRetriever.getSource(), element);
        } else if (textRetriever instanceof ParameterTextRetriever) {
            element.addAttribute(fac.createOMAttribute("type", nullNS, "param"));
            this.addSourceAttribute(textRetriever.getSource(), element);
        } else if (textRetriever instanceof PropertyTextRetriever) {
            element.addAttribute(fac.createOMAttribute("type", nullNS, "property"));
            this.addSourceAttribute(textRetriever.getSource(), element);
        } else if (textRetriever instanceof SOAPEnvelopeTextRetriever) {
            element.addAttribute(fac.createOMAttribute("type", nullNS, "soap"));
            this.addSourceAttribute(textRetriever.getSource(), element);
        } else {
            element.addAttribute(fac.createOMAttribute("type", nullNS, "url"));
            if (textRetriever.getSource() != null) {
                element.addAttribute(fac.createOMAttribute("source", nullNS, textRetriever.getSource()));
            }
        }
    }

    private void addSourceAttribute(String source, OMElement element) throws EvaluatorException {
        if (source == null) {
            String msg = "If type is not URL a source value should be specified for the evaluator";
            this.log.error((Object)msg);
            throw new EvaluatorException(msg);
        }
        element.addAttribute(fac.createOMAttribute("source", nullNS, source));
    }
}

