/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.attachments.ByteArrayDataSource;
import org.apache.axiom.attachments.ConfigurableDataHandler;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.OMMultipartWriter;
import org.apache.axiom.om.util.CommonUtils;
import org.apache.axiom.util.activation.DataHandlerWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MIMEOutputUtils {
    private static final Log log = LogFactory.getLog(MIMEOutputUtils.class);
    private static byte[] CRLF = new byte[]{13, 10};

    public static void complete(OutputStream outStream, byte[] xmlData, LinkedList binaryNodeList, String boundary, String contentId, String charSetEncoding, String SOAPContentType) {
        MIMEOutputUtils.complete(outStream, xmlData, binaryNodeList, boundary, contentId, charSetEncoding, SOAPContentType, null);
    }

    public static void complete(OutputStream outStream, byte[] xmlData, LinkedList binaryNodeList, String boundary, String contentId, String charSetEncoding, String SOAPContentType, OMOutputFormat omOutputFormat) {
        try {
            log.debug((Object)"Start: write the SOAPPart and the attachments");
            MIMEOutputUtils.startWritingMime(outStream, boundary);
            DataHandler dh = new DataHandler((DataSource)new ByteArrayDataSource(xmlData, "text/xml; charset=" + charSetEncoding));
            MimeBodyPart rootMimeBodyPart = new MimeBodyPart();
            rootMimeBodyPart.setDataHandler(dh);
            rootMimeBodyPart.addHeader("Content-Type", "application/xop+xml; charset=" + charSetEncoding + "; type=\"" + SOAPContentType + "\"");
            rootMimeBodyPart.addHeader("Content-Transfer-Encoding", "binary");
            rootMimeBodyPart.addHeader("Content-ID", "<" + contentId + ">");
            MIMEOutputUtils.writeBodyPart(outStream, rootMimeBodyPart, boundary);
            for (OMText binaryNode : binaryNodeList) {
                MIMEOutputUtils.writeBodyPart(outStream, MIMEOutputUtils.createMimeBodyPart(binaryNode.getContentID(), (DataHandler)binaryNode.getDataHandler(), omOutputFormat), boundary);
            }
            MIMEOutputUtils.finishWritingMime(outStream);
            outStream.flush();
            log.debug((Object)"End: write the SOAPPart and the attachments");
        }
        catch (IOException e) {
            throw new OMException("Error while writing to the OutputStream.", (Throwable)e);
        }
        catch (MessagingException e) {
            throw new OMException("Problem writing Mime Parts.", (Throwable)e);
        }
    }

    public static MimeBodyPart createMimeBodyPart(String contentID, DataHandler dataHandler) throws MessagingException {
        return MIMEOutputUtils.createMimeBodyPart(contentID, dataHandler, null);
    }

    public static MimeBodyPart createMimeBodyPart(String contentID, DataHandler dataHandler, OMOutputFormat omOutputFormat) throws MessagingException {
        boolean useCTEBase64;
        String contentType = dataHandler.getContentType();
        String contentTransferEncoding = "binary";
        if (dataHandler instanceof ConfigurableDataHandler) {
            ConfigurableDataHandler configurableDataHandler = (ConfigurableDataHandler)dataHandler;
            contentTransferEncoding = configurableDataHandler.getTransferEncoding();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Create MimeBodyPart");
            log.debug((Object)("  Content-ID = " + contentID));
            log.debug((Object)("  Content-Type = " + contentType));
            log.debug((Object)("  Content-Transfer-Encoding = " + contentTransferEncoding));
        }
        boolean bl = useCTEBase64 = omOutputFormat != null && Boolean.TRUE.equals(omOutputFormat.getProperty("org.apache.axiom.om.OMFormat.use.cteBase64.forNonTextualAttachments"));
        if (useCTEBase64 && !CommonUtils.isTextualPart((String)contentType) && "binary".equals(contentTransferEncoding)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(" changing Content-Transfer-Encoding from " + contentTransferEncoding + " to base-64"));
            }
            contentTransferEncoding = "base64";
        }
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setDataHandler(dataHandler);
        mimeBodyPart.addHeader("Content-ID", "<" + contentID + ">");
        mimeBodyPart.addHeader("Content-Type", contentType);
        mimeBodyPart.addHeader("Content-Transfer-Encoding", contentTransferEncoding);
        return mimeBodyPart;
    }

    public static void writeMimeBoundary(OutputStream outStream, String boundary) throws IOException {
        outStream.write(new byte[]{45, 45});
        outStream.write(boundary.getBytes("UTF-8"));
    }

    public static void startWritingMime(OutputStream outStream, String boundary) throws IOException {
        MIMEOutputUtils.writeMimeBoundary(outStream, boundary);
    }

    public static void writeBodyPart(OutputStream outStream, MimeBodyPart part, String boundary) throws IOException, MessagingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start writeMimeBodyPart for " + part.getContentID()));
        }
        outStream.write(CRLF);
        part.writeTo(outStream);
        outStream.write(CRLF);
        MIMEOutputUtils.writeMimeBoundary(outStream, boundary);
        outStream.flush();
        log.debug((Object)"End writeMimeBodyPart");
    }

    public static void finishWritingMime(OutputStream outStream) throws IOException {
        log.debug((Object)"Write --, which indicates the end of the last boundary");
        outStream.write(new byte[]{45, 45});
    }

    public static void writeSOAPWithAttachmentsMessage(StringWriter writer, OutputStream outputStream, Attachments attachments, OMOutputFormat format) {
        try {
            OMMultipartWriter mpw = new OMMultipartWriter(outputStream, format);
            OutputStreamWriter rootPartWriter = new OutputStreamWriter(mpw.writeRootPart(), format.getCharSetEncoding());
            rootPartWriter.write(writer.toString());
            ((Writer)rootPartWriter).close();
            List<String> ids = Arrays.asList(attachments.getAllContentIDs());
            for (String id : ids) {
                mpw.writePart(attachments.getDataHandler(id), id);
            }
            mpw.complete();
        }
        catch (IOException ex) {
            throw new OMException("Error writing SwA message", (Throwable)ex);
        }
    }

    public static void writeDataHandlerWithAttachmentsMessage(DataHandler rootDataHandler, String contentType, OutputStream outputStream, Map attachments, OMOutputFormat format) {
        MIMEOutputUtils.writeDataHandlerWithAttachmentsMessage(rootDataHandler, contentType, outputStream, attachments, format, null);
    }

    public static void writeDataHandlerWithAttachmentsMessage(DataHandler rootDataHandler, final String contentType, OutputStream outputStream, Map attachments, OMOutputFormat format, Collection ids) {
        try {
            if (!rootDataHandler.getContentType().equals(contentType)) {
                rootDataHandler = new DataHandlerWrapper((DataHandler)rootDataHandler){

                    public String getContentType() {
                        return contentType;
                    }
                };
            }
            OMMultipartWriter mpw = new OMMultipartWriter(outputStream, format);
            mpw.writePart(rootDataHandler, format.getRootContentId());
            Iterator<Object> idIterator = null;
            idIterator = ids == null ? attachments.keySet().iterator() : ids.iterator();
            while (idIterator.hasNext()) {
                String key = (String)idIterator.next();
                mpw.writePart((DataHandler)attachments.get(key), key);
            }
            mpw.complete();
            outputStream.flush();
        }
        catch (IOException e) {
            throw new OMException("Error while writing to the OutputStream.", (Throwable)e);
        }
    }

    public static void writeMM7Message(StringWriter writer, OutputStream outputStream, Attachments attachments, OMOutputFormat format, String innerPartCID, String innerBoundary) {
        try {
            OMMultipartWriter mpw = new OMMultipartWriter(outputStream, format);
            OutputStreamWriter rootPartWriter = new OutputStreamWriter(mpw.writeRootPart(), format.getCharSetEncoding());
            rootPartWriter.write(writer.toString());
            ((Writer)rootPartWriter).close();
            if (attachments.getContentIDSet().size() != 0) {
                OMOutputFormat innerFormat = new OMOutputFormat(format);
                innerFormat.setMimeBoundary(innerBoundary);
                OutputStream innerOutputStream = mpw.writePart("multipart/related; boundary=\"" + innerBoundary + "\"", innerPartCID);
                OMMultipartWriter innerMpw = new OMMultipartWriter(innerOutputStream, innerFormat);
                List<String> ids = Arrays.asList(attachments.getAllContentIDs());
                for (String id : ids) {
                    innerMpw.writePart(attachments.getDataHandler(id), id);
                }
                innerMpw.complete();
                innerOutputStream.close();
            }
            mpw.complete();
        }
        catch (IOException e) {
            throw new OMException("Error while writing to the OutputStream.", (Throwable)e);
        }
    }
}

