/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.SynapseException;
import org.apache.synapse.message.store.InMemoryMessageStore;
import org.apache.synapse.message.store.MessageStore;

public class MessageStoreSerializer {
    private static final Log log = LogFactory.getLog(MessageStoreSerializer.class);
    protected static final OMFactory fac = OMAbstractFactory.getOMFactory();
    protected static final OMNamespace synNS = SynapseConstants.SYNAPSE_OMNAMESPACE;
    protected static final OMNamespace nullNS = fac.createOMNamespace("", "");

    public static OMElement serializeMessageStore(OMElement parent, MessageStore messageStore) {
        OMElement store = fac.createOMElement("messageStore", synNS);
        if (messageStore != null) {
            if (!messageStore.getClass().getName().equals(InMemoryMessageStore.class.getName())) {
                store.addAttribute(fac.createOMAttribute("class", nullNS, messageStore.getClass().getName()));
            }
        } else {
            MessageStoreSerializer.handleException("Invalid MessageStore. Provider is required");
        }
        if (messageStore.getName() != null) {
            store.addAttribute(fac.createOMAttribute("name", nullNS, messageStore.getName()));
        } else {
            MessageStoreSerializer.handleException("Message store Name not specified");
        }
        if (messageStore.getParameters() != null) {
            for (String name : messageStore.getParameters().keySet()) {
                String value = (String)messageStore.getParameters().get(name);
                OMElement property = fac.createOMElement("parameter", synNS);
                property.addAttribute(fac.createOMAttribute("name", nullNS, name));
                property.setText(value.trim());
                store.addChild((OMNode)property);
            }
        }
        if (MessageStoreSerializer.getSerializedDescription(messageStore) != null) {
            store.addChild((OMNode)MessageStoreSerializer.getSerializedDescription(messageStore));
        }
        if (parent != null) {
            parent.addChild((OMNode)store);
        }
        return store;
    }

    private static OMElement getSerializedDescription(MessageStore messageStore) {
        OMElement descriptionElem = fac.createOMElement(new QName("http://ws.apache.org/ns/synapse", "description"));
        if (messageStore.getDescription() != null) {
            descriptionElem.setText(messageStore.getDescription());
            return descriptionElem;
        }
        return null;
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }
}

