/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.mapred;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.functionobjects.CM;
import org.apache.sysml.runtime.functionobjects.COV;
import org.apache.sysml.runtime.functionobjects.ValueFunction;
import org.apache.sysml.runtime.instructions.cp.CM_COV_Object;
import org.apache.sysml.runtime.instructions.cp.Data;
import org.apache.sysml.runtime.instructions.mr.CM_N_COVInstruction;
import org.apache.sysml.runtime.matrix.data.CM_N_COVCell;
import org.apache.sysml.runtime.matrix.data.MatrixCell;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.data.TaggedFirstSecondIndexes;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;
import org.apache.sysml.runtime.matrix.mapred.ReduceBase;
import org.apache.sysml.runtime.matrix.operators.CMOperator;
import org.apache.sysml.runtime.matrix.operators.COVOperator;

public class CMCOVMRReducer
extends ReduceBase
implements Reducer<TaggedFirstSecondIndexes, MatrixValue, MatrixIndexes, MatrixValue> {
    private CM_N_COVInstruction[] cmNcovInstructions = null;
    private CM_N_COVCell cmNcovCell = new CM_N_COVCell();
    private COV covFn = COV.getCOMFnObject();
    private HashMap<Byte, CM> cmFn = new HashMap();
    private MatrixIndexes outIndex = new MatrixIndexes(1L, 1L);
    private MatrixCell outCell = new MatrixCell();
    private HashMap<Byte, ArrayList<Integer>> outputIndexesMapping = new HashMap();
    protected HashSet<Byte> covTags = new HashSet();
    private CM_COV_Object zeroObj = null;
    protected HashMap<Byte, Long> rlens = null;
    protected HashMap<Byte, Long> clens = null;

    public void reduce(TaggedFirstSecondIndexes index, Iterator<MatrixValue> values, OutputCollector<MatrixIndexes, MatrixValue> out, Reporter report) throws IOException {
        this.commonSetup(report);
        this.cmNcovCell.setCM_N_COVObject(0.0, 0.0, 0.0);
        ValueFunction fn = this.cmFn.get(index.getTag());
        if (this.covTags.contains(index.getTag())) {
            fn = this.covFn;
        }
        while (values.hasNext()) {
            CM_N_COVCell cell = (CM_N_COVCell)values.next();
            try {
                fn.execute((Data)this.cmNcovCell.getCM_N_COVObject(), cell.getCM_N_COVObject());
            }
            catch (DMLRuntimeException e) {
                throw new IOException(e);
            }
        }
        long totaln = this.rlens.get(index.getTag()) * this.clens.get(index.getTag());
        long zerosToAdd = totaln - (long)this.cmNcovCell.getCM_N_COVObject().w;
        if (zerosToAdd > 0L) {
            this.zeroObj.w = zerosToAdd;
            try {
                fn.execute((Data)this.cmNcovCell.getCM_N_COVObject(), this.zeroObj);
            }
            catch (DMLRuntimeException e) {
                throw new IOException(e);
            }
        }
        for (CM_N_COVInstruction in : this.cmNcovInstructions) {
            if (in.input != index.getTag()) continue;
            try {
                this.outCell.setValue(this.cmNcovCell.getCM_N_COVObject().getRequiredResult(in.getOperator()));
            }
            catch (DMLRuntimeException e) {
                throw new IOException(e);
            }
            ArrayList<Integer> outputIndexes = this.outputIndexesMapping.get(in.output);
            for (int i : outputIndexes) {
                this.collectOutput_N_Increase_Counter(this.outIndex, this.outCell, i, report);
            }
        }
    }

    @Override
    public void configure(JobConf job) {
        super.configure(job);
        try {
            this.cmNcovInstructions = MRJobConfiguration.getCM_N_COVInstructions(job);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.rlens = new HashMap();
        this.clens = new HashMap();
        for (CM_N_COVInstruction ins : this.cmNcovInstructions) {
            if (ins.getOperator() instanceof COVOperator) {
                this.covTags.add(ins.input);
            } else {
                this.cmFn.put(ins.input, CM.getCMFnObject(((CMOperator)ins.getOperator()).getAggOpType()));
            }
            this.outputIndexesMapping.put(ins.output, this.getOutputIndexes(ins.output));
            this.rlens.put(ins.input, MRJobConfiguration.getNumRows(job, ins.input));
            this.clens.put(ins.input, MRJobConfiguration.getNumColumns(job, ins.input));
        }
        this.zeroObj = new CM_COV_Object();
        this.zeroObj.w = 1.0;
    }
}

