/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.mapred;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.mr.AggregateBinaryInstruction;
import org.apache.sysml.runtime.instructions.mr.AggregateInstruction;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.data.TaggedFirstSecondIndexes;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;
import org.apache.sysml.runtime.matrix.mapred.ReduceBase;
import org.apache.sysml.runtime.matrix.operators.AggregateOperator;

public class MMCJMRCombinerReducerBase
extends ReduceBase {
    protected AggregateBinaryInstruction aggBinInstruction = null;
    protected MatrixValue buffer = null;
    protected byte tagForLeft = 0;
    protected byte tagForRight = 1;
    protected MatrixCharacteristics dim1;
    protected MatrixCharacteristics dim2;

    @Override
    public void configure(JobConf job) {
        AggregateBinaryInstruction[] ins;
        super.configure(job);
        try {
            ins = MRJobConfiguration.getAggregateBinaryInstructions(job);
        }
        catch (DMLRuntimeException e) {
            throw new RuntimeException(e);
        }
        if (ins.length != 1) {
            throw new RuntimeException("MMCJ only perform one aggregate binary instruction");
        }
        this.aggBinInstruction = ins[0];
        this.dim1 = MRJobConfiguration.getMatrixCharactristicsForBinAgg(job, this.aggBinInstruction.input1);
        this.dim2 = MRJobConfiguration.getMatrixCharactristicsForBinAgg(job, this.aggBinInstruction.input2);
        if (this.dim1.getRows() > this.dim2.getCols()) {
            this.tagForLeft = 1;
            this.tagForRight = 0;
        }
        try {
            this.buffer = (MatrixValue)this.valueClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected MatrixValue performAggregateInstructions(TaggedFirstSecondIndexes indexes, Iterator<MatrixValue> values) throws IOException {
        AggregateInstruction ins;
        byte realTag = indexes.getTag();
        byte representTag = realTag == this.tagForLeft ? this.aggBinInstruction.input1 : this.aggBinInstruction.input2;
        ArrayList instructions = (ArrayList)this.agg_instructions.get(representTag);
        if (instructions == null) {
            this.defaultAggIns.input = realTag;
            this.defaultAggIns.output = realTag;
            ins = this.defaultAggIns;
        } else {
            if (instructions.size() > 1) {
                throw new IOException("only one aggregate operation on input " + indexes.getTag() + " is allowed in BlockMMCJMR");
            }
            ins = (AggregateInstruction)instructions.get(0);
            if (ins.input != ins.output) {
                throw new IOException("input index and output index have to be the same for aggregate instructions in BlockMMCJMR");
            }
        }
        boolean needStartAgg = true;
        try {
            while (values.hasNext()) {
                MatrixValue value = values.next();
                if (needStartAgg) {
                    this.buffer.reset(value.getNumRows(), value.getNumColumns(), value.isInSparseFormat());
                    needStartAgg = false;
                }
                this.buffer.binaryOperationsInPlace(((AggregateOperator)ins.getOperator()).increOp, value);
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        if (needStartAgg) {
            return null;
        }
        return this.buffer;
    }
}

