/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.fed;

import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.FederationMap;
import org.apache.sysds.runtime.controlprogram.federated.FederationUtils;
import org.apache.sysds.runtime.functionobjects.OffsetColumnIndex;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.fed.BinaryFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.FEDInstruction;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.matrix.operators.ReorgOperator;
import org.apache.sysds.runtime.meta.DataCharacteristics;

public class AppendFEDInstruction
extends BinaryFEDInstruction {
    protected boolean _cbind;

    protected AppendFEDInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, boolean cbind, String opcode, String istr) {
        super(FEDInstruction.FEDType.Append, op, in1, in2, out, opcode, istr);
        this._cbind = cbind;
    }

    public static AppendFEDInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(parts, 6, 5, 4);
        String opcode = parts[0];
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand in2 = new CPOperand(parts[2]);
        CPOperand out = new CPOperand(parts[parts.length - 2]);
        boolean cbind = Boolean.parseBoolean(parts[parts.length - 1]);
        ReorgOperator op = new ReorgOperator(OffsetColumnIndex.getOffsetColumnIndexFnObject(-1));
        return new AppendFEDInstruction(op, in1, in2, out, cbind, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        MatrixObject mo1 = ec.getMatrixObject(this.input1.getName());
        MatrixObject mo2 = ec.getMatrixObject(this.input2.getName());
        DataCharacteristics dc1 = mo1.getDataCharacteristics();
        DataCharacteristics dc2 = mo1.getDataCharacteristics();
        if (this._cbind && mo1.getNumRows() != mo2.getNumRows()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Append-cbind is not possible for federated input matrices ");
            sb.append(this.input1.getName()).append(" and ").append(this.input2.getName());
            sb.append(" with different number of rows: ");
            sb.append(mo1.getNumRows()).append(" vs ").append(mo2.getNumRows());
            throw new DMLRuntimeException(sb.toString());
        }
        if (!this._cbind && mo1.getNumColumns() != mo2.getNumColumns()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Append-rbind is not possible for federated input matrices ");
            sb.append(this.input1.getName()).append(" and ").append(this.input2.getName());
            sb.append(" with different number of columns: ");
            sb.append(mo1.getNumColumns()).append(" vs ").append(mo2.getNumColumns());
            throw new DMLRuntimeException(sb.toString());
        }
        FederationMap fm1 = mo1.isFederated() ? mo1.getFedMapping() : FederationUtils.federateLocalData(mo1);
        FederationMap fm2 = mo2.isFederated() ? mo2.getFedMapping() : FederationUtils.federateLocalData(mo2);
        MatrixObject out = ec.getMatrixObject(this.output);
        long id = FederationUtils.getNextFedDataID();
        if (this._cbind) {
            out.getDataCharacteristics().set(dc1.getRows(), dc1.getCols() + dc2.getCols(), dc1.getBlocksize(), dc1.getNonZeros() + dc2.getNonZeros());
            out.setFedMapping(fm1.identCopy(this.getTID(), id).bind(0L, dc1.getCols(), fm2.identCopy(this.getTID(), id)));
        } else {
            out.getDataCharacteristics().set(dc1.getRows() + dc2.getRows(), dc1.getCols(), dc1.getBlocksize(), dc1.getNonZeros() + dc2.getNonZeros());
            out.setFedMapping(fm1.identCopy(this.getTID(), id).bind(dc1.getRows(), 0L, fm2.identCopy(this.getTID(), id)));
        }
    }
}

