/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.privacy.propagation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.Instruction;
import org.apache.sysds.runtime.instructions.cp.AggregateBinaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.AggregateUnaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.BinaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.BuiltinNaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.ComputationCPInstruction;
import org.apache.sysds.runtime.instructions.cp.CovarianceCPInstruction;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.FunctionCallCPInstruction;
import org.apache.sysds.runtime.instructions.cp.MultiReturnBuiltinCPInstruction;
import org.apache.sysds.runtime.instructions.cp.MultiReturnParameterizedBuiltinCPInstruction;
import org.apache.sysds.runtime.instructions.cp.ParameterizedBuiltinCPInstruction;
import org.apache.sysds.runtime.instructions.cp.QuaternaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.SqlCPInstruction;
import org.apache.sysds.runtime.instructions.cp.UnaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.VariableCPInstruction;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.privacy.DMLPrivacyException;
import org.apache.sysds.runtime.privacy.PrivacyConstraint;
import org.apache.sysds.runtime.privacy.propagation.MatrixMultiplicationPropagatorPrivateFirst;
import org.apache.sysds.runtime.privacy.propagation.OperatorType;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;

public class PrivacyPropagator {
    public static Data parseAndSetPrivacyConstraint(Data cd, JSONObject mtd) throws JSONException {
        String privacyLevel;
        if (mtd.containsKey("privacy") && (privacyLevel = mtd.getString("privacy")) != null) {
            cd.setPrivacyConstraints(new PrivacyConstraint(PrivacyConstraint.PrivacyLevel.valueOf(privacyLevel)));
        }
        return cd;
    }

    private static boolean anyInputHasLevel(PrivacyConstraint.PrivacyLevel[] inputLevels, PrivacyConstraint.PrivacyLevel targetLevel) {
        return Arrays.stream(inputLevels).anyMatch(i -> i == targetLevel);
    }

    public static PrivacyConstraint.PrivacyLevel corePropagation(PrivacyConstraint.PrivacyLevel[] inputLevels, OperatorType operatorType) {
        if (PrivacyPropagator.anyInputHasLevel(inputLevels, PrivacyConstraint.PrivacyLevel.Private)) {
            return PrivacyConstraint.PrivacyLevel.Private;
        }
        if (operatorType == OperatorType.Aggregate) {
            return PrivacyConstraint.PrivacyLevel.None;
        }
        if (operatorType == OperatorType.NonAggregate && PrivacyPropagator.anyInputHasLevel(inputLevels, PrivacyConstraint.PrivacyLevel.PrivateAggregation)) {
            return PrivacyConstraint.PrivacyLevel.PrivateAggregation;
        }
        return PrivacyConstraint.PrivacyLevel.None;
    }

    public static PrivacyConstraint mergeNary(PrivacyConstraint[] privacyConstraints, OperatorType operatorType) {
        PrivacyConstraint.PrivacyLevel[] privacyLevels = (PrivacyConstraint.PrivacyLevel[])Arrays.stream(privacyConstraints).map(constraint -> {
            if (constraint != null) {
                return constraint.getPrivacyLevel();
            }
            return PrivacyConstraint.PrivacyLevel.None;
        }).toArray(PrivacyConstraint.PrivacyLevel[]::new);
        PrivacyConstraint.PrivacyLevel outputPrivacyLevel = PrivacyPropagator.corePropagation(privacyLevels, operatorType);
        return new PrivacyConstraint(outputPrivacyLevel);
    }

    public static PrivacyConstraint mergeBinary(PrivacyConstraint privacyConstraint1, PrivacyConstraint privacyConstraint2) {
        if (privacyConstraint1 != null && privacyConstraint2 != null) {
            PrivacyConstraint.PrivacyLevel privacyLevel1 = privacyConstraint1.getPrivacyLevel();
            PrivacyConstraint.PrivacyLevel privacyLevel2 = privacyConstraint2.getPrivacyLevel();
            if (privacyLevel1 == PrivacyConstraint.PrivacyLevel.Private || privacyLevel2 == PrivacyConstraint.PrivacyLevel.Private) {
                return new PrivacyConstraint(PrivacyConstraint.PrivacyLevel.Private);
            }
            if (privacyLevel1 == PrivacyConstraint.PrivacyLevel.PrivateAggregation || privacyLevel2 == PrivacyConstraint.PrivacyLevel.PrivateAggregation) {
                return new PrivacyConstraint(PrivacyConstraint.PrivacyLevel.PrivateAggregation);
            }
            return null;
        }
        if (privacyConstraint1 != null) {
            return privacyConstraint1;
        }
        if (privacyConstraint2 != null) {
            return privacyConstraint2;
        }
        return null;
    }

    public static PrivacyConstraint mergeNary(PrivacyConstraint[] privacyConstraints) {
        PrivacyConstraint mergedPrivacyConstraint = privacyConstraints[0];
        for (int i = 1; i < privacyConstraints.length; ++i) {
            mergedPrivacyConstraint = PrivacyPropagator.mergeBinary(mergedPrivacyConstraint, privacyConstraints[i]);
        }
        return mergedPrivacyConstraint;
    }

    public static Instruction preprocessInstruction(Instruction inst, ExecutionContext ec) {
        switch (inst.getType()) {
            case CONTROL_PROGRAM: {
                return PrivacyPropagator.preprocessCPInstructionFineGrained((CPInstruction)inst, ec);
            }
            case BREAKPOINT: 
            case SPARK: 
            case GPU: 
            case FEDERATED: {
                return inst;
            }
        }
        PrivacyPropagator.throwExceptionIfPrivacyActivated(inst);
        return inst;
    }

    public static Instruction preprocessCPInstructionFineGrained(CPInstruction inst, ExecutionContext ec) {
        switch (inst.getCPInstructionType()) {
            case AggregateBinary: {
                if (inst instanceof AggregateBinaryCPInstruction) {
                    return PrivacyPropagator.preprocessAggregateBinaryCPInstruction((AggregateBinaryCPInstruction)inst, ec);
                }
                if (inst instanceof CovarianceCPInstruction) {
                    return PrivacyPropagator.preprocessCovarianceCPInstruction((CovarianceCPInstruction)inst, ec);
                }
                PrivacyPropagator.preprocessInstructionSimple(inst, ec);
            }
            case AggregateTernary: {
                return PrivacyPropagator.preprocessTernaryCPInstruction((ComputationCPInstruction)inst, ec);
            }
            case AggregateUnary: {
                return PrivacyPropagator.preprocessAggregateUnaryCPInstruction((AggregateUnaryCPInstruction)inst, ec);
            }
            case Append: 
            case Binary: {
                return PrivacyPropagator.preprocessBinaryCPInstruction((BinaryCPInstruction)inst, ec);
            }
            case Builtin: 
            case BuiltinNary: {
                return PrivacyPropagator.preprocessBuiltinNary((BuiltinNaryCPInstruction)inst, ec);
            }
            case FCall: {
                return PrivacyPropagator.preprocessExternal((FunctionCallCPInstruction)inst, ec);
            }
            case MultiReturnBuiltin: 
            case MultiReturnParameterizedBuiltin: {
                return PrivacyPropagator.preprocessMultiReturn((ComputationCPInstruction)inst, ec);
            }
            case ParameterizedBuiltin: {
                return PrivacyPropagator.preprocessParameterizedBuiltin((ParameterizedBuiltinCPInstruction)inst, ec);
            }
            case Quaternary: {
                return PrivacyPropagator.preprocessQuaternary((QuaternaryCPInstruction)inst, ec);
            }
            case Reorg: {
                return PrivacyPropagator.preprocessUnaryCPInstruction((UnaryCPInstruction)inst, ec);
            }
            case Ternary: {
                return PrivacyPropagator.preprocessTernaryCPInstruction((ComputationCPInstruction)inst, ec);
            }
            case Unary: {
                return PrivacyPropagator.preprocessUnaryCPInstruction((UnaryCPInstruction)inst, ec);
            }
            case Variable: {
                return PrivacyPropagator.preprocessVariableCPInstruction((VariableCPInstruction)inst, ec);
            }
        }
        return PrivacyPropagator.preprocessInstructionSimple(inst, ec);
    }

    private static Instruction preprocessCovarianceCPInstruction(CovarianceCPInstruction inst, ExecutionContext ec) {
        PrivacyPropagator.throwExceptionIfPrivacyActivated(inst);
        for (CPOperand input : inst.getInputs()) {
            PrivacyConstraint privacyConstraint = PrivacyPropagator.getInputPrivacyConstraint(ec, input);
            if (privacyConstraint == null) continue;
            throw new DMLPrivacyException("Input of instruction " + inst + " has privacy constraints activated, but the constraints are not propagated during preprocessing of instruction.");
        }
        return inst;
    }

    private static Instruction preprocessAggregateBinaryCPInstruction(AggregateBinaryCPInstruction inst, ExecutionContext ec) {
        PrivacyConstraint privacyConstraint1 = PrivacyPropagator.getInputPrivacyConstraint(ec, inst.input1);
        PrivacyConstraint privacyConstraint2 = PrivacyPropagator.getInputPrivacyConstraint(ec, inst.input2);
        if (privacyConstraint1 != null && privacyConstraint1.hasConstraints() || privacyConstraint2 != null && privacyConstraint2.hasConstraints()) {
            PrivacyConstraint mergedPrivacyConstraint;
            if (privacyConstraint1 != null && privacyConstraint1.hasFineGrainedConstraints() || privacyConstraint2 != null && privacyConstraint2.hasFineGrainedConstraints()) {
                MatrixBlock input1 = ec.getMatrixInput(inst.input1.getName());
                MatrixBlock input2 = ec.getMatrixInput(inst.input2.getName());
                MatrixMultiplicationPropagatorPrivateFirst propagator = new MatrixMultiplicationPropagatorPrivateFirst(input1, privacyConstraint1, input2, privacyConstraint2);
                mergedPrivacyConstraint = propagator.propagate();
            } else {
                mergedPrivacyConstraint = PrivacyPropagator.mergeNary(new PrivacyConstraint[]{privacyConstraint1, privacyConstraint2}, OperatorType.NonAggregate);
                inst.setPrivacyConstraint(mergedPrivacyConstraint);
            }
            inst.output.setPrivacyConstraint(mergedPrivacyConstraint);
        }
        return inst;
    }

    public static Instruction preprocessBinaryCPInstruction(BinaryCPInstruction inst, ExecutionContext ec) {
        PrivacyConstraint privacyConstraint1 = PrivacyPropagator.getInputPrivacyConstraint(ec, inst.input1);
        PrivacyConstraint privacyConstraint2 = PrivacyPropagator.getInputPrivacyConstraint(ec, inst.input2);
        if (privacyConstraint1 != null || privacyConstraint2 != null) {
            PrivacyConstraint mergedPrivacyConstraint = PrivacyPropagator.mergeBinary(privacyConstraint1, privacyConstraint2);
            inst.setPrivacyConstraint(mergedPrivacyConstraint);
            inst.output.setPrivacyConstraint(mergedPrivacyConstraint);
        }
        return inst;
    }

    private static Instruction preprocessAggregateUnaryCPInstruction(AggregateUnaryCPInstruction inst, ExecutionContext ec) {
        PrivacyConstraint privacyConstraint = PrivacyPropagator.getInputPrivacyConstraint(ec, inst.input1);
        if (privacyConstraint != null) {
            inst.setPrivacyConstraint(privacyConstraint);
            if (inst.output != null && privacyConstraint.hasPrivateElements()) {
                inst.output.setPrivacyConstraint(new PrivacyConstraint(PrivacyConstraint.PrivacyLevel.Private));
            }
        }
        return inst;
    }

    public static Instruction preprocessInstructionSimple(Instruction inst, ExecutionContext ec) {
        PrivacyPropagator.throwExceptionIfPrivacyActivated(inst);
        return inst;
    }

    public static Instruction preprocessExternal(FunctionCallCPInstruction inst, ExecutionContext ec) {
        return PrivacyPropagator.mergePrivacyConstraintsFromInput((Instruction)inst, ec, inst.getInputs(), inst.getBoundOutputParamNames().toArray(new String[0]));
    }

    public static Instruction preprocessMultiReturn(ComputationCPInstruction inst, ExecutionContext ec) {
        List<CPOperand> outputs = PrivacyPropagator.getOutputOperands(inst);
        return PrivacyPropagator.mergePrivacyConstraintsFromInput((Instruction)inst, ec, inst.getInputs(), outputs);
    }

    public static Instruction preprocessParameterizedBuiltin(ParameterizedBuiltinCPInstruction inst, ExecutionContext ec) {
        return PrivacyPropagator.mergePrivacyConstraintsFromInput((Instruction)inst, ec, inst.getInputs(), inst.getOutput());
    }

    private static Instruction mergePrivacyConstraintsFromInput(Instruction inst, ExecutionContext ec, CPOperand[] inputs, String[] outputNames) {
        PrivacyConstraint[] privacyConstraints;
        if (inputs != null && inputs.length > 0 && (privacyConstraints = PrivacyPropagator.getInputPrivacyConstraints(ec, inputs)) != null) {
            PrivacyConstraint mergedPrivacyConstraint = PrivacyPropagator.mergeNary(privacyConstraints);
            inst.setPrivacyConstraint(mergedPrivacyConstraint);
            if (outputNames != null) {
                for (String outputName : outputNames) {
                    PrivacyPropagator.setOutputPrivacyConstraint(ec, mergedPrivacyConstraint, outputName);
                }
            }
        }
        return inst;
    }

    private static Instruction mergePrivacyConstraintsFromInput(Instruction inst, ExecutionContext ec, CPOperand[] inputs, CPOperand output) {
        return PrivacyPropagator.mergePrivacyConstraintsFromInput(inst, ec, inputs, PrivacyPropagator.getSingletonList(output));
    }

    private static Instruction mergePrivacyConstraintsFromInput(Instruction inst, ExecutionContext ec, CPOperand[] inputs, List<CPOperand> outputs) {
        PrivacyConstraint[] privacyConstraints;
        if (inputs != null && inputs.length > 0 && (privacyConstraints = PrivacyPropagator.getInputPrivacyConstraints(ec, inputs)) != null) {
            PrivacyConstraint mergedPrivacyConstraint = PrivacyPropagator.mergeNary(privacyConstraints);
            inst.setPrivacyConstraint(mergedPrivacyConstraint);
            for (CPOperand output : outputs) {
                if (output == null) continue;
                output.setPrivacyConstraint(mergedPrivacyConstraint);
            }
        }
        return inst;
    }

    public static Instruction preprocessBuiltinNary(BuiltinNaryCPInstruction inst, ExecutionContext ec) {
        return PrivacyPropagator.mergePrivacyConstraintsFromInput((Instruction)inst, ec, inst.getInputs(), inst.getOutput());
    }

    public static Instruction preprocessQuaternary(QuaternaryCPInstruction inst, ExecutionContext ec) {
        return PrivacyPropagator.mergePrivacyConstraintsFromInput((Instruction)inst, ec, new CPOperand[]{inst.input1, inst.input2, inst.input3, inst.getInput4()}, inst.output);
    }

    public static Instruction preprocessTernaryCPInstruction(ComputationCPInstruction inst, ExecutionContext ec) {
        return PrivacyPropagator.mergePrivacyConstraintsFromInput((Instruction)inst, ec, inst.getInputs(), inst.output);
    }

    public static Instruction preprocessUnaryCPInstruction(UnaryCPInstruction inst, ExecutionContext ec) {
        return PrivacyPropagator.propagateInputPrivacy(inst, ec, inst.input1, inst.output);
    }

    public static Instruction preprocessVariableCPInstruction(VariableCPInstruction inst, ExecutionContext ec) {
        switch (inst.getVariableOpcode()) {
            case CreateVariable: {
                return PrivacyPropagator.propagateSecondInputPrivacy(inst, ec);
            }
            case AssignVariable: {
                return PrivacyPropagator.propagateInputPrivacy(inst, ec, inst.getInput1(), inst.getInput2());
            }
            case CopyVariable: 
            case MoveVariable: 
            case RemoveVariableAndFile: 
            case CastAsMatrixVariable: 
            case CastAsFrameVariable: 
            case Write: 
            case SetFileName: {
                return PrivacyPropagator.propagateFirstInputPrivacy(inst, ec);
            }
            case RemoveVariable: {
                return PrivacyPropagator.propagateAllInputPrivacy(inst, ec);
            }
            case CastAsScalarVariable: 
            case CastAsDoubleVariable: 
            case CastAsIntegerVariable: 
            case CastAsBooleanVariable: {
                return PrivacyPropagator.propagateCastAsScalarVariablePrivacy(inst, ec);
            }
            case Read: {
                return inst;
            }
        }
        PrivacyPropagator.throwExceptionIfPrivacyActivated(inst);
        return inst;
    }

    private static void throwExceptionIfPrivacyActivated(Instruction inst) {
        if (inst.getPrivacyConstraint() != null && inst.getPrivacyConstraint().hasConstraints()) {
            throw new DMLPrivacyException("Instruction " + inst + " has privacy constraints activated, but the constraints are not propagated during preprocessing of instruction.");
        }
    }

    private static Instruction propagateCastAsScalarVariablePrivacy(VariableCPInstruction inst, ExecutionContext ec) {
        inst = (VariableCPInstruction)PrivacyPropagator.propagateFirstInputPrivacy(inst, ec);
        return inst;
    }

    private static Instruction propagateAllInputPrivacy(VariableCPInstruction inst, ExecutionContext ec) {
        return PrivacyPropagator.mergePrivacyConstraintsFromInput((Instruction)inst, ec, inst.getInputs().toArray(new CPOperand[0]), inst.getOutput());
    }

    private static Instruction propagateFirstInputPrivacy(VariableCPInstruction inst, ExecutionContext ec) {
        return PrivacyPropagator.propagateInputPrivacy(inst, ec, inst.getInput1(), inst.getOutput());
    }

    private static Instruction propagateSecondInputPrivacy(VariableCPInstruction inst, ExecutionContext ec) {
        return PrivacyPropagator.propagateInputPrivacy(inst, ec, inst.getInput2(), inst.getOutput());
    }

    private static Instruction propagateInputPrivacy(Instruction inst, ExecutionContext ec, CPOperand inputOperand, CPOperand outputOperand) {
        PrivacyConstraint privacyConstraint = PrivacyPropagator.getInputPrivacyConstraint(ec, inputOperand);
        if (privacyConstraint != null) {
            inst.setPrivacyConstraint(privacyConstraint);
            if (outputOperand != null) {
                outputOperand.setPrivacyConstraint(privacyConstraint);
            }
        }
        return inst;
    }

    private static PrivacyConstraint getInputPrivacyConstraint(ExecutionContext ec, CPOperand input) {
        Data dd;
        if (input != null && input.getName() != null && (dd = ec.getVariable(input.getName())) != null) {
            return dd.getPrivacyConstraint();
        }
        return null;
    }

    private static PrivacyConstraint[] getInputPrivacyConstraints(ExecutionContext ec, CPOperand[] inputs) {
        if (inputs != null && inputs.length > 0) {
            boolean privacyFound = false;
            PrivacyConstraint[] privacyConstraints = new PrivacyConstraint[inputs.length];
            for (int i = 0; i < inputs.length; ++i) {
                privacyConstraints[i] = PrivacyPropagator.getInputPrivacyConstraint(ec, inputs[i]);
                if (privacyConstraints[i] == null) continue;
                privacyFound = true;
            }
            if (privacyFound) {
                return privacyConstraints;
            }
        }
        return null;
    }

    private static void setOutputPrivacyConstraint(ExecutionContext ec, PrivacyConstraint privacyConstraint, String outputName) {
        Data dd;
        if (privacyConstraint != null && (dd = ec.getVariable(outputName)) != null) {
            dd.setPrivacyConstraints(privacyConstraint);
            ec.setVariable(outputName, dd);
        }
    }

    public static void postProcessInstruction(Instruction inst, ExecutionContext ec) {
        List<CPOperand> instOutputs = PrivacyPropagator.getOutputOperands(inst);
        if (!instOutputs.isEmpty()) {
            for (CPOperand output : instOutputs) {
                PrivacyConstraint outputPrivacyConstraint = output.getPrivacyConstraint();
                if (!PrivacyPropagator.privacyConstraintActivated(outputPrivacyConstraint)) continue;
                PrivacyPropagator.setOutputPrivacyConstraint(ec, outputPrivacyConstraint, output.getName());
            }
        }
    }

    private static boolean privacyConstraintActivated(PrivacyConstraint instructionPrivacyConstraint) {
        return instructionPrivacyConstraint != null && (instructionPrivacyConstraint.getPrivacyLevel() == PrivacyConstraint.PrivacyLevel.Private || instructionPrivacyConstraint.getPrivacyLevel() == PrivacyConstraint.PrivacyLevel.PrivateAggregation);
    }

    private static String[] getOutputVariableName(Instruction inst) {
        String[] instructionOutputNames = null;
        if (inst instanceof MultiReturnParameterizedBuiltinCPInstruction) {
            instructionOutputNames = ((MultiReturnParameterizedBuiltinCPInstruction)inst).getOutputNames();
        } else if (inst instanceof MultiReturnBuiltinCPInstruction) {
            instructionOutputNames = ((MultiReturnBuiltinCPInstruction)inst).getOutputNames();
        } else if (inst instanceof ComputationCPInstruction) {
            instructionOutputNames = new String[]{((ComputationCPInstruction)inst).getOutputVariableName()};
        } else if (inst instanceof VariableCPInstruction) {
            instructionOutputNames = new String[]{((VariableCPInstruction)inst).getOutputVariableName()};
        } else if (inst instanceof SqlCPInstruction) {
            instructionOutputNames = new String[]{((SqlCPInstruction)inst).getOutputVariableName()};
        }
        return instructionOutputNames;
    }

    private static List<CPOperand> getOutputOperands(Instruction inst) {
        if (inst instanceof MultiReturnParameterizedBuiltinCPInstruction) {
            return ((MultiReturnParameterizedBuiltinCPInstruction)inst).getOutputs();
        }
        if (inst instanceof MultiReturnBuiltinCPInstruction) {
            return ((MultiReturnBuiltinCPInstruction)inst).getOutputs();
        }
        if (inst instanceof ComputationCPInstruction) {
            return PrivacyPropagator.getSingletonList(((ComputationCPInstruction)inst).getOutput());
        }
        if (inst instanceof VariableCPInstruction) {
            return PrivacyPropagator.getSingletonList(((VariableCPInstruction)inst).getOutput());
        }
        if (inst instanceof SqlCPInstruction) {
            return PrivacyPropagator.getSingletonList(((SqlCPInstruction)inst).getOutput());
        }
        return new ArrayList<CPOperand>();
    }

    private static List<CPOperand> getSingletonList(CPOperand operand) {
        if (operand != null) {
            return new ArrayList<CPOperand>(Collections.singletonList(operand));
        }
        return new ArrayList<CPOperand>();
    }
}

