/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.transform.encode;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.sysds.runtime.matrix.data.FrameBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.transform.TfUtils;
import org.apache.sysds.runtime.transform.encode.Encoder;
import org.apache.sysds.runtime.transform.meta.TfMetaUtils;
import org.apache.sysds.runtime.util.IndexRange;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;

public class EncoderRecode
extends Encoder {
    private static final long serialVersionUID = 8213163881283341874L;
    private HashMap<Integer, HashMap<String, Long>> _rcdMaps = new HashMap();
    private HashMap<Integer, HashSet<Object>> _rcdMapsPart = null;

    public EncoderRecode(JSONObject parsedSpec, String[] colnames, int clen, int minCol, int maxCol) throws JSONException {
        super(null, clen);
        this._colList = TfMetaUtils.parseJsonIDList(parsedSpec, colnames, TfUtils.TfMethod.RECODE.toString(), minCol, maxCol);
    }

    private EncoderRecode(int[] colList, int clen) {
        super(colList, clen);
    }

    public EncoderRecode() {
        this(new int[0], 0);
    }

    private EncoderRecode(int[] colList, int clen, HashMap<Integer, HashMap<String, Long>> rcdMaps) {
        super(colList, clen);
        this._rcdMaps = rcdMaps;
    }

    public HashMap<Integer, HashMap<String, Long>> getCPRecodeMaps() {
        return this._rcdMaps;
    }

    public HashMap<Integer, HashSet<Object>> getCPRecodeMapsPartial() {
        return this._rcdMapsPart;
    }

    private long lookupRCDMap(int colID, String key) {
        if (!this._rcdMaps.containsKey(colID)) {
            return -1L;
        }
        Long tmp = this._rcdMaps.get(colID).get(key);
        return tmp != null ? tmp : -1L;
    }

    @Override
    public MatrixBlock encode(FrameBlock in, MatrixBlock out) {
        if (!this.isApplicable()) {
            return out;
        }
        this.build(in);
        this.apply(in, out);
        return out;
    }

    @Override
    public void build(FrameBlock in) {
        if (!this.isApplicable()) {
            return;
        }
        Iterator<String[]> iter = in.getStringRowIterator(this._colList);
        while (iter.hasNext()) {
            String[] row = iter.next();
            for (int j = 0; j < this._colList.length; ++j) {
                int colID = this._colList[j];
                if (!this._rcdMaps.containsKey(colID)) {
                    this._rcdMaps.put(colID, new HashMap());
                }
                HashMap<String, Long> map = this._rcdMaps.get(colID);
                String key = row[j];
                if (key == null || key.isEmpty() || map.containsKey(key)) continue;
                this.putCode(map, key);
            }
        }
    }

    protected void putCode(HashMap<String, Long> map, String key) {
        map.put(key, Long.valueOf(map.size() + 1));
    }

    public void prepareBuildPartial() {
        if (this._rcdMapsPart == null) {
            this._rcdMapsPart = new HashMap();
        }
    }

    public void buildPartial(FrameBlock in) {
        if (!this.isApplicable()) {
            return;
        }
        for (int j = 0; j < this._colList.length; ++j) {
            int colID = this._colList[j];
            if (!this._rcdMapsPart.containsKey(colID)) {
                this._rcdMapsPart.put(colID, new HashSet());
            }
            HashSet<Object> map = this._rcdMapsPart.get(colID);
            for (int i = 0; i < in.getNumRows(); ++i) {
                map.add(in.get(i, colID - 1));
            }
            map.remove(null);
            map.remove("");
        }
    }

    @Override
    public MatrixBlock apply(FrameBlock in, MatrixBlock out) {
        for (int j = 0; j < this._colList.length; ++j) {
            int colID = this._colList[j];
            for (int i = 0; i < in.getNumRows(); ++i) {
                Object okey = in.get(i, colID - 1);
                String key = okey != null ? okey.toString() : null;
                long code = this.lookupRCDMap(colID, key);
                out.quickSetValue(i, colID - 1, code >= 0L ? (double)code : Double.NaN);
            }
        }
        return out;
    }

    @Override
    public Encoder subRangeEncoder(IndexRange ixRange) {
        ArrayList<Integer> cols = new ArrayList<Integer>();
        HashMap<Integer, HashMap<String, Long>> rcdMaps = new HashMap<Integer, HashMap<String, Long>>();
        for (int col : this._colList) {
            if (!ixRange.inColRange(col)) continue;
            int corrColumn = (int)((long)col - (ixRange.colStart - 1L));
            cols.add(corrColumn);
            rcdMaps.put(corrColumn, new HashMap(this._rcdMaps.get(col)));
        }
        if (cols.isEmpty()) {
            return null;
        }
        int[] colList = cols.stream().mapToInt(i -> i).toArray();
        return new EncoderRecode(colList, (int)ixRange.colSpan(), rcdMaps);
    }

    @Override
    public void mergeAt(Encoder other, int row, int col) {
        if (other instanceof EncoderRecode) {
            this.mergeColumnInfo(other, col);
            EncoderRecode otherRec = (EncoderRecode)other;
            for (int otherColID : other._colList) {
                HashMap<String, Long> otherMap;
                int colID = otherColID + col - 1;
                if (!this._rcdMaps.containsKey(colID)) {
                    this._rcdMaps.put(colID, new HashMap());
                }
                if ((otherMap = otherRec._rcdMaps.get(otherColID)) == null) continue;
                for (Map.Entry<String, Long> entry : otherMap.entrySet()) {
                    if (this.lookupRCDMap(colID, entry.getKey()) != -1L) continue;
                    this.putCode(this._rcdMaps.get(colID), entry.getKey());
                }
            }
            return;
        }
        super.mergeAt(other, row, col);
    }

    public int[] numDistinctValues() {
        int[] numDistinct = new int[this._colList.length];
        for (int j = 0; j < this._colList.length; ++j) {
            int colID = this._colList[j];
            numDistinct[j] = this._rcdMaps.get(colID).size();
        }
        return numDistinct;
    }

    @Override
    public FrameBlock getMetaData(FrameBlock meta) {
        if (!this.isApplicable()) {
            return meta;
        }
        int maxDistinct = 0;
        for (int j = 0; j < this._colList.length; ++j) {
            if (!this._rcdMaps.containsKey(this._colList[j])) continue;
            maxDistinct = Math.max(maxDistinct, this._rcdMaps.get(this._colList[j]).size());
        }
        meta.ensureAllocatedColumns(maxDistinct);
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < this._colList.length; ++j) {
            int colID = this._colList[j];
            int rowID = 0;
            if (this._rcdMaps.containsKey(this._colList[j])) {
                for (Map.Entry<String, Long> e : this._rcdMaps.get(colID).entrySet()) {
                    meta.set(rowID++, colID - 1, EncoderRecode.constructRecodeMapEntry(e.getKey(), e.getValue(), sb));
                }
            }
            meta.getColumnMetadata(colID - 1).setNumDistinct(this._rcdMaps.get(colID).size());
        }
        return meta;
    }

    @Override
    public void initMetaData(FrameBlock meta) {
        if (meta == null || meta.getNumRows() <= 0) {
            return;
        }
        for (int j = 0; j < this._colList.length; ++j) {
            int colID = this._colList[j];
            this._rcdMaps.put(colID, meta.getRecodeMap(colID - 1));
        }
    }

    public static String constructRecodeMapEntry(String token, Long code) {
        StringBuilder sb = new StringBuilder(token.length() + 16);
        return EncoderRecode.constructRecodeMapEntry(token, code, sb);
    }

    private static String constructRecodeMapEntry(String token, Long code, StringBuilder sb) {
        sb.setLength(0);
        return sb.append(token).append("\u00b7").append(code).toString();
    }

    public static String[] splitRecodeMapEntry(String value) {
        int pos = value.toString().lastIndexOf("\u00b7");
        return new String[]{value.substring(0, pos), value.substring(pos + 1)};
    }
}

