/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops;

import org.apache.sysds.common.Types;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.lops.LopProperties;
import org.apache.sysds.lops.LopsException;
import org.apache.sysds.runtime.instructions.InstructionUtils;

public class CumulativePartialAggregate
extends Lop {
    private Types.AggOp _op;

    public CumulativePartialAggregate(Lop input, Types.DataType dt, Types.ValueType vt, Types.AggOp op, LopProperties.ExecType et) {
        super(Lop.Type.CumulativePartialAggregate, dt, vt);
        if (op != Types.AggOp.SUM && op != Types.AggOp.PROD && op != Types.AggOp.SUM_PROD && op != Types.AggOp.MIN && op != Types.AggOp.MAX) {
            throw new LopsException("Unsupported aggregate operation type: " + (Object)((Object)op));
        }
        this._op = op;
        this.init(input, dt, vt, et);
    }

    private void init(Lop input, Types.DataType dt, Types.ValueType vt, LopProperties.ExecType et) {
        this.addInput(input);
        input.addOutput(this);
        this.lps.setProperties(this.inputs, et);
    }

    @Override
    public String toString() {
        return "CumulativePartialAggregate";
    }

    private String getOpcode() {
        switch (this._op) {
            case SUM: {
                return "ucumack+";
            }
            case PROD: {
                return "ucumac*";
            }
            case SUM_PROD: {
                return "ucumac+*";
            }
            case MIN: {
                return "ucumacmin";
            }
            case MAX: {
                return "ucumacmax";
            }
        }
        return null;
    }

    @Override
    public String getInstructions(String input, String output) {
        return InstructionUtils.concatOperands(this.getExecType().name(), this.getOpcode(), this.getInputs().get(0).prepInputOperand(input), this.prepOutputOperand(output));
    }
}

